// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIYfXDrawer, PIFuncDrawer
// Drawer Y=f(X)      E.Aubourg, R. Ansari  96-02
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIYFXDRW_H
#define PIYFXDRW_H

#include "pisysdep.h"
#include "parradapter.h"
#include "pidrawer.h"

// ----------------------------------------------------------
// Classe de traceur de points/fonction Y=F(x)
// Trace Y=ay->Value() = f(X= ax->Value()) si ax et ay != NULL
// Trace Y=ax->Value() = f(X= ax->X())  si ay == NULL
 
class P1DArrayAdapter;
class PIYfXDrawer : public PIDrawer {
public:
                     PIYfXDrawer(P1DArrayAdapter* ax, P1DArrayAdapter* ay, bool ad);
  virtual           ~PIYfXDrawer();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
 // Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);

protected:
  P1DArrayAdapter* mAx;
  P1DArrayAdapter* mAy;
  int mSz;
  bool mAdDO;
  long NptDraw; // nombre de points effectivement dessines dans la fenetre
};

// ----------------------------------------------------------
// Classe de traceur de fonction  double = f(fouble)
// ----------------------------------------------------------

class PIFuncDrawer : public PIDrawer {
public:
  typedef double(*FUNC)(double);
                     PIFuncDrawer(FUNC);
  virtual           ~PIFuncDrawer();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);

 // Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);

protected:
  FUNC               mFunc;
};

#endif
