// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour les classes 
// PixelMap/SphericalMap/LocalMap  de Sophya
//                                      Reza 11/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMSKYMAPADAPTER_H_SEEN
#define NOMSKYMAPADAPTER_H_SEEN

#include "nomgadapter.h"
#include "tmatrix.h"
#include "pixelmap.h"



//----------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet PixelMap<T> 
//----------------------------------------------------------------

template <class T> 
class NOMAdapter_PixelMap : public NObjMgrAdapter {
public:
				NOMAdapter_PixelMap(PixelMap<T>* m = NULL);
  virtual			~NOMAdapter_PixelMap();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os, int lev=0);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual void			MeanSig(T& gmoy, T& gsig);
  virtual void			Project_Mol(TMatrix<T> & mtx, T defval=0.);

protected:
  PixelMap<T>* mMap;
};

// Class Interface NTuple pour PixelMap<T>

template <class T> 
class NTupInt_PixelMap : public NTupleInterface {
public:
			NTupInt_PixelMap(PixelMap<T>* m);
  virtual		~NTupInt_PixelMap();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  PixelMap<T>* mMap;
  mutable r_8 mRet[8];
};

// Valeur par defaut pour la projection MolleWeide, en dehors de la sphere 
void Set_Project_Mol_DefVal(double def);

#endif
