#define TC r_8

int lmax = 255;
int l0 = 140;
TVector< TC > clin(lmax+1);
for(int l=0; l<lmax; l++) {
  double xx = (l-l0)/10.;
  clin(l) = 3.e-2 -1.e-4*l + 0.1*exp(-xx*xx);
}

KeepObj(clin);
// Compute map from spectra
SphericalTransformServer< TC > ylmserver;
int mtp = 200;  // Pixelisation theta-phi
SphereThetaPhi< TC > map(mtp);
PrtTim("-->Appel GenerateFromCl");
ylmserver.GenerateFromCl(map, mtp,  clin, 0.);

KeepObj(map);

Alm< TC > alm;
PrtTim("-->Appel DecomposeToAlm");
ylmserver.DecomposeToAlm(map, alm,  lmax, 0., 0);

cout << alm ; 

TVector< TC > clfalm = alm.powerSpectrum();

KeepObj(clfalm);
PrtTim("-->Appel DecomposeToCl");
Vector clfm = ylmserver.DecomposeToCl(map, lmax,  0.);
KeepObj(clfm);

SphereThetaPhi< TC > map2(mtp);
PrtTim("-->Appel GenerateFromAlm");
ylmserver.GenerateFromAlm(map2, mtp, alm);
KeepObj(map2); 
PrtTim("-->Calcul mapdiff");
SphereThetaPhi< TC > mapdiff = map-map2;
KeepObj(mapdiff);
