#include <stdio.h>
#include <stdlib.h>
#include "math.h"
#include <iostream>
#include <string>

#include "sopnamsp.h"
#include "simplex.h"
#include "histinit.h"
#include "pexceptions.h"
#include <typeinfo>
#include "timing.h"

int main(int narg, char* arg[])
{
  cout << " ---- Programme tsimplex.cc - Test de Minimisation simplex --- " << endl;
  int prt = 0;
  int tsel = -1;
  int rc = 0;
  if ((narg > 1) && (strcmp(arg[1],"-h") == 0)) {
    cout << " tsimplex: test de Minimisation simplex (classe MinZSimplex) \n"
	 << "   Usage: tsimplex [ISel (=-1,0,..,4) PrtLev (=0,1,2,...) \n" 
	 << "   defaut Isel=-1 (all) , PrtLev=0 \n " << endl;
    return rc;
  } 
  if (narg > 1) tsel = atoi(arg[1]);
  if (narg > 2) prt = atoi(arg[2]);
  try {
    SophyaInit();
    InitTim();
    rc = MinZSimplex::AutoTest(tsel, prt);
  }
  catch (PThrowable & exc) {
    cerr << " tsimplex.cc: Catched Exception (PThrowable)" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
    rc = 99;
  }
  catch (std::exception & e) {
    cerr << " tsimplex.cc: Catched std::xception "  
	 << " - what()= " << e.what() << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " tsimplex.cc: some other exception (...) was caught ! " << endl;
    rc = 97;
  }
  PrtTim("End tsimplex " );
  cout << " ---- Programme tsimplex.cc -  FIN  (Rc=" << rc << ") --- " << endl;
  return rc;
}
