#ifndef  FFTWServer_H_SEEN
#define  FFTWServer_H_SEEN

#include "machdefs.h"
#include "sspvflags.h"
#include "fftservintf.h"


// Classe implementant l'interface FFTServerInterface en 
// utilisant FFTW 

namespace SOPHYA {

#ifdef FFTW_V2_EXTSOP
class FFTWServerPlan;
#endif

class FFTWServer : public FFTServerInterface {
 public:
  FFTWServer(bool preserve_input=true);
  virtual ~FFTWServer();

  
  virtual FFTServerInterface * Clone();

  // Transforme unidimensionnelle , N-dimensionnel
  virtual void FFTForward(TArray< complex<r_8> > & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > & in, TArray< complex<r_8> > & out);
  virtual void FFTForward(TArray< r_8 > & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > & in, TArray< r_8 > & out,
			   bool usoutsz=false);

// Methodes statiques pour reordonner les donnees en 1-D
  static void ReShapetoReal(TArray< complex<r_8> > const & in, TArray< r_8 > & out, bool usz);
  static void ReShapetoCompl(TArray< r_8 > const & in, TArray< complex<r_8> > & out);

 protected:
#ifdef FFTW_V2_EXTSOP
 FFTWServerPlan * _p1df;
 FFTWServerPlan * _p1db;
 FFTWServerPlan * _pndf;
 FFTWServerPlan * _pndb;

 FFTWServerPlan * _p1drf;
 FFTWServerPlan * _p1drb;
 FFTWServerPlan * _pndrf;
 FFTWServerPlan * _pndrb;
#endif
 FFTArrayChecker<r_8> ckR8;
 bool _preserve_input; // if true, input arrays not overwritten
};

} // Fin du namespace

#endif
