# --------- File Darwin_g++_make.inc -------- 

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -framework Accelerate

#  Chemin et librairie pour PI 
PIINC = -I/usr/X11R6/include/ -I/sw/include
PILIBS = -L/sw/lib -lXm -L/usr/X11R6/lib  -lXt -lX11 


#  Flag preprocesseur
CPPFLAGS = -DDarwin -I$(SOPHYAINCP)  $(PIINC)
#  Def compilateur C et flags
CC = cc
CFLAGS = -fno-common -g -fPIC
#  With optimization flags 
# CFLAGS = -fno-common -g -fastf -mtune=G5 -fPIC
#  Def compilateur C++ et flags
CXX =  c++
CXXFLAGS = -fno-common -g -fPIC 
# CXXFLAGS = -fno-common -g -fastf -mtune=G5 -fPIC 
# flags specifiques pour templates repository...
CXXTEMPFLG =
#  Compilo fortran
FC = g77
FFLAGS =  
# Pour fabriquer les lib .a
AR = libtool 
ARFLAGS = -static -o 


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = dylib
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) $(CXXTEMPFLG) -dynamiclib 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 
LIBFORT = 

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYALIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST)  $(SOPBASELIBS)
SOPHYAEXTLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPPILIBLIST) $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation d'executables
CXXLINK = $(CXX) $(CXXFLAGS) -bind_at_load
#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -bundle 
