#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <iostream>

#include "sopnamsp.h"
#include "pisysdep.h"
#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PISTDWDG_H 
#include PIBWDG_H

/*  Composante graphique de trace de chaine de caracteres  */

// ---- Declaration de la classe StringDrawWdg --------
class StringDrawWdg : public PIBaseWdg
{
public:
// Les methodes ...

                  StringDrawWdg(PIContainerGen *par, char *nom,
                         int sx=10, int sy=10, int px=0, int py=0);
  virtual         ~StringDrawWdg();

// Traitement des evenements   
//  virtual void   Resize();
  virtual void   Draw(PIGraphic* g, int x0, int y0, int dx, int dy);

  virtual void   But1Press(int x, int y);
  virtual void   Keyboard(int key, PIKeyModifier kmod);

protected:
  PIFontAtt mFAtt,mSFAtt;
  PIFontSize mFSize, mSFSize;
  PIFontName mFName, mSFName;
  int mSL[10], mSH[10];
};


// ---- Declaration de la classe StringDrawWdg --------
class StringPosDrawWdg : public StringDrawWdg
{
public:
// Les methodes ...

                  StringPosDrawWdg(PIContainerGen *par, char *nom,
                         int sx=10, int sy=10, int px=0, int py=0);
  virtual         ~StringPosDrawWdg();
  inline void     SetTextDirection(PIGrTextDirection txtdir) { mTxtDir = txtdir; }

// Traitement des evenements   
//  virtual void   Resize();
  virtual void   Draw(PIGraphic* g, int x0, int y0, int dx, int dy);

protected:
  PIGrTextDirection mTxtDir;  
};

// ---- Declaration de la classe CompStringDrawWdg --------
class CompStringDrawWdg : public StringDrawWdg
{
public:
// Les methodes ...

                  CompStringDrawWdg(PIContainerGen *par, char *nom,
				    int sx=10, int sy=10, int px=0, int py=0);
  virtual         ~CompStringDrawWdg();
// Traitement des evenements   
//  virtual void   Resize();
  virtual void   Draw(PIGraphic* g, int x0, int y0, int dx, int dy);

protected:
};


/* ........................................................... */
/*     Classe StringDrawWdg (Implementation des methodes)             */
/* ........................................................... */

/* --Methode-- */
StringDrawWdg::StringDrawWdg(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdg(par, nom, sx, sy, px, py)

{
  mFAtt = PI_RomanFont;
  mFSize = PI_NormalSizeFont;
  mSFAtt = PI_NotDefFontAtt;
  mSFSize = PI_NotDefFontSize;
  mSFName = mFName = PI_CourierFont;
  for(int k=0; k<10; k++) 
    mSL[k] = mSH[k] = 0;
  ActivateKeyboard();
  ActivateButton(1);
}

/* --Methode-- */
StringDrawWdg::~StringDrawWdg()
{
}
 

/* --Methode-- */
void StringDrawWdg::Draw(PIGraphicGen* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
PIFontAtt att[4] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont, PI_BoldItalicFont};
PIFontSize fsz[5] = { PI_TinySizeFont, PI_SmallSizeFont, PI_NormalSizeFont, 
		      PI_LargeSizeFont, PI_HugeSizeFont };
PIFontName fn[4] = { PI_CourierFont, PI_HelveticaFont, 
		     PI_TimesFont, PI_SymbolFont};
char * fnstr[4] = { "Courier-Font", "Helvetica-Font", 
		     "Times-Font", "Symbol-Font"};
char * attstr[4] = { "RomanFont" , "BoldFont", "ItalicFont", "BoldItalicFont"};
char * fszstr[5] = { "TinySizeFont", "SmallSizeFont", "NormalSizeFont", 
		      "LargeSizeFont", "HugeSizeFont" };

if (g->kind() != PI_PSFileGraphics ) EraseWindow();


int ia=0, js=0;
int k;
for(k=0; k<4; k++)
  if (att[k] == mFAtt)  {ia = k; break; }
for(k=0; k<5; k++)
  if (fsz[k] == mFSize)  {js = k; break; }

if ((mFSize != mSFSize) || (mFAtt != mSFAtt))
  for(k=0; k<10; k++)
    mSL[k] = mSH[k] = 0;
PIFont f(16, PI_DefaultFont);
g->SelFont(f);
  g->SelForeground(PI_Black);
g->DrawString(50,24,attstr[ia]);
g->DrawString(XSize()/2,24,fszstr[js]);
 int fh,fa,fd;
 fh = f.GetFontHeight(fa, fd);
 cout << " FontSize= " << f.GetFontSize() << " FontHeight= " << fh << endl;
g->DrawFBox(XSize()/2-30, 24-fh+2, fh, fh);


g->SelForeground(PI_Black);
g->SelLine(PI_NormalLine);
g->DrawBox(4, 4, XSize()-8, YSize()-8);

g->SelForeground(PI_Yellow);
g->SelLine(PI_ThickLine);
g->DrawBox(XSize()/4, YSize()/4, XSize()/2, YSize()/2);
g->SelLine(PI_NormalLine);
g->DrawBox(XSize()/4+10, YSize()/4+10, XSize()/2-20, YSize()/2-20);
g->SelLine(PI_ThinLine);
g->DrawBox(XSize()/4+20, YSize()/4+20, XSize()/2-40, YSize()/2-40);



int xpos, ypos;
PIGrCoord asc, desc;
double sl, sh;
char * s1 = "0123456789";
char * s2 = "PI GUI Library";

g->SelLine(PI_NormalLine);
for(k=0; k<4; k++) {
  PIFont fx(14,fn[k]);
  fx.SetFontSz(mFSize);
  fx.SetFontAtt(mFAtt);
  g->SelFont(fx);
  g->SelForeground(PI_Red);
  xpos = (double)XSize()*0.3;
  ypos = (double)YSize()*0.2*k+50;
  g->DrawString(xpos, ypos, fnstr[k]);
  g->SelForeground(PI_Black);
  xpos = 20;
  ypos = (double)YSize()*(0.2*k+0.1)+50;
  g->DrawString(xpos, ypos, s1);
  if ((mSL[2*k] == 0) || (mSH[2*k] == 0)) {
    mSL[2*k] = g->CalcStringWidth(s1);
    mSH[2*k] = g->GetFontHeight(asc, desc);
  }
  sl = mSL[2*k];  sh = mSH[2*k];
  g->DrawBox(xpos-0.05*sl, ypos-1.*sh, sl*1.1, sh*1.2);
  xpos = XSize()/2+20;
  g->SelForeground(PI_Blue);
  g->DrawString(xpos, ypos, s2);
  if ((mSL[2*k+1] == 0) || (mSH[2*k+1] == 0)) {
    mSL[2*k+1] = g->CalcStringWidth(s2);
    mSH[2*k+1] = g->GetFontHeight(asc, desc);
  }
  sl = mSL[2*k+1];  sh = mSH[2*k+1];
  g->SelForeground(PI_Blue);
  g->DrawBox(xpos-0.05*sl, ypos-1.*sh, sl*1.1, sh*1.2);
  xpos = XSize()/2+20;
}

g->SelForeground(PI_Green);
g->SelLine(PI_ThinLine);
for(k=0; k<4; k++) {
  xpos = 0.2*(k+1)*(double)XSize();
  ypos = 0.2*(k+1)*(double)YSize();
  g->DrawLine(xpos, 0, xpos, YSize()-1);
  g->DrawLine(0, ypos, XSize()-1, ypos);
}
return;
}

/* --Methode-- */
void StringDrawWdg::Keyboard(int key, PIKeyModifier kmod)
{
PIFontName fn[4] = { PI_CourierFont, PI_HelveticaFont, 
		     PI_TimesFont, PI_SymbolFont};

bool fgref = true;
switch (key) {
 case 'r':
   mFAtt = PI_RomanFont;
   break;
 case 'b':
   mFAtt = PI_BoldFont;
   break;
 case 'i':
   mFAtt = PI_ItalicFont;
   break;
 case 'I':
   mFAtt = PI_BoldItalicFont;
   break;
 case 'C':
   mFName = PI_CourierFont;
   break;
 case 'H':
   mFName = PI_HelveticaFont;
   break;
 case 'T':
   mFName = PI_TimesFont;
   break;
 case 'S':
   mFName = PI_SymbolFont;
   break;
 case '1':
   mFSize = PI_TinySizeFont;
   break;
 case '2':
   mFSize = PI_SmallSizeFont;
   break;
 case '3':
   mFSize = PI_NormalSizeFont;
   break;
 case '4':
   mFSize = PI_LargeSizeFont;
   break;
 case '5':
   mFSize = PI_HugeSizeFont;
   break;
 default:
   fgref = false;
}

if (fgref) Refresh(); 

return;
}
/* --Methode-- */
void StringDrawWdg::But1Press(int x, int y)
{
  Send(Msg(), PIMsg_Active);
}

/* ........................................................... */
/*     Classe StringPosDrawWdg (Implementation des methodes)             */
/* ........................................................... */

/* --Methode-- */
StringPosDrawWdg::StringPosDrawWdg(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: StringDrawWdg(par, nom, sx, sy, px, py)

{
  mTxtDir = PI_TextDirectionHorizontal;
}

/* --Methode-- */
StringPosDrawWdg::~StringPosDrawWdg()
{
}
 

/* --Methode-- */
void StringPosDrawWdg::Draw(PIGraphicGen* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
PIFontAtt att[4] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont, PI_BoldItalicFont};
PIFontSize fsz[5] = { PI_TinySizeFont, PI_SmallSizeFont, PI_NormalSizeFont, 
		      PI_LargeSizeFont, PI_HugeSizeFont };
PIFontName fn[4] = { PI_CourierFont, PI_HelveticaFont, 
		     PI_TimesFont, PI_SymbolFont};
char * fnstr[4] = { "Courier-Font", "Helvetica-Font", 
		     "Times-Font", "Symbol-Font"};
char * attstr[4] = { "RomanFont" , "BoldFont", "ItalicFont", "BoldItalicFont"};
char * fszstr[5] = { "TinySizeFont", "SmallSizeFont", "NormalSizeFont", 
		      "LargeSizeFont", "HugeSizeFont" };

if (g->kind() != PI_PSFileGraphics ) EraseWindow();


int ia=0, js=0;
int k;
for(k=0; k<4; k++)
  if (att[k] == mFAtt)  {ia = k; break; }
for(k=0; k<5; k++)
  if (fsz[k] == mFSize)  {js = k; break; }

if ((mFSize != mSFSize) || (mFAtt != mSFAtt))
  for(k=0; k<10; k++)
    mSL[k] = mSH[k] = 0;
PIFont f(14, PI_DefaultFont, mFAtt);
g->SelFont(f);
g->SelForeground(PI_Black);
g->SelLine(PI_ThinLine);

g->DrawString(20,24,"StringPosDraw");
g->DrawString(XSize()/3,24,attstr[ia]);
g->DrawString(2*XSize()/3,24,fszstr[js]);


PIFont fx(14,fn[2]);
fx.SetFontSz(mFSize);
fx.SetFontAtt(mFAtt);
g->SelFont(fx);
int fh,fa,fd;
fh = fx.GetFontHeight(fa, fd);
cout << " FontSize= " << f.GetFontSize() << " FontHeight= " << fh << endl;


int xpos, ypos;
char * s1;

if (mTxtDir != PI_TextDirectionHorizontal) {
  xpos = 50;  ypos = 450;
  s1 = "V_Top-H_Left-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalLeft|PI_VerticalTop|PI_TextDirectionVerticalUp);  

  xpos = 100;  ypos = 400;
  s1 = "V_Top-H_Center-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalCenter|PI_VerticalTop|PI_TextDirectionVerticalUp);

  xpos = 150;  ypos = 350;
  s1 = "V_Top-H_Right-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalRight|PI_VerticalTop|PI_TextDirectionVerticalUp);

  xpos = 50;  ypos = 250;
  s1 = "V_Center-H_Left-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalLeft|PI_VerticalCenter|PI_TextDirectionVerticalUp);  

  xpos = 100;  ypos = 200;
  s1 = "V_Base-H_Center-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalCenter|PI_VerticalBaseLine|PI_TextDirectionVerticalUp);

  xpos = 150;  ypos = 150;
  s1 = "V_Bot-H_Right-TxDUp";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalRight|PI_VerticalBottom|PI_TextDirectionVerticalUp);


  xpos = 200;  ypos = 100;
  s1 = "V_Top-H_Left-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalLeft|PI_VerticalTop|PI_TextDirectionVerticalDown);  

  xpos = 250;  ypos = 150;
  s1 = "V_Top-H_Center-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalCenter|PI_VerticalTop|PI_TextDirectionVerticalDown);

  xpos = 300;  ypos = 200;
  s1 = "V_Top-H_Right-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalRight|PI_VerticalTop|PI_TextDirectionVerticalDown);

  xpos = 200;  ypos = 300;
  s1 = "V_Center-H_Left-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalLeft|PI_VerticalCenter|PI_TextDirectionVerticalDown);  

  xpos = 250;  ypos = 350;
  s1 = "V_Base-H_Center-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalCenter|PI_VerticalBaseLine|PI_TextDirectionVerticalDown);

  xpos = 300;  ypos = 400;
  s1 = "V_Bot-H_Right-TxDown";
  g->SelForeground(PI_Red);
  g->DrawLine(xpos-10, ypos, xpos+10, ypos); 
  g->DrawLine(xpos, ypos-50, xpos, ypos+50);
  g->SelForeground(PI_Black);
  g->DrawString(xpos, ypos, s1, 
		PI_HorizontalRight|PI_VerticalBottom|PI_TextDirectionVerticalDown);


  return;
}
// --------------- Vertical Top -----------------

xpos = 30;  ypos = 75;
s1 = "V_Top-H_Left";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalLeft|PI_VerticalTop);

xpos = XSize()/2;  ypos = 75;
s1 = "V_Top-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalCenter|PI_VerticalTop);

xpos = XSize()-30;  ypos = 75;
s1 = "V_Top-H_Right";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalRight|PI_VerticalTop);

// --------------- Vertical Center ----------------- 
xpos = 30;  ypos = 150;
s1 = "V_Center-H_Left";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalLeft|PI_VerticalCenter);

xpos = XSize()/2;  ypos = 150;
s1 = "V_Center-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalCenter|PI_VerticalCenter);

xpos = XSize()-30;  ypos = 150;
s1 = "V_Center-H_Right";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalRight|PI_VerticalCenter);
 
// --------------- Vertical BaseLine -----------------
xpos = 30;  ypos = 250;
s1 = "V_Base-H_Left";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalLeft|PI_VerticalBaseLine);

xpos = XSize()/2;  ypos = 250;
s1 = "V_Base-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalCenter|PI_VerticalBaseLine);

xpos = XSize()-30;  ypos = 250;
s1 = "V_Base-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalRight|PI_VerticalBaseLine);

// --------------- Vertical Bottom -----------------
xpos = 30;  ypos = 325;
s1 = "V_Bottom-H_Left";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalLeft|PI_VerticalBottom);

xpos = XSize()/2;  ypos = 325;
s1 = "V_Bottom-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalCenter|PI_VerticalBottom);

xpos = XSize()-30;  ypos = 325;
s1 = "V_Bottom-H_Center";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawString(xpos, ypos, s1, PI_HorizontalRight|PI_VerticalBottom);
 
return;
}

/* ........................................................... */
/*     Classe CompStringDrawWdg (Implementation des methodes)             */
/* ........................................................... */

/* --Methode-- */
CompStringDrawWdg::CompStringDrawWdg(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: StringDrawWdg(par, nom, sx, sy, px, py)

{
}

/* --Methode-- */
CompStringDrawWdg::~CompStringDrawWdg()
{
}
 

/* --Methode-- */
void CompStringDrawWdg::Draw(PIGraphicGen* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
PIFontAtt att[4] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont, PI_BoldItalicFont};
PIFontSize fsz[5] = { PI_TinySizeFont, PI_SmallSizeFont, PI_NormalSizeFont, 
		      PI_LargeSizeFont, PI_HugeSizeFont };
PIFontName fn[4] = { PI_CourierFont, PI_HelveticaFont, 
		     PI_TimesFont, PI_SymbolFont};
char * fnstr[4] = { "Courier-Font", "Helvetica-Font", 
		     "Times-Font", "Symbol-Font"};
char * attstr[4] = { "RomanFont" , "BoldFont", "ItalicFont", "BoldItalicFont"};
char * fszstr[5] = { "TinySizeFont", "SmallSizeFont", "NormalSizeFont", 
		      "LargeSizeFont", "HugeSizeFont" };

if (g->kind() != PI_PSFileGraphics ) EraseWindow();


int ia=0, js=0;
int k;
for(k=0; k<4; k++)
  if (att[k] == mFAtt)  {ia = k; break; }
for(k=0; k<5; k++)
  if (fsz[k] == mFSize)  {js = k; break; }

if ((mFSize != mSFSize) || (mFAtt != mSFAtt))
  for(k=0; k<10; k++)
    mSL[k] = mSH[k] = 0;
PIFont f(14, PI_DefaultFont, mFAtt);
g->SelFont(f);
g->SelForeground(PI_Black);
g->SelLine(PI_ThinLine);

g->DrawString(20,24,"StringDraw");
g->DrawString(XSize()/5,24,attstr[ia]);
g->DrawString(XSize()/3,24,fszstr[js]);


PIFont fx(14,fn[2]);
fx.SetFontSz(mFSize);
fx.SetFontAtt(mFAtt);
g->SelFont(fx);
int fh,fa,fd;
fh = fx.GetFontHeight(fa, fd);
cout << " FontSize= " << f.GetFontSize() << " FontHeight= " << fh << endl;

g->DrawCompString(XSize()/2,40,"10","-34",NULL);
g->DrawCompString(XSize()/2+60,40,"10","+78",NULL);
g->DrawCompString(XSize()/2+120,40, "10", NULL, "a");

int xpos, ypos;
char *s, *su, *sd;

// --------------- Vertical Top -----------------

xpos = 30;  ypos = 75;
s = "HLeftVTop";
su = "824";
sd = "ij";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalLeft|PI_VerticalTop);

xpos = XSize()/2;  ypos = 75;
s = "HCenVTop";
su = "76843";
sd = "abc";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalCenter|PI_VerticalTop);

xpos = XSize()-30;  ypos = 75;
s = "HRigVTop";
su = "76843";
sd = "abc";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalRight|PI_VerticalTop);

// --------------- Vertical Center ----------------- 
xpos = 30;  ypos = 150;
s = "HLeftVCen";
su = "32987";
sd = NULL;
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalLeft|PI_VerticalCenter);

xpos = XSize()/2;  ypos = 150;
s = "HCenVCen";
su = "32987";
sd = "klm";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalCenter|PI_VerticalCenter);

xpos = XSize()-30;  ypos = 150;
s = "HRigVCen";
su = "2";
sd = "alpha";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalRight|PI_VerticalCenter);

// --------------- Vertical BaseLine -----------------
xpos = 30;  ypos = 250;
s = "HLeftVBas";
su = "3";
sd = "beta";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalLeft|PI_VerticalBaseLine);

xpos = XSize()/2;  ypos = 250;
s = "HCenVBas";
su = "gamma";
sd = "44";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalCenter|PI_VerticalBaseLine);

xpos = XSize()-30;  ypos = 250;
s = "HRigVBas";
su = "55";
sd = "alpha";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalRight|PI_VerticalBaseLine);

// --------------- Vertical Bottom -----------------
xpos = 30;  ypos = 325;
s = "HLeftVBot";
su = "abc";
sd = "6";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalLeft|PI_VerticalBottom);

xpos = XSize()/2;  ypos = 325;
s = "HCentVBot";
su = NULL;
sd = "lm";
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalCenter|PI_VerticalBottom);

xpos = XSize()-30;  ypos = 325;
s = "HLeftVBot";
su = NULL;
sd = NULL;
g->SelForeground(PI_Red);
g->DrawLine(xpos-50, ypos, xpos+50, ypos); 
g->DrawLine(xpos, ypos-10, xpos, ypos+10);
g->SelForeground(PI_Black);
g->DrawCompString(xpos, ypos, s, su, sd, PI_HorizontalRight|PI_VerticalBottom);
 
return;
}

/* ........................................................... */
/*                       Classe PITApp                         */
/* ........................................................... */
class PITApp : public PIApplication {
public:
     PITApp(int narg=0, char* arg[]=NULL);
     ~PITApp();
     virtual void   Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
private :
  PIMenu* m[2];
  PIText* txt;
  PIWindow* mcurwin;
  PSFile *mPS;
};


/* --Methode-- */
PITApp::PITApp(int narg, char* arg[])
: PIApplication(300, 100, narg, arg)
{

//  Menus, les numeros ds AppendItem sont les numeros de messages
//  qui seront passes a Process() et permettent d'identifier l'action

//  Creation du premier menu  

m[0] = new PIMenu(Menubar(),"Actions");
m[0]->AppendItem("StringDrawWdg", 10101);
m[0]->AppendItem("StringPosDrawWdg", 10102);
m[0]->AppendItem("CompStringDrawWdg", 10103);
m[0]->AppendItem("StringPosVertical", 10104);

m[0]->AppendItem("->eps", 10111);
m[0]->AppendItem("->ps", 10112);
m[0]->AppendItem("Exit", 10105);
// On accroche le menu au Menubar
AppendMenu(m[0]);


// Creation d' zone texte multiligne
txt = new PIText(MainWin(), "mltext", true, true, 290, 90, 5, 5);
txt->SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic,PIBK_elastic);
// txt->SetMutiLineMode(true);
txt->SetTextEditable(false);
txt->SetText("");
txt->SetText("StringDrawWdg/Keyboard: \n r,b,i,I (Roman,bold,italic,bolditalic) \n Size 1,2,3,4,5\n C,H,T,S (Courier,Helvetica,Times,Symbol)");

mcurwin = NULL;
mPS = new PSFile("pist.ps", PI_Auto);
SetReady();
}

/* --Methode-- */
PITApp::~PITApp()
{
delete m[0]; 
delete txt;
delete mPS;
}  

static int numpsf = 0;
static int nbwin = 0;
/* --Methode-- */
void PITApp::Process(PIMessage msg, PIMsgHandler* sender, void* /*data*/)
{

char strg[256];

// Gestion des actions en fonctions des messages

if ( ( ModMsg(msg) == PIMsg_Active) || (ModMsg(msg) == PIMsg_Close) ) {
  PIWdg *sndw;
  sndw = (PIWdg *)sender;      
  if (sndw->kind() ==  PIWindow::ClassId)  {
    if (ModMsg(msg) == PIMsg_Close)  { 
      delete (PIWindow *)sender;  
      mcurwin = NULL;  
      }
    else mcurwin = (PIWindow *)sender;
  }
}

else switch(UserMsg(msg))    {

    case 10101: // Creation d'un StringDrawWdg
      {
      nbwin++;
      sprintf(strg, "Creation StringDrawWdg   \n Fenetre No %d ", nbwin);
      sprintf(strg,"StringDrawWdg - %d", nbwin);
      PIWindow* wp = new PIWindow(this, strg, PIWK_normal,  400, 400, 150, 150);
      wp->SetAutoDelChilds(true);
      StringDrawWdg* exb  = new StringDrawWdg(wp, "sdrawwdg", 400, 400, 0, 0);
      exb->SetBinding(PIBK_fixed,PIBK_elastic,PIBK_elastic,PIBK_elastic);
      wp->SetUserData(exb);
      wp->Show();
      }
    break;

    case 10102: // Creation d'un StringPosDrawWdg
      {
      nbwin++;
      sprintf(strg, "Creation StringPosDrawWdg   \n Fenetre No %d ", nbwin);
      sprintf(strg,"StringPosDrawWdg - %d", nbwin);
      PIWindow* wp = new PIWindow(this, strg, PIWK_normal,  600, 400, 150, 150);
      wp->SetAutoDelChilds(true);
      StringPosDrawWdg* exb  = new StringPosDrawWdg(wp, "sposdrawwdg", 600, 400, 0, 0);
      exb->SetBinding(PIBK_fixed,PIBK_elastic,PIBK_elastic,PIBK_elastic);
      wp->SetUserData(exb);
      wp->Show();
      }
    break;

    case 10103: // Creation d'un StringPosDrawWdg
      {
      nbwin++;
      sprintf(strg, "Creation CompStringDrawWdg   \n Fenetre No %d ", nbwin);
      sprintf(strg,"CompStringDrawWdg - %d", nbwin);
      PIWindow* wp = new PIWindow(this, strg, PIWK_normal,  600, 400, 150, 150);
      wp->SetAutoDelChilds(true);
      CompStringDrawWdg* exb  = new CompStringDrawWdg(wp, "compposdrawwdg", 600, 400, 0, 0);
      exb->SetBinding(PIBK_fixed,PIBK_elastic,PIBK_elastic,PIBK_elastic);
      wp->SetUserData(exb);
      wp->Show();
      }
    break;

    case 10104: // Creation d'un StringPosDrawWdg-VerticalStringDir
      {
      nbwin++;
      sprintf(strg, "Creation StringPosDrawWdg-Vertical   \n Fenetre No %d ", nbwin);
      sprintf(strg,"StringPosDrawWdg-Vertical - %d", nbwin);
      PIWindow* wp = new PIWindow(this, strg, PIWK_normal,  400, 600, 150, 150);
      wp->SetAutoDelChilds(true);
      StringPosDrawWdg* exb  = new StringPosDrawWdg(wp, "sposdrawwdgvert", 400, 600, 0, 0);
      exb->SetTextDirection(PI_TextDirectionVerticalUp);
      exb->SetBinding(PIBK_fixed,PIBK_elastic,PIBK_elastic,PIBK_elastic);
      wp->SetUserData(exb);
      wp->Show();
      }
    break;


    case 10111:          // -> eps
      if (mcurwin) {
        char buff[64];
        sprintf(buff, "pist_%d.eps", numpsf);        numpsf++;
        printf("Creating EPS File %s (Encapsulated PostScript) \n", buff);
        PSFile *mps;
	mps = new PSFile(buff);
	mcurwin->PSPrint(mps,0,0);
	delete mps;
        }
      break;    
    
    case 10112:          // -> eps
      if (mcurwin) {
        printf("Current Window to Postscript file pist.ps \n");
	mcurwin->PSPrint(mPS,0,0);
        }
      break;        

    case 10105:          // Sortie d'application
      Stop();
      break;

  }
return;
}


// ................................................................
//                   programme principal 
// ................................................................

int main(int narg, char *arg[])
{
if ( (narg > 1) && (strcmp(arg[1],"-h") == 0) ) {
  printf("pist : StringDrawWdg  test \n");
  printf("  Usage : pidrstrtst [Xt options] \n");
  }
//  Creation de l'objet application et appel de Run()
PITApp* app = new PITApp(narg, arg);
// puts("appel de Application.Run() ... ");
app->Run();

delete app;
exit(0);
}


