/* data tables for Chapront95 expansion of DE200 for outer planets
 *
 * created by automatic conversion from original distribution files at
 * ftp://adc.gsfc.nasa.gov/pub/adc/archives/journal_tables/A+AS/109/181
 */

#include "chap95.h"

chap95_rec chap95_jupiter[] = {
	{ 0, { -3658015942., 0., -908357166., 0., -300271978., 0. }, 0. },
	{ 1, { 3211736., 0., -12066362., 0., -5380492., 0. },  },
	{ 0, { 4891337., 5430776., -9059458., 4045908., -3979137., 1598300. }, 0.0168745727060282 },
	{ 1, { -1952368., 3224556., -3665363., -6161184., -1519962., -2703058. },  },
	{ 0, { 589280., -62004., -1226982., 1326111., -536148., 568311. }, 0.0319163179770344 },
	{ 0, { -132797., 113059., 332715., -538044., 144358., -232591. }, 0.0404897860926306 },
	{ 0, { 19390., -8208., -31003., 153367., -13456., 65630. }, 0.0595473299932462 },
	{ 0, { -2479., -51303., 154576., 368773., 65961., 157222. }, 0.0831987723231718 },
	{ 1, { -170149., 190549., 249291., -236183., 108588., -106146. },  },
	{ 0, { -14177274., -32784827., -28623327., 13932421., -12074567., 6670491. }, 0.1015656301267251 },
	{ 1, { -3789129., 1413684., 2551178., 1957155., 1164465., 819456. },  },
	{ 0, { 12762505., 226609., -4837955., 12330917., -2405339., 5249055. }, 0.1121334694975955 },
	{ 1, { 547155., 1481967., -2013999., -2660987., -879208., -1179904. },  },
	{ 0, { -62226., -41759., -601831., 240767., -255949., 106231. }, 0.1235484250413803 },
	{ 0, { 38451., -38927., 103878., -40998., 43472., -16957. }, 0.1380033981088614 },
	{ 0, { 6892., -67712., 62422., 39405., 26942., 18451. }, 0.1534434914458037 },
	{ 0, { -75., 8062., -21151., -17198., -9222., -7580. }, 0.1694333239035300 },
	{ 0, { 35355., 38181., 70566., -4376., 30386., -2939. }, 0.1895181584594278 },
	{ 0, { -743715., -251198., -403257., 598432., -166123., 265466. }, 0.2002642151969322 },
	{ 0, { 5834437., -10339387., 9606367., 9534188., 3806370., 4385708. }, 0.2140513638608579 },
	{ 1, { 1033031., -590411., -1874404., 575478., -835406., 235620. },  },
	{ 2, { 514744., -29792., -180518., -472533., -83894., -204253. },  },
	{ 0, { 160903., -61277., -282564., -163689., -122933., -69902. }, 0.2282692683160305 },
	{ 0, { -27903., 23114., 66255., 2167., 28792., 688. }, 0.2391180221674930 },
	{ 0, { 4501., -5373., -15639., 12832., -6785., 5553. }, 0.2594200270243392 },
	{ 0, { -7016., 15969., 7639., -40047., 3504., -17544. }, 0.2773387700991547 },
	{ 0, { 12123., -71452., 49781., 137809., 20807., 61532. }, 0.2898870950096423 },
	{ 0, { 9304., 220632., -262203., -258243., -112815., -119757. }, 0.2988785450891279 },
	{ 0, { -326815., -368979., 836570., 374605., 369053., 187133. }, 0.3074463122377075 },
	{ 0, { -285560., 1568528., -1374181., -462165., -548097., -222596. }, 0.3260929459480317 },
	{ 1, { 61071., -241375., 291550., 243626., 110389., 123427. },  },
	{ 2, { 227305., 162244., -116416., 352218., -65158., 140646. },  },
	{ 0, { 132035., 23450., 116510., 219543., 39775., 92330. }, 0.3428930094327709 },
	{ 0, { -45107., 4887., -87029., -68971., -33182., -29857. }, 0.3524288275557115 },
	{ 0, { 11180., 1421., 46242., 3234., 18448., 1726. }, 0.3676619945918164 },
	{ 0, { 55636., 74415., 46443., -53844., 16908., -25824. }, 0.3817149836030239 },
	{ 0, { -38712., -7953., 29506., -14698., 13883., -4384. }, 0.4024967272931009 },
	{ 0, { 737722., -3325874., -1725701., 1468892., -912453., 541637. }, 0.4182255664674069 },
	{ 0, { 5843515., 17000877., -16425950., 5641739., -7208900., 1880856. }, 0.4281067291965077 },
	{ 1, { -2114864., 879909., -1266263., -2982111., -450528., -1332322. },  },
	{ 0, { -110808., 282843., -713054., 221824., -319044., 77631. }, 0.4373541005020147 },
	{ 0, { 27829., -71864., 150036., -117804., 67370., -49093. }, 0.4560888031675395 },
	{ 0, { 539822., 432225., -319385., 741980., -155058., 309230. }, 0.4797023746036813 },
	{ 1, { 353284., -620503., 706907., 178082., 295983., 93413. },  },
	{ 2, { -261070., -393195., 329623., -469610., 151911., -193312. },  },
	{ 0, { -2161367., -547925., 176106., -2360409., 138737., -1001848. }, 0.5007107300722267 },
	{ 0, { 27247697., -10878578., 11956310., 25892704., 4272604., 11389311. }, 0.5164419295757459 },
	{ 0, { 42877248480., -29362030594., 27366424342., 39132999157., 10686125728., 17489248357. }, 0.5296606590588865 },
	{ 1, { -15857296., -20344255., 19186229., -13052624., 8755482., -9908361. },  },
	{ 2, { 6609281., 13149967., -10297853., 6131752., -4439009., 2280289. },  },
	{ 0, { -18516226., 26000654., -21956172., -17721375., -8891106., -8274169. }, 0.5451799187785868 },
	{ 0, { 924882., -10894893., 8857638., 2001907., 3741179., 1161552. }, 0.5595376466726170 },
	{ 0, { 27311120., 29858821., -26928769., 14296744., -12217212., 5123580. }, 0.5795066100144535 },
	{ 1, { 13030129., -18873913., 10742323., 12477743., 4123021., 5837654. },  },
	{ 2, { -7424534., -11497916., 9860547., -3566473., 4394376., -1162013. },  },
	{ 0, { -26277687., -24566747., 22551607., -14225886., 10328130., -5247184. }, 0.5911608643334181 },
	{ 1, { 8339866., -11546546., 6481932., 8138775., 2473924., 3793057. },  },
	{ 0, { -712821., 106326., 116149., -425425., 75173., -183273. }, 0.6154942605989902 },
	{ 0, { 10367622., 10279698., -8594103., 9404066., -3937577., 3712537. }, 0.6326027345940838 },
	{ 1, { 897045., 857895., -751707., 469816., -332572., 171768. },  },
	{ 0, { 189069., -432469., 40216., 165708., -8464., 80857. }, 0.6444812066531010 },
	{ 1, { 358961., 188063., -197366., 119155., -93776., 37030. },  },
	{ 0, { 2801., -42321., 23044., 13212., 9231., 7153. }, 0.6631203366491857 },
	{ 0, { 4336., 3618., -871., -1752., -434., -1180. }, 0.6824152589010221 },
	{ 0, { -14481., -6624., 4573., -1496., 2554., -8. }, 0.7002707215510490 },
	{ 0, { -223890., 106356., -2013., -41001., 13805., -21357. }, 0.7195602591163895 },
	{ 1, { 28954., 129738., -23285., -9336., -9672., -11954. },  },
	{ 0, { 500290., -303873., -27592., 125875., -40399., 71687. }, 0.7280600120460897 },
	{ 0, { 729018., -876869., -461257., 537352., -184892., 325523. }, 0.7385877731868745 },
	{ 1, { -549774., 403499., -445388., -787700., -178960., -329235. },  },
	{ 0, { -154224., -136331., 129548., -90101., 64599., -32148. }, 0.7506622252123309 },
	{ 0, { 36827., 21410., -22046., 16972., -12019., 7006. }, 0.7602186192346818 },
	{ 0, { -9432., -929., 4761., -3712., 2630., -1835. }, 0.7714697369886172 },
	{ 0, { 2272., -244., -1058., 1139., -553., 579. }, 0.7851226034217180 },
	{ 0, { 236., 2440., 694., 90., 191., -135. }, 0.8150362349770407 },
	{ 0, { 2171., -25731., -8199., 18101., -2071., 8952. }, 0.8291920856012017 },
	{ 0, { -6488604., 1912961., -2051708., -5704251., -640826., -2468602. }, 0.8459901559232306 },
	{ 1, { 133871., -10089., -90464., 3174., -43566., 7399. },  },
	{ 2, { 3748., 19859., 25943., -57668., 8170., -24731. },  },
	{ 0, { 41412., 22074., -6939., -4045., -5698., -1697. }, 0.8578592213260567 },
	{ 0, { 574., 1501., -732., 4283., -255., 1685. }, 0.8738246080594192 },
	{ 0, { 2322., -1798., 335., 937., 88., 501. }, 0.8963147077496537 },
	{ 0, { -43604., -1899., 4040., -39896., 2661., -17151. }, 0.9105458422489332 },
	{ 0, { 3596., -6271., 379., 5996., 286., 2760. }, 0.9259391061890530 },
	{ 0, { -999582., 6287537., -5679601., -791405., -2413314., -507432. }, 0.9494173054851961 },
	{ 1, { 111599., -339713., 235481., 52027., 98992., 33925. },  },
	{ 2, { -33602., -140395., 93339., -35641., 41369., -10865. },  },
	{ 0, { 149940., -187453., 95997., 203410., 38908., 91533. }, 0.9614421422806174 },
	{ 0, { 46262., 123227., -97700., -14018., -43879., -8187. }, 0.9766842863215204 },
	{ 0, { -150852., -63931., 82864., -16270., 39997., -7673. }, 0.9902969827486889 },
	{ 0, { 580431., 130968., -306415., 215177., -145258., 96440. }, 1.0007147457558208 },
	{ 0, { -315446., -113604., 191678., -91901., 90254., -41025. }, 1.0094608196461621 },
	{ 1, { -3456., -446353., 229052., 185524., 103258., 88674. },  },
	{ 0, { -189618., 113597., 8806., -140678., 6615., -64661. }, 1.0246980386783211 },
	{ 0, { 4202483., 3000173., -2459447., 3363962., -1179328., 1385544. }, 1.0482030530764612 },
	{ 1, { 1203874., -292900., 70065., 779465., 3811., 351179. },  },
	{ 0, { 735702407., -1021641460., 944902088., 667150510., 387126729., 310854521. }, 1.0592824949737543 },
	{ 1, { -225227., -2656169., 2070353., -678917., 860531., -321583. },  },
	{ 0, { -906103., 1248865., -1249024., -614151., -510434., -296157. }, 1.0735437556293621 },
	{ 0, { 133104., -244102., 224418., -12870., 91960., 2555. }, 1.0875704154537504 },
	{ 0, { -98191., 334119., -93120., 114027., -39453., 36051. }, 1.1091289342301658 },
	{ 1, { 131527., 1551., 58039., -54878., 19569., -21191. },  },
	{ 2, { 65753., -188377., 68757., -76650., 28565., -25385. },  },
	{ 0, { 61867., -343846., 16261., -113012., 8972., -35330. }, 1.1225031990563263 },
	{ 0, { -7347., 137455., 17960., 22121., 5845., 4618. }, 1.1328877109810458 },
	{ 0, { 11044., -88733., -25019., 37631., -8977., 18971. }, 1.1464066922869334 },
	{ 0, { 11350781., -248125., 270190., 10489566., -145232., 4511204. }, 1.1622993228682923 },
	{ 0, { -52127., 35850., -14691., -77957., -5084., -33671. }, 1.1728440239417584 },
	{ 1, { -12008., 23292., -2942., -7282., -1291., -3563. },  },
	{ 0, { 4294., 460., -3058., 3439., -1373., 1474. }, 1.1878668274609869 },
	{ 0, { -1289., -734., 1786., -2248., 786., -941. }, 1.1998692758026896 },
	{ 0, { 361., -793., 308., -1262., 122., -515. }, 1.2317935880659059 },
	{ 0, { -195., 2534., -191., 3923., -67., 1609. }, 1.2448441509199817 },
	{ 0, { -5385., -19904., 6349., -3489., 3158., -1221. }, 1.2560282933480911 },
	{ 0, { 413790., -613072., 546872., 412919., 228594., 191066. }, 1.2653944427657104 },
	{ 1, { -20115., 4841., -30066., -2156., -12194., -733. },  },
	{ 0, { -56810., -2443., 14410., -37878., 7539., -15830. }, 1.2776927606634534 },
	{ 1, { -883., -20034., 8211., 10587., 3489., 5153. },  },
	{ 0, { -2444., 1465., 414., 793., 279., 259. }, 1.2924980461987274 },
	{ 0, { 864., -632., -623., -218., -312., -55. }, 1.3014788911147197 },
	{ 0, { 26233., -115536., 1588., -54448., 260., -17749. }, 1.3673745438817879 },
	{ 0, { -366768., 241272., -241508., -348534., -93295., -154126. }, 1.3764442873088090 },
	{ 1, { -4898., -22923., 39935., -25211., 16711., -10168. },  },
	{ 0, { 7481., -4670., -7877., -4002., -3598., -1348. }, 1.3867469996002664 },
	{ 0, { -2408., 1756., 2965., 1290., 1336., 416. }, 1.3958662188525488 },
	{ 0, { 972., -751., -912., -28., -417., 39. }, 1.4068178503492994 },
	{ 0, { -20343., 4804., -6579., -18594., -2298., -8037. }, 1.4396065958679622 },
	{ 0, { 894., 1313., 1992., 632., 793., 162. }, 1.4496940872610145 },
	{ 0, { -1983., -4631., -7582., 723., -2974., 660. }, 1.4625845924962999 },
	{ 0, { 648492., 510288., -503142., 612739., -227097., 254982. }, 1.4790870471301645 },
	{ 1, { -7847., 5399., -12816., -32834., -5768., -13533. },  },
	{ 2, { -5935., 4107., 3696., -8454., 1585., -3763. },  },
	{ 0, { 471., -326., 1178., -492., 455., -210. }, 1.5004111597792062 },
	{ 0, { -1102., 5980., -5712., -389., -2409., -319. }, 1.5140608680143952 },
	{ 0, { 235., -531., 427., -154., 168., -42. }, 1.5277453924778683 },
	{ 0, { 1530., 1846., -2090., 2162., -918., 867. }, 1.5510420454912401 },
	{ 0, { -8695., -5270., 3702., -11973., 1786., -4877. }, 1.5653775377343770 },
	{ 0, { 108442., 13977., -7635., 130460., -5580., 54970. }, 1.5750243622459430 },
	{ 0, { 12988439., -44123991., 40567288., 11522384., 17076170., 6015693. }, 1.5888946239094504 },
	{ 1, { -297436., -96470., 75756., -224551., 37973., -97866. },  },
	{ 2, { -140095., 49206., -15492., -114871., -4072., -51280. },  },
	{ 0, { -213784., 360331., -204961., -174648., -85958., -85816. }, 1.5999174688094493 },
	{ 0, { 34848., -82622., 33382., 30061., 14595., 15488. }, 1.6100691344943834 },
	{ 1, { 43010., 10308., -12996., 14235., -6844., 6576. },  },
	{ 0, { -1221., -3776., 845., 910., 489., 461. }, 1.6263710325060152 },
	{ 0, { 554., 745., -310., -340., -171., -141. }, 1.6392210890659527 },
	{ 0, { 20026., -16502., -3852., -9369., -2306., -3026. }, 1.6820002884969334 },
	{ 0, { 813659., -336143., 300160., 724773., 109085., 319540. }, 1.6916922798012188 },
	{ 1, { 1602., -17457., 27667., -10914., 11558., -4357. },  },
	{ 0, { -5880., 742., -5245., -7508., -2092., -3141. }, 1.7051957386154943 },
	{ 0, { 1260., 203., 1855., 1795., 753., 722. }, 1.7137017697983383 },
	{ 0, { -181., 118., 893., -230., 356., -133. }, 1.7715707154892435 },
	{ 0, { 715., -2305., -3568., 635., -1416., 471. }, 1.7804397794409668 },
	{ 0, { 100206., -23631., 4854., 93727., 818., 43069. }, 1.7946296659726320 },
	{ 1, { 4224., -2685., 2729., -6839., 1031., -2737. },  },
	{ 2, { 84., 2460., 356., -441., 163., -287. },  },
	{ 0, { -3928., 2396., -1944., -4367., -655., -1968. }, 1.8082885005321963 },
	{ 1, { -1281., -1070., 1425., -1360., 663., -508. },  },
	{ 0, { -434., -572., -639., 581., -222., 273. }, 1.8824124715680111 },
	{ 0, { 5875., -12921., -96., 9965., 681., 4780. }, 1.8981641851181350 },
	{ 1, { 3309., -927., -4565., 1029., -1995., 584. },  },
	{ 0, { -14234., 16692., -15551., -9091., -6255., -4365. }, 1.9094415371356366 },
	{ 1, { -5299., -4657., 1995., -4393., 1032., -1732. },  },
	{ 0, { -215., 526., -123., -7., -42., -32. }, 1.9243893317056575 },
	{ 0, { -1607., 1027., -1015., -1384., -397., -623. }, 1.9690057130935361 },
	{ 0, { 907., -182., 55., -552., -12., -217. }, 1.9888685259410335 },
	{ 0, { 80093., 1775., -15336., 49616., -8505., 21779. }, 2.0075896690458515 },
	{ 1, { 3675., 886., 9437., 1003., 3841., 302. },  },
	{ 2, { -2718., 2441., 1312., 2111., 647., 750. },  },
	{ 0, { -749., 2213., 3067., 2387., 1321., 864. }, 2.0177406604319246 },
	{ 0, { 82., 445., -97., 12., -47., -15. }, 2.0452450030168667 },
	{ 0, { 939., 145., -364., 1452., -175., 622. }, 2.0918668035808388 },
	{ 0, { 29763., -11270., 1340., 26747., 35., 12241. }, 2.1052596067061962 },
	{ 1, { -752., -10176., 11464., -2886., 4981., -1015. },  },
	{ 0, { -122433., -1948247., 1789021., -131787., 769924., -8458. }, 2.1185267640432053 },
	{ 1, { -14746., -2745., 3642., -14273., 1472., -6101. },  },
	{ 2, { -1381., -4337., 4157., -766., 1816., -296. },  },
	{ 0, { 207., 2382., -2373., 455., -1016., 119. }, 2.1318821280894955 },
	{ 0, { 317., -2045., -1566., 2287., -544., 1086. }, 2.2071860619320218 },
	{ 0, { 45591., -42445., 35109., 42326., 14234., 19311. }, 2.2209783021218397 },
	{ 1, { 100., -868., 334., -2387., 63., -853. },  },
	{ 2, { -274., 556., 48., -449., -11., -223. },  },
	{ 0, { 347., -11., -113., -232., -65., -97. }, 2.3082627901909945 },
	{ 0, { 16054., -5418., 3307., 5345., 1043., 2606. }, 2.3219886353180517 },
	{ 1, { -19., -205., 4127., -783., 1741., -387. },  },
	{ 2, { -647., 309., -95., 84., -24., 13. },  },
	{ 0, { 2409., -2117., -2607., -228., -1170., 136. }, 2.4200734218253461 },
	{ 1, { 19., -536., 414., 216., 214., 119. },  },
	{ 0, { 2201., 3681., -3051., 2808., -1347., 1419. }, 2.4294275957278497 },
	{ 0, { -423., 745., -737., -631., -315., -318. }, 2.4385609820738123 },
	{ 0, { 300., -1484., -1399., 755., -530., 425. }, 2.5260130486716892 },
	{ 0, { 5490., -1919., 480., 4689., 156., 2132. }, 2.5361042359568997 },
	{ 1, { 215., -174., 275., -263., 81., -64. },  },
	{ 0, { 308., -156., 185., 292., 82., 121. }, 2.5459330159552604 },
	{ 0, { 5463., 46., 202., 1602., -48., 766. }, 2.6374295145352566 },
	{ 1, { 581., 381., 1106., 451., 460., 165. },  },
	{ 0, { -36662., -85712., 78236., -34663., 34443., -12759. }, 2.6481663000165407 },
	{ 0, { 1477., -1072., -1320., -336., -622., -3. }, 2.7397040327703399 },
	{ 0, { 1659., -2071., 2391., 2294., 963., 1120. }, 2.7490048220101793 },
	{ 1, { -1336., -455., -28., -609., -7., -260. },  },
	{ 0, { 1366., -1582., -496., 1101., -173., 602. }, 2.8494750099923127 },
	{ 1, { 141., -92., 188., -517., 50., -205. },  },
	{ 2, { -23., 180., 65., -168., 19., -81. },  },
	{ 0, { 1495., 362., 78., -117., -5., -23. }, 2.9530548702113095 },
	{ 1, { 107., 70., 510., 245., 223., 92. },  },
	{ 0, { 497., -250., -298., -554., -148., -215. }, 3.0510128159210788 },
	{ 0, { 602., -271., -371., 232., -153., 154. }, 3.1654820818460752 },
	{ 0, { -3037., -3424., 3284., -2814., 1483., -1134. }, 3.1775127563235914 },
	{ 0, { 483., 216., 36., -224., 1., -77. }, 3.2694305438716178 },
	{ 0, { 4935., 381., -381., 4408., -298., 2013. }, 3.3406022698986924 },
	{ 0, { 235., -159., -104., -386., -58., -142. }, 3.3695779911862527 },
	{ 0, { 339., -47., -126., -82., -67., -13. }, 3.4790904552288531 },
	{ 0, { -5663., -29987., 27509., -5003., 11933., -2162. }, 6.2830762443769794 },
	{ 0, { -59., -82., -23., 24., -12., 18. }, 8.4686530580615642 },
	{ 0, { -17635., 511., -921., -16011., 697., -7231. }, 10.2131290491330340 },
	{ 0, { -227., 115., -23., -264., 11., -116. }, 10.2220725794374050 },
	{ /* end jupiter */ -1,  },
};

chap95_rec chap95_saturn[] = {
	{ 0, { 359537177., 0., -7206382337., 0., -2991243838., 0. }, 0. },
	{ 1, { -20377631., 0., 15883341., 0., 8071624., 0. },  },
	{ 0, { -64236683., -52860196., 142442224., -49744952., 58042432., -24365782. }, 0.0168745727060282 },
	{ 0, { 30177751., 18129933., -67656128., 22849231., -27163043., 12315751. }, 0.0265670063186787 },
	{ 1, { -8215259., 21212644., -23554648., -50768821., -12209063., -18901172. },  },
	{ 0, { 1964057., 724735., -4686899., 1417179., -1646759., 941321. }, 0.0493811968866401 },
	{ 1, { -134000., 3348965., -10011640., -8728398., -4234207., -2535628. },  },
	{ 0, { 5686743., 3475773., -334368., 3091703., 72747., 926256. }, 0.0662237107929899 },
	{ 0, { 554020., 1079938., -2966895., -1601162., -1509110., -278930. }, 0.0843726142307477 },
	{ 0, { 4610964., 21987586., 31945199., -5263812., 13882828., -4598499. }, 0.1010129457774524 },
	{ 0, { -66034588., -94070401., 111667599., -68387008., 47456033., -25071683. }, 0.1128014605528121 },
	{ 1, { -4294328., -12886739., 37728596., -1754644., 11349347., 1748900. },  },
	{ 0, { 6081642., 23561987., -38577166., -9734586., -12217167., -502775. }, 0.1245386660916166 },
	{ 0, { -11635904., -19574871., 36907731., -11918213., 11119486., -6364841. }, 0.1376921108585382 },
	{ 0, { 104499813., 75674727., -132241710., 152846005., -35848667., 59734045. }, 0.1532223867622918 },
	{ 0, { -119336309., -65929841., 110429555., -174948245., 28176754., -66225503. }, 0.1635156403544941 },
	{ 1, { 52564319., -48818442., 77555859., 94135021., 31177405., 26437148. },  },
	{ 2, { 56660530., 23619473., -35687037., 84928050., -8020678., 31023884. },  },
	{ 0, { 59047999., -9112158., 18208825., 74844916., 8173908., 26476289. }, 0.1849404508049137 },
	{ 0, { -195085048., 130948239., -157301623., -207103141., -57416134., -80784650. }, 0.1994326216901347 },
	{ 0, { 61319082350., -72972816459., 68513342186., 55646924765., 25657191842., 26113032275. }, 0.2133734516582497 },
	{ 1, { 58897194., 107088220., -104901917., 68459614., -34345682., 47420026. },  },
	{ 2, { -100212137., 21822222., -43604349., -89401596., -12674282., -32150723. },  },
	{ 0, { 18845535., -49223999., 35615797., 26623302., 16402647., 15391365. }, 0.2335002178020494 },
	{ 0, { -4180907., 4465884., 38621., -479609., 814285., -1219056. }, 0.2510310507212479 },
	{ 1, { -18966213., 1413107., 11641634., -15116208., 6182492., -9256829. },  },
	{ 0, { 3257184., 9509868., -11066286., -7321147., -6968557., -3079573. }, 0.2622227446243415 },
	{ 0, { -1404116., -417364., 2858988., 1478988., 1856930., 162727. }, 0.2775489797512927 },
	{ 0, { 1467706., 1107543., -4409004., 226468., -2199319., 678454. }, 0.2926511843672006 },
	{ 0, { -63623237., -37507272., 39122548., -67696931., 18154709., -27796755. }, 0.3162439145857524 },
	{ 1, { -3829645., 1269380., -9251051., -8961610., -4871745., -2487901. },  },
	{ 2, { 1909651., 1468024., -7914338., 6203925., -2960534., 3971621. },  },
	{ 0, { 6281876., -3642612., -4761114., 23447042., 286480., 12241212. }, 0.3340526064764550 },
	{ 0, { -5802348., 5752123., -4991225., -30347977., -5911367., -14358380. }, 0.3467225133858732 },
	{ 0, { 7539581., -27234846., 89254406., 72087653., 50683522., 25464083. }, 0.3654342931118227 },
	{ 1, { -16970597., 906805., 25342361., -65544284., 5459306., -34110644. },  },
	{ 2, { -5198192., 11224087., -33200716., -38195205., -20121188., -14873633. },  },
	{ 0, { -2145161., 31156404., -111624554., -59422928., -60033284., -17237400. }, 0.3766625707476834 },
	{ 0, { -2433702., -8759560., 35127703., 5461246., 17518688., -795950. }, 0.3868793178145906 },
	{ 0, { 3948221., 3250926., -14710717., 6016597., -6668684., 4126312. }, 0.4021189702952532 },
	{ 0, { -64852219., -1152783., 37078116., -78426047., 17075754., -36402504. }, 0.4173317886569649 },
	{ 0, { 2598837096., -322512661., 333925850., 2403155625., 25718615., 1008149551. }, 0.4268085445169599 },
	{ 1, { -8046615., 50513333., -65775281., -14855286., -30373245., -5862741. },  },
	{ 0, { 14632122., -1627420., 391595., 27967394., 1503248., 13109492. }, 0.4393540871607130 },
	{ 0, { -3977607., 2348335., -4492336., -11638695., -3044963., -5280793. }, 0.4516261147924168 },
	{ 0, { 3891847., -6235742., 13257786., 12849113., 7381680., 5287411. }, 0.4647357720725654 },
	{ 0, { -2681944., 5714068., -11275550., -8345687., -6000449., -3297402. }, 0.4765294470438712 },
	{ 1, { -3310032., -1656488., 6283436., -7934719., 2454880., -4374462. },  },
	{ 2, { 581001., -2310426., 4449727., 1912796., 2258154., 644572. },  },
	{ 0, { -543181., 190668., 100357., -477814., 102237., -296580. }, 0.4992649823773071 },
	{ 0, { 734019., 40318., 205332., 241668., 50065., 172083. }, 0.5130863461740709 },
	{ 0, { 34991657., -27811324., 27384011., 28671165., 10659597., 13066000. }, 0.5295353231453532 },
	{ 1, { -995667., 165111., 1788489., 16637., 818086., -43110. },  },
	{ 2, { -317358., -198759., -6708., 263693., 27631., 133736. },  },
	{ 0, { -31862., -65198., 73955., 29129., 36339., 15797. }, 0.5497097571860546 },
	{ 0, { -4929., 225052., -215444., -8168., -89868., -12808. }, 0.5633695884286543 },
	{ 0, { 24691., 22218., -9270., 18179., -4474., 5589. }, 0.5991350601911121 },
	{ 0, { 289471., 202198., -100019., 60710., -58404., 1113. }, 0.6158926177569189 },
	{ 1, { 99636., -158087., 49023., 12201., 5200., 13036. },  },
	{ 0, { -1368816., -1646305., 699872., -1449808., 365729., -462486. }, 0.6277831102482128 },
	{ 0, { 86066856., 61934875., -56200895., 80007767., -26961118., 30372088. }, 0.6401904307430363 },
	{ 1, { -1903624., 1069032., -956603., -1766047., -334714., -771306. },  },
	{ 2, { 388212., 231504., -217129., 594559., -86428., 243060. },  },
	{ 0, { 806222., 541401., -454902., 1046875., -196326., 413041. }, 0.6510631728715514 },
	{ 0, { -45865., -22253., 10036., -80738., 2915., -31853. }, 0.6610474418282967 },
	{ 0, { 7873., 2358., 3189., 5877., 1281., 2008. }, 0.6837277548947647 },
	{ 0, { -98664., 39992., -40413., -90837., -12525., -38879. }, 0.7043645359718698 },
	{ 0, { -1946., 3664., 10236., -357., 4293., -1167. }, 0.7177278015736290 },
	{ 0, { -284513., 3015890., 2554237., 521699., 1046024., 49179. }, 0.7348232721925007 },
	{ 1, { 192624., 52403., 33461., -150025., -105., -61152. },  },
	{ 0, { -574265., -320413., 457058., -572461., 214214., -240685. }, 0.7435248864377025 },
	{ 1, { 1145., -36334., 41717., 108651., 15647., 49114. },  },
	{ 0, { 4558., -12170., 12006., 2809., 4790., 1802. }, 0.7636282240814432 },
	{ 0, { -13700., 9256., -10447., -12051., -3998., -5133. }, 0.7781708314331308 },
	{ 0, { 2247., -693., 1592., 1083., 680., 202. }, 0.7950594399751412 },
	{ 0, { -1275., 5493., -6655., 924., -2492., 1116. }, 0.8129117802019118 },
	{ 0, { -1223., -19571., 23014., -16306., 6735., -10155. }, 0.8251778324059539 },
	{ 0, { 303076., 327040., 524629., -601728., 145475., -284414. }, 0.8382097667143232 },
	{ 1, { -68015., 68576., -104282., -95123., -56039., -18028. },  },
	{ 0, { 804121., 5204866., -4807644., 856208., -2083791., 112505. }, 0.8530682323228537 },
	{ 1, { 29622., -215766., 182882., 33800., 76379., -13007. },  },
	{ 0, { -13943., 51584., -40954., -8800., -23024., -3606. }, 0.8654403493251860 },
	{ 0, { 3328., -7556., 4381., 1661., 2910., -36. }, 0.8766682028622256 },
	{ 0, { -1505., 1631., -856., 784., -507., 674. }, 0.8895787094971168 },
	{ 0, { -7919., -1616., 1989., -5290., 1264., -2147. }, 0.9133756947048002 },
	{ 0, { -719., -2923., 1034., -5631., 504., -2040. }, 0.9236279354499169 },
	{ 0, { 235224., 39046., -67004., -248093., -51203., -88317. }, 0.9453092341234691 },
	{ 1, { 23462., -3456., -13540., 1977., -2121., 4776. },  },
	{ 2, { -14574., -833., 1399., 12342., 2166., 4371. },  },
	{ 0, { -26186., -43172., 35585., -24094., 17801., -8640. }, 0.9587102428763801 },
	{ 0, { 5306., 3426., -2598., 4654., -1521., 1836. }, 0.9687040706037242 },
	{ 0, { -1404., -1568., 973., -1250., 478., -476. }, 0.9844044794489883 },
	{ 0, { 710., 549., -640., -936., -297., -397. }, 1.0125530865194814 },
	{ 0, { -4798., 528., 2241., 2772., 1073., 1027. }, 1.0243303434648821 },
	{ 0, { 19204., -11735., -10052., -9127., -4600., -2887. }, 1.0350677988213037 },
	{ 0, { -70967., 104737., 71732., 36807., 31189., 9485. }, 1.0444890430562743 },
	{ 0, { -225798., 798684., 944928., 428637., 404105., 131989. }, 1.0535670598935039 },
	{ 0, { 421437., -821624., 460671., 296203., 193979., 145015. }, 1.0624723083698995 },
	{ 1, { 404141., 190563., -153412., 239290., -77801., 95534. },  },
	{ 0, { -6822., -2424., -12141., -503., -4568., -254. }, 1.0799687683920178 },
	{ 0, { 5231., 2124., 4765., -2411., 1681., -1002. }, 1.0944898935961935 },
	{ 0, { -4360., -571., -2843., 2544., -920., 1015. }, 1.1034700208578079 },
	{ 0, { 2352., -783., 1220., -2044., 355., -732. }, 1.1190075299813413 },
	{ 0, { -5735., 3169., 186., 5121., 420., 1436. }, 1.1356439922218147 },
	{ 0, { 26551., -30281., 5089., -56530., 4098., -12591. }, 1.1476494842799982 },
	{ 0, { 182096., 230606., 190305., 20362., 32484., -34547. }, 1.1561539197957733 },
	{ 1, { -46354., -35766., 25278., 21603., 6113., 24924. },  },
	{ 2, { -6693., -10691., -762., -24972., 5267., -3607. },  },
	{ 0, { 7509., -14080., 2266., 4828., -2812., 2396. }, 1.1724975800169239 },
	{ 0, { -1097., 4594., -221., -711., 861., -846. }, 1.1827508062529084 },
	{ 0, { 268., -1663., 197., 151., -139., 350. }, 1.1922546935063294 },
	{ 0, { 3821., -6929., -9691., -9738., -1997., -3976. }, 1.2526642649376578 },
	{ 1, { -3679., 2852., -872., 4458., -151., 647. },  },
	{ 0, { 103288., 30887., 44394., -80994., 5313., -31354. }, 1.2615381418438327 },
	{ 0, { 11722., -929., 20555., -32545., 6476., -10964. }, 1.2737411543354145 },
	{ 0, { -17778., 2234., -8752., -2076., -2194., -1934. }, 1.2848042137871682 },
	{ 1, { -807., -10464., -4345., -4583., -776., -1210. },  },
	{ 0, { -2021., 243., -476., 1775., -175., 485. }, 1.2966706439177036 },
	{ 0, { -414., 1251., 1334., 193., 402., 122. }, 1.3428511130177547 },
	{ 0, { -6545., 29273., 20095., -2836., 7521., 1278. }, 1.3563973340863262 },
	{ 1, { 13556., 3272., -1197., -10568., 545., -3663. },  },
	{ 0, { -180708., 208447., 210704., 176234., 95276., 55650. }, 1.3681253803708262 },
	{ 1, { 18503., 8458., -1041., -19835., 212., -7272. },  },
	{ 2, { -2022., 9714., 3806., 25., 1699., 1106. },  },
	{ 0, { 967., -692., -12., -1766., -76., -677. }, 1.3856345885533017 },
	{ 0, { 704., -587., -2388., 1139., -927., 144. }, 1.4516885121122214 },
	{ 0, { -2400., 3304., 8864., -6463., 3877., -1185. }, 1.4602508651959594 },
	{ 0, { 69982., 97834., 73391., 17685., 16742., -10304. }, 1.4727239692395073 },
	{ 1, { -11044., -13056., 19308., 14020., 3724., 10827. },  },
	{ 2, { -6082., -426., 3637., -7457., 3010., -854. },  },
	{ 0, { 2590., -1868., 1096., 1043., -731., -69. }, 1.4872423683478513 },
	{ 0, { -938., 62., 121., -521., 280., -164. }, 1.4985129994148070 },
	{ 0, { 1803., 2377., 1110., -3335., 260., -1477. }, 1.5652937634682971 },
	{ 0, { 64498., -5114., 68142., -30202., 22032., -11748. }, 1.5815555196973523 },
	{ 1, { -22825., 4620., 14325., -12393., 6615., -5873. },  },
	{ 2, { -7166., 4559., -5012., 2048., -1874., 652. },  },
	{ 0, { -2200., -10219., 11039., 3346., 4934., 1509. }, 1.5955514308541998 },
	{ 0, { 1099., 1374., -2363., -260., -1043., -86. }, 1.6049203503395801 },
	{ 0, { -1208., -104., 561., 969., 230., 560. }, 1.6737223157218182 },
	{ 0, { -86480., 70728., 67924., 86008., 31534., 31153. }, 1.6843589552967209 },
	{ 1, { 933., 1492., 4350., -2566., 1516., -847. },  },
	{ 2, { -1244., -445., -70., 369., 72., 345. },  },
	{ 0, { 1465., -2624., 397., -65., -76., -7. }, 1.6977622139834585 },
	{ 0, { 14992., 53026., 36206., 5674., 12375., -4229. }, 1.7889276713056903 },
	{ 1, { -1089., -6208., 2064., 7721., -744., 4049. },  },
	{ 2, { -1281., -2343., -210., 276., 49., 532. },  },
	{ 0, { 3295., -4264., -3112., 6622., -2534., 1159. }, 1.8013654629975304 },
	{ 1, { 1876., 442., -2702., -870., -615., -793. },  },
	{ 0, { 21586., 22255., 25169., -13704., 7397., -6814. }, 1.8952695349759525 },
	{ 1, { 1293., 636., 1855., -2161., 651., -493. },  },
	{ 2, { -1508., -959., -1185., 1162., -341., 540. },  },
	{ 0, { -837., -468., -77., 639., 49., 332. }, 1.9082748451618770 },
	{ 0, { -39181., 17943., 18554., 39996., 9033., 15315. }, 2.0006786235742782 },
	{ 1, { 70., 479., 1963., -746., 664., -147. },  },
	{ 2, { -729., 4., -323., -76., -29., 30. },  },
	{ 0, { -726., 389., 1661., 467., 647., 367. }, 2.0949703642270960 },
	{ 0, { -2813., 21512., 16741., 5023., 6930., 302. }, 2.1045989992211052 },
	{ 0, { 6314., -196., -4305., 3407., -2614., -923. }, 2.1133294411524268 },
	{ 0, { -1183., -1102., 1934., -946., 1020., -24. }, 2.1218152921149840 },
	{ 0, { 7013., 13819., 14243., -3085., 4615., -2198. }, 2.2116085451863530 },
	{ 1, { 548., 591., 1334., -724., 439., -127. },  },
	{ 2, { -499., -647., -721., 383., -233., 184. },  },
	{ 0, { -96., -348., -69., 163., -3., 83. }, 2.2246966026380783 },
	{ 0, { -16878., 3417., 3609., 17709., 2011., 6948. }, 2.3169860146393306 },
	{ 1, { -184., 273., 1066., -86., 376., 65. },  },
	{ 2, { -421., -143., -106., -9., 9., 50. },  },
	{ 0, { -1773., 10467., 5877., 4502., 2612., 236. }, 2.4212184393363345 },
	{ 1, { 100., -1698., -212., 1585., -581., 698. },  },
	{ 2, { -416., -532., 192., 38., 49., 218. },  },
	{ 0, { 922., 6585., 6161., 638., 2178., -274. }, 2.5279051498015881 },
	{ 1, { 305., 668., 969., -324., 338., -92. },  },
	{ 0, { -7788., -691., -557., 7570., 62., 3142. }, 2.6333307376329276 },
	{ 1, { -16., 174., 511., 158., 148., 85. },  },
	{ 0, { -2797., 3622., 2705., 2693., 1341., 812. }, 2.7374368855151237 },
	{ 0, { 1332., 523., -1008., -331., -394., -592. }, 2.7462646949156313 },
	{ 0, { -528., 3192., 2851., 1151., 1069., 178. }, 2.8441606111313287 },
	{ 1, { 54., 266., 527., 58., 138., 54. },  },
	{ 0, { -3128., -1136., -1090., 3069., -358., 1285. }, 2.9496547906250985 },
	{ 0, { -1332., 1366., 789., 1313., 449., 356. }, 3.0553439327040071 },
	{ 1, { 46., -504., -405., 221., -232., 58. },  },
	{ 0, { -722., 1469., 1417., 916., 574., 235. }, 3.1603882818225530 },
	{ 1, { -8., 210., 314., 24., 105., 6. },  },
	{ 0, { -1228., -704., -610., 1193., -210., 520. }, 3.2660150757959667 },
	{ 0, { 4966., 349., -230., 4527., -271., 2058. }, 3.3406700896158381 },
	{ 0, { -1003., 494., 345., 782., 229., 294. }, 3.3700954272546491 },
	{ 0, { -642., 504., 417., 592., 188., 175. }, 3.4766263286125869 },
	{ 0, { -5495., -30050., 27370., -5109., 11883., -2182. }, 6.2830758491321381 },
	{ 1, { 12., 3., -21., -32., -16., -11. },  },
	{ 0, { -127., 83., -47., -145., -13., -74. }, 8.4563910900857575 },
	{ 0, { -17655., 888., -832., -16055., 726., -7281. }, 10.2133651230379790 },
	{ 1, { -15., -178., 73., 27., 40., 18. },  },
	{ 0, { 10., 56., 204., -33., 91., -14. }, 10.2233419556680150 },
	{ /* end saturn */ -1,  },
};

chap95_rec chap95_uranus[] = {
	{ 0, { 13442911073., 0., -1930919457., 0., -1035250405., 0. }, 0. },
	{ 1, { 54660667., 0., 47196247., 0., 21339801., 0. },  },
	{ 0, { -6259970., -59715827., 56026092., -14879299., 23598892., -7731463. }, 0.0168745727060282 },
	{ 0, { 5314993., 24095734., -17644181., 11961180., -6018215., 6587969. }, 0.0271621114651946 },
	{ 0, { 816977., 27548111., -6448076., -468658., -4057252., -1448251. }, 0.0379771556339559 },
	{ 0, { -1624242., 11338144., -20621799., 1496992., -5688694., 248222. }, 0.0558181533535525 },
	{ 0, { 131350139561., 139711771423., -127221614269., 120945393838., -57589414088., 51010747052. }, 0.0747869939016385 },
	{ 1, { 83579181., -50475439., 18032923., 50477352., 27217847., 30911037. },  },
	{ 2, { 56177356., -62348507., 45006161., 56816875., 23394627., 20236290. },  },
	{ 0, { -3192217., -67613872., 26532975., 31518890., 20804461., -5888651. }, 0.0851607526391989 },
	{ 0, { 41246376., 168261887., -122401100., -97532527., -40313762., 5947933. }, 0.1076082382556661 },
	{ 0, { -36235133., -140754409., 98201785., 64357246., 36255198., -9379330. }, 0.1131136321134916 },
	{ 1, { 90255544., -46394994., -47508423., 75649120., 8064423., 19668708. },  },
	{ 0, { -32042356., -21687295., 28029568., 15213468., 1662570., -3156568. }, 0.1256919464048962 },
	{ 0, { 44969984., -2310664., -13084603., 20841905., 1428192., 12115421. }, 0.1384460864609660 },
	{ 0, { -524718966., -4511367463., 4156633821., -484927968., 1817662129., -148236372. }, 0.1495664992280332 },
	{ 0, { 61267776., 1565740., -24266489., 45519765., -3901964., 18298390. }, 0.1552897599647365 },
	{ 0, { -7222268., 4911333., 3283374., -6377102., -254066., -1537379. }, 0.1694039594031046 },
	{ 0, { 5873930., -4900474., -1827803., 7852582., -31798., 1819946. }, 0.1845250832150644 },
	{ 0, { 1077339., 18380396., -901066., -10767827., -265560., 162663. }, 0.2002468734837309 },
	{ 0, { -154311950., -219502970., 131091842., 178959446., 20655458., 5719299. }, 0.2141097583453364 },
	{ 0, { -5528333., 212500368., -111109179., -139612191., -43337512., -21342579. }, 0.2193685795401007 },
	{ 1, { -104517351., 177302072., 101064024., -75975513., -8816707., 3791842. },  },
	{ 0, { 173653756., 151082404., -200861767., -135511564., -29950212., -17024507. }, 0.2293024101260499 },
	{ 0, { -125918181., -44661266., 113832135., 56003631., 10092584., 6332126. }, 0.2359817391381943 },
	{ 0, { 47624832., 2554277., -41914694., -13040594., -2759654., -2423818. }, 0.2431604796510437 },
	{ 0, { -8805576., 2810717., 8600588., 666061., 636138., 663527. }, 0.2535948403663328 },
	{ 0, { 1249271., -2422256., -2280787., 1243851., -81187., -241977. }, 0.2733943804314553 },
	{ 0, { 90677., 14160054., 8529623., -8138579., 1686982., 1494393. }, 0.2885148535115661 },
	{ 0, { 1004449., -20392040., -8104371., 18545176., -2778508., 705194. }, 0.2992461358046305 },
	{ 1, { 5543727., 3362260., -1567031., -3163455., 585366., 471498. },  },
	{ 2, { 2655788., 6883407., 3736665., -5070470., 1464904., 724248. },  },
	{ 0, { 6192631., 6484479., 3731891., -6957619., 2642135., 445342. }, 0.3105692746147310 },
	{ 0, { -1442546., -845134., -640944., 1375084., -614517., 35173. }, 0.3190867931520337 },
	{ 0, { 683659., 282897., 363207., -694577., 243073., -261582. }, 0.3384589317094125 },
	{ 0, { 210243., 95767., -88268., -40253., -126237., -71385. }, 0.3483018025771290 },
	{ 0, { -122260., -61161., 139582., -75155., 89557., -59104. }, 0.3543646679104152 },
	{ 0, { -341621., -166635., -6649., -236115., -4011., -98828. }, 0.3749354720310226 },
	{ 0, { -34509., -47428., -33958., 69865., -15389., 28074. }, 0.3881544744399507 },
	{ 0, { 127606., 82441., 63875., -131276., 30216., -55026. }, 0.4044642096018178 },
	{ 0, { -55719., 35282., 53204., 42166., 20409., 8040. }, 0.4146735688956036 },
	{ 0, { 745574., -86708., 85642., 660718., 2349., 278769. }, 0.4267276978319757 },
	{ 0, { 46965., -63806., -140582., -2689., -51451., -6263. }, 0.4523712047583937 },
	{ 1, { -44676., -29125., -21496., 62165., -11514., 20667. },  },
	{ 0, { -47313., 131228., 153909., 13721., 54937., 13501. }, 0.4584750578982092 },
	{ 0, { 64299., -217224., -204896., -47815., -89991., -26071. }, 0.4786471499447322 },
	{ 0, { -216., 53443., -19130., -71538., -27839., -11228. }, 0.4920510287505367 },
	{ 0, { -151224., -75735., -3305., 268854., -6542., 67361. }, 0.5051499531573665 },
	{ 0, { 928196., 102377., -314167., -1414544., -33869., -402228. }, 0.5147029966036326 },
	{ 0, { -1724399., 110969., 999802., 2605327., 184425., 789530. }, 0.5199630930448305 },
	{ 0, { 40911206., -27399316., 26874089., 37399873., 10439229., 16767175. }, 0.5296669053399393 },
	{ 1, { 583136., 1214598., 1755827., -1272416., 584159., -311166. },  },
	{ 0, { 1173041., -1074191., -1886355., -1719260., -508991., -616258. }, 0.5369668320738028 },
	{ 0, { -202800., 314145., 489969., 260218., 136957., 100165. }, 0.5445620632918582 },
	{ 0, { 30834., -64556., -105954., -37083., -35677., -17746. }, 0.5559973222735549 },
	{ 0, { 388., 18963., 34845., -2990., 13141., -175. }, 0.5645354635177183 },
	{ 0, { -3029., -2222., -3901., 4299., -1477., 1512. }, 0.5864917785646289 },
	{ 0, { 364., -3970., 4198., -17799., 1736., -7653. }, 0.6024030347783642 },
	{ 0, { -64408., -16238., -14709., 52293., -7099., 22267. }, 0.6155618610057497 },
	{ 0, { -8702., 7365., -847., 28860., 2496., 17960. }, 0.6266278765065182 },
	{ 0, { 37681., 20807., -24633., 19631., -10642., 8265. }, 0.6366292306281224 },
	{ 0, { 3191., 5638., -2365., 9854., -1386., 3658. }, 0.6449290790303238 },
	{ 0, { -5177., -823., -2003., 5908., -949., 2341. }, 0.6763170666119763 },
	{ 0, { -3638., 10059., 7207., 4377., 3151., 2651. }, 0.6862778987939261 },
	{ 0, { 11748., -14352., -13920., -7897., -5625., -2944. }, 0.6979445752019332 },
	{ 0, { -8438., 12018., 9236., 3586., 3477., 1505. }, 0.7048114577856822 },
	{ 0, { 1834., -5463., -4042., -1281., -1755., -771. }, 0.7111948880743650 },
	{ 0, { -4692., -8326., -4750., 8084., -2967., 3594. }, 0.7473196860221153 },
	{ 0, { 4040., 13701., 10942., -11503., 6915., -5226. }, 0.7526899558709467 },
	{ 0, { 22865., -59285., -48182., -15767., -20987., -6907. }, 0.7617757396112786 },
	{ 1, { 3873., 1796., -260., -5778., -1031., -4126. },  },
	{ 0, { 272., -668., 1897., 1033., 987., 184. }, 0.7769058037180200 },
	{ 0, { -2176., 7071., 5492., 2930., 2571., 1313. }, 0.8199388514022748 },
	{ 0, { -184998., 97937., 88915., 171155., 41794., 73600. }, 0.8350541004724259 },
	{ 1, { -197., -3126., -715., 1748., -208., 825. },  },
	{ 0, { -5824., 1942., -2170., -8871., -927., -3596. }, 0.8453935583217296 },
	{ 0, { 252., 2148., -787., 1499., -241., 459. }, 0.8551127263577434 },
	{ 0, { 3107., 6817., 10906., 19., 4504., -914. }, 0.8879713761393457 },
	{ 0, { 6532., -6647., -8432., -9470., -3566., -3649. }, 0.8938517525956896 },
	{ 1, { 2415., -4253., -3554., -6203., -2191., -2419. },  },
	{ 0, { -3926., 523., -5326., 11396., -2537., 5007. }, 0.9076103122110721 },
	{ 0, { 1486., 6143., -4417., -1583., -1883., -794. }, 0.9528977392964432 },
	{ 0, { 1226., -908., 2507., -1706., 1029., -874. }, 0.9646777216958613 },
	{ 0, { -11300., -22605., 26258., -9349., 12130., -5605. }, 0.9849512095278805 },
	{ 1, { 1457., -2630., 860., 1293., 487., 641. },  },
	{ 2, { -685., -2643., -646., -848., -225., -318. },  },
	{ 0, { -2190., -3253., -891., -1611., -317., -665. }, 0.9964090016851210 },
	{ 0, { -1179., -3116., -2763., 1595., -1346., 737. }, 1.0352639155374268 },
	{ 0, { 7916., 3274., -3481., 4472., -1826., 2498. }, 1.0515675436820877 },
	{ 0, { 697761., -973027., 901279., 634785., 369311., 295489. }, 1.0592810372818169 },
	{ 1, { -1426., -5270., 2981., -566., 1562., -288. },  },
	{ 0, { -1789., 2512., -1045., -777., -493., -461. }, 1.0720350844573199 },
	{ 0, { 3343., -1231., -1017., -2862., -464., -1223. }, 1.1429483332496098 },
	{ 0, { 11373., -2498., -1580., 8748., -883., 3741. }, 1.1609636069979286 },
	{ 1, { -1522., -2635., 28., 1104., -15., 464. },  },
	{ 0, { -1975., 3205., 2553., 2452., 995., 1112. }, 1.1691873087779718 },
	{ 0, { -9107., -5910., -5019., 8600., -1999., 3899. }, 1.2152142837985198 },
	{ 1, { -4., -1508., -1102., -242., -397., -127. },  },
	{ 0, { -1971., 699., -3., 1482., -78., 551. }, 1.2226982614159414 },
	{ 0, { -31., -206., 25., 63., 54., 23. }, 1.2355263592688024 },
	{ 0, { 2581., 7563., 7150., -2433., 3120., -1128. }, 1.2857063346850945 },
	{ 1, { 1638., -740., -410., -2267., -163., -1002. },  },
	{ 0, { 6494., 16800., 14424., -5912., 6217., -2861. }, 1.2908372220692612 },
	{ 0, { -2870., 4014., 4972., 2882., 2300., 1194. }, 1.3652019003010083 },
	{ 1, { 121., -268., -412., 87., -162., 47. },  },
	{ 2, { 204., -295., -187., 24., -76., 9. },  },
	{ 0, { -3114., 953., -618., -2692., -475., -1304. }, 1.4390426416344881 },
	{ 0, { 643., 554., -351., 588., -171., 247. }, 1.4790740463977397 },
	{ 0, { 470., -497., -239., -9., -101., -35. }, 1.5778081754901920 },
	{ 0, { 12015., -42122., 38323., 10981., 16121., 5766. }, 1.5889777636732787 },
	{ 1, { -377., -28., -105., 615., -60., 248. },  },
	{ 2, { -102., -86., -77., -32., -33., -28. },  },
	{ 0, { -1329., 1696., 1422., 1073., 644., 441. }, 1.6698689170399983 },
	{ 0, { 653., -443., 76., 737., 22., 321. }, 1.6917823552881666 },
	{ 0, { 4010., -973., -776., -3727., -389., -1621. }, 1.7447101363840591 },
	{ 0, { 796., 753., 911., -908., 375., -434. }, 1.8195524075201825 },
	{ 0, { -67., 529., -320., 151., -164., 92. }, 1.8944084825549634 },
	{ 0, { 10., -1636., 1676., -13., 718., 43. }, 2.1173586606692205 },
	{ 0, { -176., -699., -800., 57., -346., 33. }, 2.1995558975407743 },
	{ 0, { 4804., 493., -302., 4547., -271., 2069. }, 3.3406137564373255 },
	{ 1, { -37., 63., -60., 6., -25., 5. },  },
	{ 0, { -6127., -30327., 27236., -5550., 11893., -2472. }, 6.2830758108542479 },
	{ 1, { 13., 96., 24., 144., -4., 74. },  },
	{ 2, { 94., 86., 39., 73., 3., 45. },  },
	{ 0, { -103., 11., 317., -154., 157., -57. }, 8.4710588767699999 },
	{ 0, { -1072., -875., 799., -1217., 416., -503. }, 10.1988027176192690 },
	{ 0, { -7126., 105., -353., -6736., 285., -3012. }, 10.2074359814049150 },
	{ 1, { -735., 3920., -3778., -636., -1657., -531. },  },
	{ 0, { -9779., 1441., -1464., -8409., -23., -3858. }, 10.2156685960931930 },
	{ /* end uranus */ -1,  },
};

chap95_rec chap95_neptune[] = {
	{ 0, { -2753381808., 0., -2555187184., 0., -977694282., 0. }, 0. },
	{ 1, { -53706852., 0., 9024894., 0., 5113590., 0. },  },
	{ 0, { 5353414., 16329756., -10315608., -18211298., -4313685., -7909387. }, 0.0179617912970447 },
	{ 0, { -19054385., -287482557., 282900211., 40600685., 114409567., 24195009. }, 0.0323644369574163 },
	{ 0, { 171759338654., 246707191188., -226959547603., 161070501549., -97171931583., 59786666580. }, 0.0381185507042915 },
	{ 0, { 269128284., 157897034., -86709918., 293605458., -39838078., 115245563. }, 0.0449423189622218 },
	{ 0, { -93736103., -37825790., -26561507., -91732038., -9592733., -35920288. }, 0.0600427026897851 },
	{ 0, { 178516553., 51475281., 124180124., 108331691., 49005129., 40587728. }, 0.0705779080356058 },
	{ 0, { -1684231243., 681665499., -958998993., -1353650791., -355010040., -565296249. }, 0.0772675784146183 },
	{ 0, { 1122264068., -578428299., 1063564939., 463713621., 414676760., 190864744. }, 0.0843726142307477 },
	{ 0, { -781685034., 475952164., -808860716., -228929931., -316705638., -94548544. }, 0.0871507153151969 },
	{ 0, { 56385979., -39979207., 64276567., 7694958., 25352958., 3214483. }, 0.1012471242645664 },
	{ 1, { 63310243., 43285497., 22448880., 66731902., 8926250., 26309541. },  },
	{ 0, { 2712359., -37080616., 26122509., -21572378., 10482381., -8529034. }, 0.1128959119291703 },
	{ 0, { 1376659., 7176921., -1442553., 7206580., -479409., 2921144. }, 0.1246811309098641 },
	{ 0, { -2552808., -3146754., -931704., -4559708., -491329., -1812338. }, 0.1349961443322037 },
	{ 0, { 1162812., 462968., 719939., 2310847., 376498., 885784. }, 0.1402125408882514 },
	{ 0, { -252283., -142326., -110247., -49287., -46731., -28945. }, 0.1616161402063230 },
	{ 0, { 243162., -91598., 106479., 16854., 55597., 8501. }, 0.1776262925892778 },
	{ 0, { -672251., 231673., -319786., 386301., -155882., 135214. }, 0.1904084544956719 },
	{ 0, { 1867133., -1866896., 239943., -1803069., 228227., -732880. }, 0.2026926199831023 },
	{ 0, { 32066276., -61274160., 6958960., -9094869., 4399306., -3854675. }, 0.2132050927412489 },
	{ 1, { -11587231., -5526999., -7458452., 2330330., -3274130., 322813. },  },
	{ 0, { -16700375., 45567407., 14051147., 28126677., 3238872., 12733553. }, 0.2160078733553654 },
	{ 0, { 601249., -3740179., -1686685., -1590049., -510731., -804485. }, 0.2225065497464809 },
	{ 0, { 71272., 256103., 179344., -10427., 65192., 15214. }, 0.2362432045351159 },
	{ 0, { -58547., -82547., -51318., 58153., -20501., 15047. }, 0.2470536247773912 },
	{ 0, { -6723., 19924., 26278., 12439., 9453., 3700. }, 0.2721326326759872 },
	{ 0, { -3710., 4976., -7051., 254., -1464., 195. }, 0.2834391769690069 },
	{ 0, { -12572., -6375., 5687., 15436., 615., 5233. }, 0.2938091870567225 },
	{ 0, { -14716., 204103., 159833., 45074., 65416., 11053. }, 0.3117802888037338 },
	{ 0, { -17577., 42568., 85327., -50768., 36610., -17999. }, 0.3148973170728874 },
	{ 0, { -12308., -4224., -5418., 20456., -3011., 7048. }, 0.3237199721077774 },
	{ 0, { -453., 863., 3006., -1602., 798., -820. }, 0.3434014414974197 },
	{ 0, { -4296., 775., 4295., 2013., 1131., 245. }, 0.3679427772208049 },
	{ 0, { 2844., 8238., -10394., 16799., -2798., 8324. }, 0.3785701069003719 },
	{ 0, { -12477., -18952., 16324., -32949., 3954., -15266. }, 0.3833769854125967 },
	{ 0, { -22365., 128., 5047., -4988., 1724., -1653. }, 0.3921552738853996 },
	{ 0, { 4383., -6090., 178., -7672., -722., -3343. }, 0.4052046013289639 },
	{ 0, { 714788., -68799., 122150., 736324., 10410., 310430. }, 0.4266933782608374 },
	{ 1, { 12121., 14734., 49080., -28648., 20910., -8012. },  },
	{ 0, { 46510., -21693., -58299., -84149., -12783., -39407. }, 0.4328778616668182 },
	{ 0, { -18771., 8624., 16635., 18600., 2724., 10462. }, 0.4397536016965201 },
	{ 0, { 3796., -9377., -6884., 415., -1798., -1014. }, 0.4503999814583104 },
	{ 0, { -7089., 1370., -2220., 4940., -839., 2525. }, 0.4636405151525668 },
	{ 0, { 5125., -1762., 2170., -4527., 631., -2166. }, 0.4745702135817129 },
	{ 0, { 36688., -1584., -8174., -32426., -3946., -13037. }, 0.4886034832877044 },
	{ 0, { -5607., 1955., 1641., 547., 484., -201. }, 0.5046352473687760 },
	{ 0, { 45109., -21568., 12616., 26255., 6182., 12720. }, 0.5178003462986053 },
	{ 0, { 40893658., -28000813., 26124943., 37354584., 10197353., 16693506. }, 0.5296623039564303 },
	{ 1, { -21062., -35782., 31769., -20330., 15353., -11834. },  },
	{ 2, { 10720., 5927., -12424., -538., -3613., -359. },  },
	{ 0, { -28607., 23386., -38172., -43627., -12236., -20256. }, 0.5403804874893231 },
	{ 0, { 66., 635., 4597., 3533., 1279., 1843. }, 0.5486365851140401 },
	{ 0, { -1646., 2776., -3727., -1793., -1436., -354. }, 0.5631942288095021 },
	{ 0, { -353., 460., 306., -526., 107., -133. }, 0.5739537566607668 },
	{ 0, { -48., -518., 599., -406., 229., -183. }, 0.6031743297859348 },
	{ 0, { -230., -43., -65., 493., -36., 204. }, 0.6175060453479511 },
	{ 0, { 19445., 2550., -25130., 13108., -10967., 5418. }, 0.6333639350967218 },
	{ 0, { 13473., 21421., -1023., 17345., -1204., 6355. }, 0.6373233385189475 },
	{ 1, { 864., -8826., 6444., 11189., 2532., 4949. },  },
	{ 0, { 1578., 3023., 2194., 1035., 836., 338. }, 0.6488504417528818 },
	{ 0, { -3340., -7100., -6757., 2738., -2684., 1301. }, 0.6617542675140329 },
	{ 0, { 1017., 744., 847., -982., 332., -425. }, 0.6999703675245400 },
	{ 1, { 42., 10., 19., -41., 10., -16. },  },
	{ 0, { 1891., 647., -479., 1705., -149., 715. }, 0.7361514522905745 },
	{ 0, { -747., -1284., 1091., -507., 523., -190. }, 0.7442630004913908 },
	{ 0, { -25., 104., -104., -129., -52., -37. }, 0.7785774183375729 },
	{ 0, { -512., 349., 592., 506., 250., 205. }, 0.8337771392669406 },
	{ 0, { -6683., 244., -856., -5864., -184., -2467. }, 0.8456021851592702 },
	{ 1, { -1203., -318., -1016., 257., -373., 120. },  },
	{ 0, { -24., 3933., -1820., 1132., -757., 301. }, 0.8511022350336571 },
	{ 0, { 201., -293., -309., -190., -131., -68. }, 0.8740442975723336 },
	{ 0, { 308., -601., -394., -483., -169., -197. }, 0.9077766553319553 },
	{ 0, { -16598., 27372., 14431., 13730., 6210., 4914. }, 0.9458755575816939 },
	{ 1, { -126., -1380., -1472., 3523., -609., 1504. },  },
	{ 2, { 143., -540., 222., -105., 87., -32. },  },
	{ 0, { 329., 51., -160., 190., -86., 81. }, 0.9622835434242619 },
	{ 0, { 128., 272., 129., -159., 60., -76. }, 0.9782201450147658 },
	{ 0, { 420., 770., -363., -155., -115., -92. }, 1.0124707282567436 },
	{ 0, { -2248., -3936., 3766., -2218., 1312., -630. }, 1.0195444397190756 },
	{ 0, { -857., -445., 435., -868., 168., -286. }, 1.0327159571739788 },
	{ 0, { 3376., 287., -315., 3751., -219., 1451. }, 1.0465646752474935 },
	{ 0, { 703800., -971644., 898780., 636713., 368186., 296800. }, 1.0592831516596322 },
	{ 1, { -2151., -2956., 2235., -1431., 946., -697. },  },
	{ 2, { -483., -834., 925., 208., 376., 16. },  },
	{ 0, { -2186., 1237., -468., -857., -221., -500. }, 1.0699466056843263 },
	{ 0, { 186., -107., -155., -33., -60., 1. }, 1.0856512764294945 },
	{ 0, { -29., 176., 74., -52., 22., -24. }, 1.1079517768853906 },
	{ 1, { 68., -82., -7., 40., -2., 17. },  },
	{ 2, { 47., -125., -59., 70., -19., 30. },  },
	{ 0, { -79., -181., -17., 75., 0., 31. }, 1.1242912886086618 },
	{ 0, { 11970., 27., -219., 9608., -385., 4137. }, 1.1622448658047415 },
	{ 1, { 148., -416., -127., 187., -55., 93. },  },
	{ 0, { -1209., -240., 543., 444., 267., 180. }, 1.1657893477276102 },
	{ 0, { 469., -600., 571., 404., 237., 192. }, 1.2652830224888050 },
	{ 0, { -354., 198., -247., -335., -95., -149. }, 1.3749277491569207 },
	{ 0, { 1875., 1364., 1214., -1793., 447., -768. }, 1.4364654070205274 },
	{ 1, { 8., 17., -6., -31., -6., -14. },  },
	{ 0, { -139., 116., 212., 18., 88., 1. }, 1.4674691182537039 },
	{ 0, { 498., 950., -86., 629., -57., 244. }, 1.4773951127670801 },
	{ 0, { -211., 132., -176., -151., -46., -37. }, 1.5126367782986652 },
	{ 0, { 388., -45., -90., 143., -56., 57. }, 1.5755868837627032 },
	{ 0, { -262., 394., 82., 179., 60., 76. }, 1.5824073222387700 },
	{ 0, { 12274., -42141., 38563., 10654., 16215., 5586. }, 1.5888971797699629 },
	{ 1, { 79., 26., 108., -116., 43., -61. },  },
	{ 0, { 785., -282., 272., 723., 98., 317. }, 1.6918870360592064 },
	{ 0, { 107., -210., -181., -174., -73., -72. }, 1.9281473841900221 },
	{ 0, { -121., -1883., 1696., -129., 731., -7. }, 2.1185461864868773 },
	{ 0, { 4845., 396., -313., 4430., -275., 2018. }, 3.3406127811310191 },
	{ 1, { 1., 25., -4., 6., -1., 2. },  },
	{ 0, { -5503., -29918., 27443., -5129., 11901., -2218. }, 6.2830758192539502 },
	{ 0, { 149., -16., 70., 137., 24., 69. }, 6.6811483956904603 },
	{ 0, { 14., 35., -47., -48., -19., -18. }, 8.4710967963441863 },
	{ 1, { 1., -1., -17., -7., -7., -4. },  },
	{ 0, { -17638., 555., -991., -16049., 673., -7250. }, 10.2132840866995910 },
	{ 0, { -44., -259., 211., -59., 89., -24. }, 12.5662764645159580 },
	{ /* end neptune */ -1,  },
};

chap95_rec chap95_pluto[] = {
	{ 0, { 101045891905., 0., 110312086224., 0., 6172492792., 0. }, 0. },
	{ 1, { 2736962357., 0., 7289921703., 0., 8356828229., 0. },  },
	{ 0, { -197631754827., 306850452168., -363706825084., -174047739469., -83742488844., -166197114948. }, 0.0255535185296511 },
	{ 1, { -10339882709., 3627560682., -1704596538., 16082008148., -2615797675., 26582875457. },  },
	{ 2, { 4555881844., 5354987944., 14163087849., 13295578846., 16544976961., 15318697408. },  },
	{ 0, { 12877551757., 9141005248., 38823958976., 14074786713., 47081142550., 15934841957. }, 0.0383093966256461 },
	{ 0, { -20363081906., 43534352230., -68888048997., -6054817551., -37922256273., -13665923314. }, 0.0512632279013590 },
	{ 0, { 11372859069., -7331041505., 34135169446., -14164330338., 35562426110., -15256543947. }, 0.0629625800045217 },
	{ 0, { -25223811753., 30334977886., -76993608077., 67207355885., -78022096909., 72709750549. }, 0.0739104871604531 },
	{ 0, { 19031032676., -21606847641., 49490563510., -67837042251., 54793488046., -76660221358. }, 0.0843726142307477 },
	{ 1, { 9888109415., 13390931761., 31569755508., 36949340015., 35801709881., 41063108577. },  },
	{ 2, { -5391246864., 9125341237., -13760381761., 26757260022., -14709006932., 29981422406. },  },
	{ 0, { 77016900., 8576436595., -758303524., 19868503441., 945693837., 21114141886. }, 0.1009656667626818 },
	{ 0, { -425710709., -2201772586., -2981443460., -6781825029., -3324565933., -7783206250. }, 0.1181216342983851 },
	{ 1, { 2255988361., -245384099., 5983679140., -939391729., 6514267045., -1323842110. },  },
	{ 2, { 531179571., 1086625691., 2182247914., 3044397909., 2484824490., 3408389022. },  },
	{ 0, { 670122662., 438458646., 1753307958., 718209879., 2047795531., 636335929. }, 0.1384952768343311 },
	{ 0, { -179746215., -90394676., -766063009., -205567765., -854408253., -261725146. }, 0.1499201895782055 },
	{ 1, { 110140865., -359336510., 28912500., -843378659., -67920831., -973289319. },  },
	{ 0, { -118071179., 1819649., -265130729., 91955370., -298913452., 133716152. }, 0.1607487697162686 },
	{ 0, { 38739517., 9002149., 12071193., -2098061., 15714901., -32081340. }, 0.1760768320056049 },
	{ 0, { -2332129., 6073325., -5475022., 19141973., -5216109., 20872520. }, 0.1900452184842649 },
	{ 0, { 8137788., -2826068., -3014741., -6719062., -5256740., -14189611. }, 0.2024941844674784 },
	{ 0, { 18559203., -16541614., 25112499., 27558953., 14213163., 19938478. }, 0.2134752084935937 },
	{ 0, { 1940133., -1267576., -1439934., -1986889., -2525015., -3851133. }, 0.2269557049635166 },
	{ 1, { 1917476., -1704590., 4921317., -5434051., 4782139., -6305807. },  },
	{ 0, { -822410., -563503., -2747944., -903463., -3210523., -702889. }, 0.2402479397150676 },
	{ 0, { 962595., -74013., 1141117., 518365., 966375., 17190. }, 0.2531177145689346 },
	{ 0, { -135658., -8463., -393590., 160618., -448155., 267162. }, 0.2643717493874742 },
	{ 0, { 231442., -143885., 176186., -1443., 93050., -109960. }, 0.2777029906063622 },
	{ 0, { -3000., -245., -27453., 92186., -35712., 133397. }, 0.2900297658482435 },
	{ 0, { 55997., -115242., -44421., -45883., -43549., -47825. }, 0.3037412654012783 },
	{ 0, { -14892., 15253., 52487., 23252., 43486., 48497. }, 0.3142803959054077 },
	{ 0, { -2949., -95938., -94512., -17869., -51976., 3765. }, 0.3264027536592037 },
	{ 0, { 8894., 9213., 33696., 2580., 28347., 6790. }, 0.3373713684595000 },
	{ 0, { -16468., -43883., -57588., 8839., -17108., 18484. }, 0.3506196546089751 },
	{ 0, { -4324., 14942., 537., 2320., 8817., -1258. }, 0.3768935755307548 },
	{ 0, { -2257., -145., -272., -4909., 4559., -6184. }, 0.3901294315026133 },
	{ 0, { -10889., 10437., -5474., 6213., 16279., -4595. }, 0.4045287784128869 },
	{ 0, { 719443., -70760., 86542., 684112., 3209., 279550. }, 0.4267968486470127 },
	{ 1, { 3728., 5875., 3969., 4141., 3826., 956. },  },
	{ 2, { 9968., 1181., 2923., 6780., 6338., 2119. },  },
	{ 0, { 6842., 1584., 10374., 4788., 8573., -4658. }, 0.4456721426794963 },
	{ 0, { -10089., 9939., 3641., 7449., 544., 598. }, 0.4579662921251779 },
	{ 0, { 1823., 688., 6471., -612., 1565., -5241. }, 0.4724826607880908 },
	{ 0, { -3424., 9654., 4992., 7807., 583., 1356. }, 0.4869141744280314 },
	{ 0, { -449., -1794., 3826., -7250., -2319., -7298. }, 0.5001714317315645 },
	{ 0, { 15872., 9071., 15995., 31749., 10331., 14516. }, 0.5137491938947873 },
	{ 0, { 40907450., -28046763., 26106307., 37325417., 10171143., 16690754. }, 0.5296557456960209 },
	{ 1, { -42177., -28947., 38775., -19498., 29548., -4665. },  },
	{ 2, { 3107., 30472., -6348., 11400., 8980., 1831. },  },
	{ 0, { -7558., 61741., -13579., -15470., 9629., -26943. }, 0.5428748902518665 },
	{ 0, { -5153., -16254., 1129., 1453., -5621., 9705. }, 0.5545763246422408 },
	{ 1, { 4786., -5955., 927., 2343., -4914., 1978. },  },
	{ 0, { -472., -1295., 65., -1013., 81., 865. }, 0.5737334589484931 },
	{ 0, { 1071., -818., -1860., -1756., -2076., -217. }, 0.6240874769868805 },
	{ 0, { 35210., 26306., -24283., 31193., -11240., 11870. }, 0.6381677442023816 },
	{ 1, { -1433., -467., -610., 819., -193., 1466. },  },
	{ 2, { -2302., -1111., 916., -1272., 326., -143. },  },
	{ 0, { 713., -751., -578., -1512., 156., -696. }, 0.6775366989691358 },
	{ 1, { 60., 611., -229., 120., -170., -479. },  },
	{ 0, { 566., 1322., -824., 882., 271., -163. }, 0.7307010456855323 },
	{ 1, { 315., -273., 931., -867., 656., -752. },  },
	{ 0, { 2637., -5581., -3871., -2275., -3921., 187. }, 0.8349274544218315 },
	{ 0, { -6012., 8879., 923., -5393., 1314., -3852. }, 0.8466308769723183 },
	{ 1, { -2430., -2929., -1564., 2843., 65., 3053. },  },
	{ 2, { -373., -2949., -1724., 190., -949., 999. },  },
	{ 0, { 3787., 756., 723., -3294., -966., -1395. }, 0.8803279870880313 },
	{ 0, { 5446., -1146., -595., -4608., -1861., -1044. }, 0.9048452745134871 },
	{ 0, { 5058., -2711., -831., -3667., -1554., -139. }, 0.9284980837327494 },
	{ 0, { 1760., -6922., -4114., -3639., -1717., 694. }, 0.9630502889662660 },
	{ 1, { 963., 1525., 703., -3798., -966., -2055. },  },
	{ 0, { -854., -5315., -3964., -3549., -797., 142. }, 0.9850575449612223 },
	{ 1, { 453., 513., -533., -1316., -1407., -442. },  },
	{ 0, { -1452., 2161., -2167., -2392., 843., -1017. }, 1.0358203937225836 },
	{ 0, { 717822., -1016247., 926007., 647088., 383619., 291083. }, 1.0592833248900753 },
	{ 1, { -29524., -7934., 4354., -18649., -4618., -10392. },  },
	{ 2, { -5165., 7903., -5462., -3951., -3606., -275. },  },
	{ 0, { -13391., 43036., -26981., -8012., -15174., 6191. }, 1.0698620958167548 },
	{ 1, { -19633., -2810., 1597., -10192., -4219., -4352. },  },
	{ 0, { 273., 2230., -349., -375., 851., 287. }, 1.0830212781676249 },
	{ 0, { 10855., -624., 671., 9748., 207., 3846. }, 1.1622398168028405 },
	{ 1, { -33., 92., -124., -554., -92., -612. },  },
	{ 0, { 448., -1008., 1081., 183., 623., -187. }, 1.2654499680761597 },
	{ 0, { -207., 526., 176., -733., 246., -400. }, 1.3757220045803040 },
	{ 0, { 638., 340., -422., 36., 44., 18. }, 1.4777197679290477 },
	{ 0, { 12128., -41950., 38517., 10211., 16357., 5050. }, 1.5888963534561586 },
	{ 1, { -267., 195., -296., 12., -482., 121. },  },
	{ 2, { -41., 86., -13., 298., -132., 311. },  },
	{ 0, { 667., -280., 347., 903., -21., 475. }, 1.6918774676128379 },
	{ 0, { 30., -1843., 2162., 314., 1153., 512. }, 2.1185453910327063 },
	{ 0, { 4845., 477., -393., 4358., -362., 2072. }, 3.3406128168607023 },
	{ 0, { -5939., -29727., 27855., -4133., 12163., -1725. }, 6.2830758108873654 },
	{ 1, { 5., -58., 6., 45., 39., 54. },  },
	{ 0, { -223., 149., 91., 102., 231., 420. }, 8.4710959288534031 },
	{ 0, { -17640., -47., -831., -15721., 782., -7065. }, 10.2132856585962150 },
	{ 1, { 165., 60., -38., 154., 112., 136. },  },
	{ 2, { 20., 46., 112., -30., 119., 10. },  },
	{ /* end pluto */ -1,  },
};


/* For RCS Only -- Do Not Edit */
static char *rcsid[2] = {(char *)rcsid, "@(#) $RCSfile: chap95_data.c,v $ $Date: 2006-11-22 13:53:28 $ $Revision: 1.6 $ $Name: not supported by cvs2svn $"};
