#include "sopnamsp.h"
#include "machdefs.h"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "timing.h"
#include "srandgen.h"

#include "geneutils.h"

int main(int narg,char *arg[])
{
  unsigned long nalea=10000000;
  // Poisson de moyenne mu  -> mean=mu,  variance=sigma^2=mu
  //   mumax=10  -> on est a 10*sigma de zero
  double mu = 5, mumax=10.;

  cout<<"mu="<<mu<<" mumax="<<mumax<<" nalea="<<nalea<<endl;

  Auto_Ini_Ranf(5);
  InitTim();
  double sum=0., sum2=0.;
  double s=0., s2=0.;
  unsigned long pr = nalea/25;
  for(unsigned long i=0;i<nalea;i++) {
    double m = mu*drand01(); // on fait varier la moyenne
    sum += m; sum2 += m*m;
    //int a = PoissRand(m);
    unsigned long a = PoissRandLimit(m,mumax);
    if(i%pr==0) cout<<i<<endl;
    s += (double)a;  s2 += (double)a*(double)a;
  }
  s /= (double)nalea;
  s2 = s2/(double)nalea -s*s;
  cout<<"Poisson: mean="<<s<<"  sigma^2="<<s2<<" -> "<<sqrt(s2)<<"  n="<<nalea<<endl;

  sum /= (double)nalea;
  sum2 = sum2/(double)nalea -sum*sum;
  cout<<"Moyenne generee: m="<<sum<<"  s^2="<<sum2<<" -> "<<sqrt(fabs(sum2))<<endl;
  PrtTim("Fin");

  return 0;
}
