#ifndef HISTERR_SEEN
#define HISTERR_SEEN

#include "objfio.h"
#include <iostream>
#include <stdio.h>
#include "histos.h"

namespace SOPHYA {

//  Forward class declaration for Fits handler
template <class T>  class FitsHandler;

//! 1 dimension histograms with errors given by user
class HistoErr : public Histo {
  friend class ObjFileIO<HistoErr>;
  friend class FitsHandler<Histo>;
public:

  // CREATOR / DESTRUCTOR
  HistoErr(void);
  HistoErr(r_8 xMin, r_8 xMax, int_4 nBin=100);
  HistoErr(const HistoErr& H);
  virtual ~HistoErr(void);

  // UPDATING or SETTING
  void Zero(void);
  //! Addition du contenu de l'histo pour abscisse x poids w et l'erreur e
  inline void Add(r_8 x, r_8 w, r_8 e)
  {
  int_4 numBin = (int_4)floor((x-mMin)/binWidth);
  if(numBin<0) mUnder += w;
  else if(numBin>=mBins) mOver += w;
  else {
    mData[numBin] += w; mNData[numBin] += 1.; mErr2[numBin] += e*e;
    nHist += w; nEntries++;
  }
  }
  inline void Add(r_8 x, r_8 w) {Add(x,w,1.);}
  inline void Add(r_8 x) {Add(x,1.,1.);}
  //! Addition du contenu de l'histo pour le bin numBin poids w et l'erreur e
  inline void AddBin(int_4 numBin, r_8 w, r_8 e)
  {
  if(numBin<0) mUnder += w;
  else if(numBin>=mBins) mOver += w;
  else {
    mData[numBin] += w; mNData[numBin] += 1.; mErr2[numBin] += e*e;
    nHist += w; nEntries++;
  }
  }
  inline void AddBin(int_4 numBin, r_8 w) {AddBin(numBin,w,1.);}
  inline void AddBin(int_4 numBin) {AddBin(numBin,1.,1.);}
  //! remplissage contenu de l'histo pour le bin numBin poids w et l'erreur e
  void SetBin(int_4 numBin, r_8 w, r_8 e, r_8 nb);
  inline void SetBin(int_4 numBin, r_8 w, r_8 e) {SetBin(numBin,w,e,1.);}
  inline void SetBin(int_4 numBin, r_8 w) {SetBin(numBin,w,1.,1.);}
  inline void SetBin(int_4 numBin) {SetBin(numBin,1.,1.,1.);}
  //! remplissage nombre d'entrees pour le bin numBin
  void SetNentB(int_4 numBin, r_8 nb=1.);

  //! Retourne le nombre d'entree dans le bin
  inline r_8 NEntBin(int_4 i) const
         {if(mNData) return mNData[i]; else return 0.;}

  //! get/put from/to a vector
  void GetNBin(TVector<r_8>& v) const;
  void PutNBin(TVector<r_8>& v);

  //! Compute the correlation histogram
  void ToCorrel(void);
  void FromCorrel(void);
  int_4 NCorrel(void) {return mCorrel;}
  void SetCorrel(int_4 mcorrel) {mCorrel = mcorrel;}

  //! Fill an histogram with an histogram
  void FillFrHErr(HistoErr& hfrom);

  // Operators
  HistoErr& operator = (const HistoErr& h);

  // Print
  virtual void Show(ostream& os) const;
  inline  void Show() const { Show(cout); }

protected:
  void CreateOrResize(r_8 xMin, r_8 xMax, int_4 nBin);
  void Delete(void);

  r_8* mNData;    //!< nombre d'entrees dans chaque bin
  int_4 mCorrel;  //!< Nombre d'appels a ToCorrel(+1) ou FromCorrel(-1)
};

/*! Prints histogram information on stream \b s (h.Show(s)) */
inline ostream& operator << (ostream& s, HistoErr const & h)
  {  h.Show(s);  return(s);  }

/*! \ingroup HiStats \fn operator<<(POuttPersist&,HistoErr)
  \brief Persistance management */
inline POutPersist& operator << (POutPersist& os, HistoErr & obj)
{ ObjFileIO<HistoErr> fio(&obj);  fio.Write(os);  return(os); }
/*! \ingroup HiStats \fn operator<<(POuttPersist&,HistoErr)
  \brief Persistance management */
inline PInPersist& operator >> (PInPersist& is, HistoErr & obj)
{ ObjFileIO<HistoErr> fio(&obj); is.SkipToNextObject(); fio.Read(is); return(is); }

} // Fin du namespace

#endif // HISTERR_SEEN
