#ifndef GENEUTILS_SEEN
#define GENEUTILS_SEEN

#include "machdefs.h"
#include <math.h>
#include "genericfunc.h"
#include "histos.h"
#include "tvector.h"

#include <vector>

namespace SOPHYA {

class InterpFunc {
public:
  InterpFunc(double xmin,double xmax,vector<double>& y);
  virtual ~InterpFunc(void) { }

  double XMin(void) {return _xmin;}
  double XMax(void) {return _xmax;}

  //! Retourne l'element le plus proche de f donnant y=f(x)
  inline double operator()(double x)
         {
         x -= _xmin;
         long i = long(x/_xlarg*_nm1+0.5);  // On prend le "i" le plus proche
         if(i<0) i=0; else if(i>=_nm1) i=_nm1-1;
         return _y[i];
         }

  // idem operator(double) et retourne
  // ok==0 si valeur trouvee, 1 si x<xmin, 2 si x>xmax
  inline double operator()(double x,unsigned short& ok)
    {ok=0; if(x<_xmin) ok=1; else if(x>_xmax) ok=2; return (*this)(x);}

  //! Retourne l'interpolation lineaire de f donnant y=f(x)
  // ok==0 si valeur trouvee, 1 si x<xmin, 2 si x>xmax
  double Linear(double x,unsigned short& ok);

  //! Retourne l'interpolation parabolique de f donnant y=f(x)
  // ok==0 si valeur trouvee, 1 si x<xmin, 2 si x>xmax
  double Parab(double x,unsigned short& ok);

protected:
  double _xmin,_xmax,_xlarg,_dx;
  vector<double>& _y;
  long _nm1;  // n-1
};

}

int FuncToHisto(GenericFunc& func,Histo& h,bool logaxex=false);
int FuncToVec(GenericFunc& func,TVector<r_8>& h,double xmin,double xmax,bool logaxex=false);

double AngSol(double dtheta,double dphi,double theta0=M_PI/2.);
double AngSol(double dtheta);

unsigned long PoissRandLimit(double mu,double mumax=10.);

#endif
