// This may look like C code, but it is really -*- C++ -*-
// Classes d'emballage (wrapper) d'histos SOPHYA/HiStats
// pour trace par PIHisto 
//       C. Magneville / R. Ansari             2007
// (C)     CEA-DAPNIA            LAL-IN2P3/CNRS

#ifndef SOHISWRAP_H
#define SOHISWRAP_H

#include "histos.h"
#include "hisprof.h"
#include "histerr.h"

#include "pexceptions.h"

#include "phistwrapper.h"

namespace SOPHYA {
 
//! Wrapper class for SOPHYA::Histo  , SOPHYA::HProf
class HistoWrapper : public P1DHistoWrapper
{
public:
  HistoWrapper(Histo* h, bool ad=true) 
  {
    if (h == NULL) throw NullPtrError("HistoWrapper(Histo* h = NULL)");
    mHis = h;  mAD = ad;
  }
  ~HistoWrapper() { if (mAD) delete mHis; }

  virtual int_4 NBins() { return mHis->NBins(); }
  virtual r_8 XMin() { return mHis->XMin() ; } 
  virtual r_8 XMax() { return mHis->XMax() ; } 
  virtual r_8 BinWidth() { return mHis->BinWidth() ; } 

  virtual r_8 BinLowEdge(int_4 i) { return mHis->BinLowEdge(i) ; }
  virtual r_8 BinCenter(int_4 i) { return mHis->BinCenter(i) ; }
  virtual r_8 BinHighEdge(int_4 i) { return mHis->BinHighEdge(i) ; }

  virtual r_8 operator()(int_4 i) { return (*mHis)(i) ; }
  virtual r_8 Error(int_4 i) { return mHis->Error(i) ; }

  virtual void Update() { mHis->UpdateHisto(); }

  // ajoute des lignes de texte avec les infos statistiques 
  virtual int GetStatInfoAsText(vector<string> & text) 
  {
    char label[64];
    string s;
    sprintf(label, "N= %-g",mHis->NData());
    s = label;   text.push_back(s);
    sprintf(label, "m= %-g",mHis->Mean());
    s = label;   text.push_back(s);
    sprintf(label, "s= %-g",mHis->Sigma());
    s = label;   text.push_back(s);
    return 3;
  }

  // pointeur sur l'objet histo
  inline Histo* getHisto() { return mHis; }
protected:
  Histo* mHis;
  bool mAD;
};


//! Wrapper class for SOPHYA::HistoErr  
class HistoErrWrapper : public P1DHistoWrapper 
{
public:
  HistoErrWrapper(HistoErr* h, bool ad=false) 
  {
    if (h == NULL) throw NullPtrError("HistoWrapper(HistoErr* h = NULL)");
    mHis = h;  mAD = ad;
  }
  ~HistoErrWrapper() { if (mAD) delete mHis; }

  virtual int_4 NBins() { return mHis->NBins(); }
  virtual r_8 XMin() { return mHis->XMin() ; } 
  virtual r_8 XMax() { return mHis->XMax() ; } 
  virtual r_8 BinWidth() { return mHis->BinWidth() ; } 

  virtual r_8 BinLowEdge(int_4 i) { return mHis->BinLowEdge(i) ; }
  virtual r_8 BinCenter(int_4 i) { return mHis->BinCenter(i) ; }
  virtual r_8 BinHighEdge(int_4 i) { return mHis->BinHighEdge(i) ; }

  virtual r_8 operator()(int_4 i) { return (*mHis)(i) ; }
  virtual r_8 Error(int_4 i) { return mHis->Error(i) ; }

  // CMV $CHECK$  pas besoin ? virtual void Update() { }

  // ajoute des lignes de texte avec les infos statistiques 
  virtual int GetStatInfoAsText(vector<string> & text) 
  {
    // CMV $CHECK$  Y-a-t il qque chose a ecrire ?
    string s = "HistoErr"; 
    text.push_back(s);
    return 1;
  }

  // pointeur sur l'objet histo
  inline HistoErr* getHistoErr() { return mHis; }
protected:
  HistoErr* mHis;
  bool mAD;
};

} // Fin du namespace

#endif
