// This may look like C code, but it is really -*- C++ -*-
// Classe traceur d histogramme                 96-99
//            C. Magneville / R. Ansari       2000-2007
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PIHISTO_H
#define PIHISTO_H

#include "pidrawer.h"
#include "phistwrapper.h"


class PIHisto : public PIDrawer {
public:
                     PIHisto(P1DHistoWrapper* histo, bool ad=true);
  virtual           ~PIHisto();
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  inline  void       SetStats(bool fg=true) {stats=fg;}
  inline  void       SetStatPosOffset(float ofx=-0.01, float ofy=-0.01) 
                                     {spoX=ofx; spoY=ofy; }
  // fg=-1 pas de barre d'erreur, 1=barres d'erreurs,
  // 0=barres d'erreurs automatiques: trace si HProf ou markeur demande
  inline  void       SetError(short fg=0) {error=fg;}
  inline  void       SetFilled(bool fg=false) {filled=fg;}
  inline  P1DHistoWrapper*     HistoWrapper() {return(mHisto);}

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
  virtual void       GetOptionsHelpInfo(string& info);

// Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);

protected:
  virtual void       DrawStats(PIGraphicUC* g);
  P1DHistoWrapper*   mHisto;
  bool mAdDO;
  bool stats,filled;
  short error;
  float spoX, spoY; // Stat pos offset par rapport a position defaut
};

#endif
