// This may look like C code, but it is really -*- C++ -*-
// Classe d'emballage (wrapper) d'histos pour trace PI 
//       C. Magneville / R. Ansari             2007
// (C)     CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PHISTOWRAPPER_H
#define PHISTOWRAPPER_H

#include <string> 
#include <vector> 


//! Wrapper class interface for 1d-histogram like objects , used by PIHisto
// methodes par defaut dans pihisto.cc
class P1DHistoWrapper 
{
public:
  P1DHistoWrapper();
  virtual ~P1DHistoWrapper(); 

  virtual int_4 NBins() = 0; 
  virtual r_8 XMin() = 0; 
  virtual r_8 XMax() = 0;
  virtual r_8 BinWidth() = 0; 

  virtual r_8 BinLowEdge(int_4 i) = 0;
  virtual r_8 BinCenter(int_4 i) = 0;
  virtual r_8 BinHighEdge(int_4 i) = 0;

  // Renvoie contenu du bin i
  virtual r_8 Value(int_4 i) = 0;
  virtual r_8 Error(int_4 i) = 0;
  virtual r_8 NbEntries(int_4 i) = 0;

  inline  r_8 operator()(int_4 i) { return ( Value(i)*mScale+mOff ); }
  // Methode de mise a jour du contenu 
  // avec implementation par defaut - ne faisant rien 
  virtual void Update() { return; }

  // ajoute des lignes de texte avec les infos statistiques (dans text)
  // renvoie le nombre de lignes ajoutees - avec implementation par defaut
  virtual int GetStatInfoAsText(vector<string> &  text );

//   Methode de decodage des options - avec implementation par defaut 
//   l'implementation par defaut ds le fichier pihisto.cc 
  virtual int DecodeOptionString(vector<string> & opt, bool rmdecopt=true);

protected:
  r_8 mScale, mOff;   // scaling coefficient, offset coefficient

};


#endif
