// This may look like C code, but it is really -*- C++ -*-
// Classe traceur d histogramme                 96-99
//            C. Magneville / R. Ansari       2000-2007
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PIHISTO_H
#define PIHISTO_H

#include "pidrawer.h"
#include "phistwrapper.h"


class PIHisto : public PIDrawer {
public:
                     PIHisto(P1DHistoWrapper* histowp, bool ad=true);
  virtual           ~PIHisto();
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();

  inline  P1DHistoWrapper*     HistoWrapper() {return(mHistoWp);}

//   ce qu'on plot
  double DrawVal(int_4 i) {
    if(todraw==1) return mHistoWp->Value(i);
    if(todraw==2) return mHistoWp->Error(i);
    if(todraw==3) return mHistoWp->NbEntries(i);
    return (*mHistoWp)(i);
  }

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
  virtual void       GetOptionsHelpInfo(string& info);

// Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);

protected:
  virtual void       DrawStats(PIGraphicUC* g);
  P1DHistoWrapper*   mHistoWp;
  bool mAdDO;
  bool stats,filled;
  short error,todraw;
  float spoX, spoY; // Stat pos offset par rapport a position defaut
};

#endif
