#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "nomherradapter.h"
#include "pihisto.h"   /* Wrapper pour HistoErr */
#include "sohiswrap.h"   /* Wrapper pour HistoErr */

#include "pipodrw.h"

#include "servnobjm.h"

#include "objfitter.h"

//-----------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet HistoErr
//-----------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_HistoErr::NOMAdapter_HistoErr(HistoErr* o)
  : NObjMgrAdapter(o)
{
mHerr = o;
}

/* --Methode-- */
NOMAdapter_HistoErr::~NOMAdapter_HistoErr()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_HistoErr::Clone(AnyDataObj* o)
{
HistoErr* h = dynamic_cast<HistoErr *>(o);
if (h) return ( new NOMAdapter_HistoErr(h) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_HistoErr::GetDataObjType()
{
return("HistoErr ");
}

/* --Methode-- */
string NOMAdapter_HistoErr::GetInfoString(int lev)
{
  char buff[128];
  string rs;
  if (lev > 2) {
    sprintf(buff, "HistoErr: NBin=%d XMin=%lg XMax=%lg\n", mHerr->NBins(), 
	  mHerr->XMin(), mHerr->XMax());
    rs += buff;
  }
  return rs;
}

/* --Methode-- */
string NOMAdapter_HistoErr::GetInfoString(vector<string>& opts)
{
  string blabla = "HistoErr: nbin binw xmin xmax";

  if(opts.size() == 0) return GetInfoString(3);

  char buff[64];
  if(opts[0] == "nbin") {
    sprintf(buff, "%d",mHerr->NBins());
  } else if(opts[0] == "binw") {
    sprintf(buff, "%lg",mHerr->BinWidth());
  } else if(opts[0] == "xmin") {
    sprintf(buff, "%lg",mHerr->XMin());
  } else if(opts[0] == "xmax") {
    sprintf(buff, "%lg",mHerr->XMax());
  } else {
    return blabla;
  }
  return string(buff);
}

/* --Methode-- */
AnyDataObj* NOMAdapter_HistoErr::CloneDataObj(bool /*share*/)
{
  return( new HistoErr(*mHerr) );
}

/* --Methode-- */
void NOMAdapter_HistoErr::SavePPF(POutPersist& pos, string const & nom)
{
ObjFileIO<HistoErr> fio(mHerr);
fio.Write(pos, nom);
}

/* --Methode-- */
void NOMAdapter_HistoErr::Print(ostream& os, int lev)
{
mHerr->Show(os);
}

/* --Methode-- */
PIDrawer* NOMAdapter_HistoErr::GetDrawer(string & dopt)
{
dopt = "thinline " + dopt;
HistoErrWrapper* hw = new HistoErrWrapper(mHerr, false); // false: le Wrapper ne delete pas l'objet mHerr
PIHisto * pih = new PIHisto(hw, true); // true: PIHisto delete l'objet HistoErrWrapper hw
return( pih );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_HistoErr::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_HistoErr(mHerr) );
}

/* --Methode-- */
GeneralFitData* NOMAdapter_HistoErr::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
  cout<<"NOMAdapter_HistoErr::GetGeneralFitData: NOT IMPLEMENTED"<<endl;
  return NULL;
}

AnyDataObj* NOMAdapter_HistoErr::FitResidusObj(GeneralFit& mfit)
{
  cout<<"NOMAdapter_HistoErr::FitResidusObj: NOT IMPLEMENTED"<<endl;
  return NULL;
}

AnyDataObj* NOMAdapter_HistoErr::FitFunctionObj(GeneralFit& mfit)
{
  cout<<"NOMAdapter_HistoErr::FitFunctionObj: NOT IMPLEMENTED"<<endl;
  return NULL;
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_HistoErr::NTupInt_HistoErr(HistoErr* h)
{
mHerr  = h;
}

/* --Methode-- */
NTupInt_HistoErr::~NTupInt_HistoErr()
{
}

/* --Methode-- */
sa_size_t NTupInt_HistoErr::NbLines() const 
{
return(mHerr->NBins());
}

/* --Methode-- */
sa_size_t NTupInt_HistoErr::NbColumns() const
{
return(5);
}

/* --Methode-- */
r_8* NTupInt_HistoErr::GetLineD(sa_size_t k) const
{
 int i;
 if(k<0 || k>=mHerr->NBins()) {
   for(i=0; i<5; i++)  mRet[i] = 0.;
 } else { 
   mRet[0] = k;  mRet[1] = mHerr->BinCenter(k);
   mRet[2] = (*mHerr)(k); mRet[3] = mHerr->Error2(k);
   mRet[4] = mHerr->NEntBin(k);
 }
 return(mRet);
}

/* --Methode-- */
string NTupInt_HistoErr::VarList_C(const char* nx) const
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,x,val,err2,nb; \n";
vardec += "i = " + nomx + "[0];  x = " + nomx + "[1]; \n";
vardec += "val = " + nomx + "[2];  err2 = " + nomx + "[3]; \n";
vardec += "nb = " + nomx + "[4]; \n";
return(vardec);
}

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo2DErr
//-------------------------------------------------------------------------


/* --Methode-- */
NOMAdapter_Histo2DErr::NOMAdapter_Histo2DErr(Histo2DErr* o)
  : NObjMgrAdapter(o)
{
mHerr = o;
}

/* --Methode-- */
NOMAdapter_Histo2DErr::~NOMAdapter_Histo2DErr()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Histo2DErr::Clone(AnyDataObj* o)
{
Histo2DErr* h = dynamic_cast<Histo2DErr *>(o);
if (h) return ( new NOMAdapter_Histo2DErr(h) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_Histo2DErr::GetDataObjType()
{
return ("Histo2DErr ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_Histo2DErr::CloneDataObj(bool /*share*/)
{
return ( new Histo2DErr(*mHerr) );
}

/* --Methode-- */
void NOMAdapter_Histo2DErr::SavePPF(POutPersist& pos, string const & nom)
{
ObjFileIO<Histo2DErr> fio(mHerr);
fio.Write(pos, nom);
}

/* --Methode-- */
void NOMAdapter_Histo2DErr::Print(ostream& os, int lev)
{
mHerr->Show(os);
}

/* --Methode-- */
PIDrawer* NOMAdapter_Histo2DErr::GetDrawer(string & dopt)
{
  /* A_FAIRE_REZA    -> + des options pour choisir val / err2 / nb
dopt = "thinline " + dopt;
return( new PIHisto2DErr(mHerr, false) );
  */
  return NULL;
}

/* --Methode-- */
P2DArrayAdapter* NOMAdapter_Histo2DErr::Get2DArray(string & dopt)
{
return ( new POHe2DAdapter(mHerr, false) );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Histo2DErr::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Histo2DErr(mHerr) );
}


/* --Methode-- */
GeneralFitData* NOMAdapter_Histo2DErr::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
  cout<<"NOMAdapter_Histo2DErr::GetGeneralFitData: NOT IMPLEMENTED"<<endl;
  return NULL;
}

AnyDataObj* NOMAdapter_Histo2DErr::FitResidusObj(GeneralFit& mfit)
{
  cout<<"NOMAdapter_Histo2DErr::FitResidusObj: NOT IMPLEMENTED"<<endl;
  return NULL;
}

AnyDataObj* NOMAdapter_Histo2DErr::FitFunctionObj(GeneralFit& mfit)
{
  cout<<"NOMAdapter_Histo2DErr::FitFunctionObj: NOT IMPLEMENTED"<<endl;
  return NULL;
}


/* --Methode-- */
string NOMAdapter_Histo2DErr::GetInfoString(vector<string>& opts)
{
  string blabla = "Histo2DErr: nbin binw xmin xmax ymin ymax";

  if(opts.size() == 0) return blabla;

  char buff[128];
  if(opts[0] == "nbin") {
    sprintf(buff, "%d %d",mHerr->NBinX(),mHerr->NBinY());
  } else if(opts[0] == "binw") {
    sprintf(buff, "%lg %lg",mHerr->WBinX(),mHerr->WBinY());
  } else if(opts[0] == "xmin") {
    sprintf(buff, "%lg",mHerr->XMin());
  } else if(opts[0] == "xmax") {
    sprintf(buff, "%lg",mHerr->XMax());
  } else if(opts[0] == "ymin") {
    sprintf(buff, "%lg",mHerr->YMin());
  } else if(opts[0] == "ymax") {
    sprintf(buff, "%lg",mHerr->YMax());
  } else {
    return blabla;
  }
  return string(buff);
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Histo2DErr::NTupInt_Histo2DErr(Histo2DErr* h)
{
mHerr = h;
}

/* --Methode-- */
NTupInt_Histo2DErr::~NTupInt_Histo2DErr()
{
}

/* --Methode-- */
sa_size_t NTupInt_Histo2DErr::NbLines() const 
{
return(mHerr->NBinX()*mHerr->NBinY());
}

/* --Methode-- */
sa_size_t NTupInt_Histo2DErr::NbColumns() const 
{
return(6);
}

/* --Methode-- */
r_8* NTupInt_Histo2DErr::GetLineD(sa_size_t n) const
{
int i,j;
r_8 f2,f3;
if(n<0 || n>=mHerr->NBinX()*mHerr->NBinY())
    for(i=0; i<7; i++)  mRet[i] = 0.;
else { 
  i = n%mHerr->NBinX();  j = n/mHerr->NBinX(); 
  mRet[0] = i;  mRet[1] = j;
  mHerr->BinCenter(i,j,f2,f3);
  mRet[2] = f2;  mRet[3] = f3;  
  mRet[4] =  (*mHerr)(i,j);
  mRet[5] = mHerr->Error2(i,j);
  mRet[6] = mHerr->NEntBin(i,j);
}
return(mRet);
}

/* --Methode-- */
string NTupInt_Histo2DErr::VarList_C(const char* nx) const
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,j,x,y,val,err2,nb; \n";
vardec += "i = " + nomx + "[0];  j = " + nomx + "[1]; \n";
vardec += "x = " + nomx + "[2];  y = " + nomx + "[3]; \n";
vardec += "val = " + nomx + "[4];  err2 = " + nomx + "[5]; \n";
vardec += "nb = " + nomx + "[6]; \n";
return(vardec);
}

