// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour HistoErr
//             C. Magneville                    2007
// (C) LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMHERRADAPTER_H_SEEN
#define NOMHERRADAPTER_H_SEEN

#include "nomgadapter.h"
#include "histerr.h"
#include "hist2err.h"

//-----------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet HistoErr
//-----------------------------------------------------------------------------

class NOMAdapter_HistoErr : public NObjMgrAdapter {
public:
				NOMAdapter_HistoErr(HistoErr* h = NULL);
  virtual			~NOMAdapter_HistoErr();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  virtual void			SavePPF(POutPersist& s, string const & nom);

// Returns a string with synthetic information about the object
  virtual string                GetInfoString(int lev=0);

  virtual string                GetInfoString(vector<string>& opts);

  virtual void			Print(ostream& os, int lev=0);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=0.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  HistoErr* mHerr;
};

// Class Interface NTuple pour HistoErr
class NTupInt_HistoErr : public NTupleInterface {
public:
			NTupInt_HistoErr(HistoErr* h);
  virtual		~NTupInt_HistoErr();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  HistoErr* mHerr;
  mutable r_8 mRet[5];
};

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo2DErr
//-------------------------------------------------------------------------

class NOMAdapter_Histo2DErr : public NObjMgrAdapter {
public:
				NOMAdapter_Histo2DErr(Histo2DErr* h = NULL);
  virtual			~NOMAdapter_Histo2DErr();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os, int lev=0);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual P2DArrayAdapter*      Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=0.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

  virtual string                GetInfoString(vector<string>& opts);

protected:
  Histo2DErr* mHerr;
};

// Class Interface NTuple pour Histo2DErr
class NTupInt_Histo2DErr : public NTupleInterface {
public:
			NTupInt_Histo2DErr(Histo2DErr* h);
  virtual		~NTupInt_Histo2DErr();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Histo2DErr* mHerr;
  mutable r_8 mRet[7];
};

#endif
