#ifndef GENERICFUNC_H
#define GENERICFUNC_H

#include "pexceptions.h"
#include <vector>

namespace SOPHYA {

//! Abstract interface definition for functions (double f(double)) viewed as classes
class GenericFunc {
public:
  GenericFunc(void) { } 
  virtual ~GenericFunc(void) { }

  virtual double operator()(double x) {
    cout<<"GenericFunc::operator(double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double) not implemented");
  }

  virtual double operator()(double x,double y) {
    cout<<"GenericFunc::operator(double,double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double,double) not implemented");
  }

  virtual double operator()(double x,double y,double z) {
    cout<<"GenericFunc::operator(double,double,double) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double,double,double) not implemented");
  }

  virtual double operator()(double* x) {
    cout<<"GenericFunc::operator(double*) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(double*) not implemented");
  }

  virtual double operator()(vector<double>& x) {
    cout<<"GenericFunc::operator(vector<double>&) not implemented"<<endl;
    throw NotAvailableOperation("GenericFunc::operator(vector<double>&) not implemented");
  }

};

}

#endif
