// This may look like C code, but it is really -*- C++ -*-
// Classe traceur d histogramme                 96-99
//            C. Magneville / R. Ansari       2000-2007
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PIHISTO_H
#define PIHISTO_H

#include "pidrawer.h"
#include "phistwrapper.h"


class PIHisto : public PIDrawer {
public:
                     PIHisto(P1DHistoWrapper* histowp, bool ad=true);
  virtual           ~PIHisto();
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();

  inline  P1DHistoWrapper*     HistoWrapper() {return(mHistoWp);}

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
  virtual void       GetOptionsHelpInfo(string& info);

// Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);

protected:
  virtual void       DrawStats(PIGraphicUC* g);
  P1DHistoWrapper*   mHistoWp;
  bool mAdDO;
  bool stats;        // if true: draw text with statistical information
  bool filled;       // if true: fill histo with fg color
  bool pline;        // if true: draw histogram as polyline 
  bool error;        // if true: draw error bars
  float spoX, spoY;  // Stat pos offset par rapport a position defaut
};

#endif
