// This may look like C code, but it is really -*- C++ -*-
// Module PIext :   PIHisto2D PIH2DWdg 
// Traceur Histo-2D    C. Magneville 97-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIHISTO2D_H
#define PIHISTO2D_H

#include "pisysdep.h"
#include PIMENU_H 
#include PIMENUBAR_H 
#include PIOPTMENU_H

#include "pidrawer.h"
#include "piscdrawwdg.h"

#include "phistwrapper.h"

////////////////////////////////////////////////////////////////////
class PIHisto2D : public PIDrawer {
public:
  PIHisto2D(P2DHistoWrapper* h2wp, bool ad=false);
  virtual ~PIHisto2D();

  void UseColors(bool fg=false,CMapId cmap=CMAP_GREYINV32,bool revcmap=false);
  void UseScale(unsigned short type=0,double logscale=10.);
  void UseDisplay(unsigned short type=0,double fnpt=0.5);
  void UseDyn(double hmin=1.,double hmax=-1.);
  void UseFrac(double frmin=0.1,double frmax=0.9);
  void Print(int lp=0);

  virtual void Draw(PIGraphicUC* g,double xmin,double ymin,double xmax,double ymax);

  //AppendTextInfo a faire un jour - Reza 21/01/2002 
  //virtual void AppendTextInfo(string& info,double xmin,double ymin
  //                           ,double xmax,double ymax);

  // Ce que fait l'action de clic avec la souris
  virtual void GetClickInfo(string& info, double x, double y
                           ,double x0=0.,double y0=0.,bool fgdiff=false); 

  virtual void UpdateLimits();
  virtual void DrawStats(PIGraphicUC* g);
  inline  void SetStats(bool fg=true) {stats=fg;}
  inline  void SetStatPosOffset(double ofx=-0.01, double ofy=-0.01) 
          {spoX=ofx; spoY=ofy; }

  //  Methode permettant l'affichage d'une fenetre de controle specialisee 
  virtual void ShowControlWindow(PIBaseWdgGen* wdg);
  //  Desactivation de la fenetre de controle specialisee
  virtual void DeactivateControlWindow(PIBaseWdgGen* wdg);

  //   Methode de decodage des options
  virtual int  DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int  OptionToString(vector<string> & opt) const;
  virtual void GetOptionsHelpInfo(string& info);

  // Methodes inline
  inline P2DHistoWrapper*       HistoWrapper()   {return(mHistoWp);}
  inline bool           Color()       {return(mFgCol);}
  inline CMapId         ColMap()      {return(mCmap);}
  inline bool           IsColMapRev() {return(mRevCmap);}
  inline unsigned short TypScale()    {return(mTypScal);}
  inline unsigned short TypDisplay()  {return(mTypDisp);}
  inline double         FPoints()     {return(mFPoints);}
  inline double         HMax()        {return(mHMax);}
  inline double         HMin()        {return(mHMin);}
  inline double         FMax()        {return(mFracMax);}
  inline double         FMin()        {return(mFracMin);}
  inline double         LogScale()    {return(mLogScale);}

protected:
  int NPixBin(PIGraphicUC* g);
  char HPrint2(double f);

  P2DHistoWrapper* mHistoWp;
  bool mAdDO; bool stats;
  bool mFgCol; CMapId mCmap; bool mRevCmap;
  unsigned short mTypScal; double mLogScale;
  unsigned short mTypDisp; double mFPoints;
  double mHMin,mHMax;
  double mFracMin,mFracMax;
  double spoX, spoY; // Stat pos offset par rapport a position defaut
};

////////////////////////////////////////////////////////////////////
class H2WinArg : public PIWindow {
public :
  H2WinArg(PIMsgHandler* par);
  ~H2WinArg();

  static void ShowPIHisto2DTools();
  static void ShowPIHisto2DTools(PIBaseWdgGen* cbw);
  static void HidePIHisto2DTools();
  static void SetCurrentBaseWdg(PIBaseWdgGen* cbw);
  static void SetCurrentPIHisto2D(PIHisto2D* h2ddrw);

  static PIBaseWdgGen* GetCurrentBaseWdg();
  static PIHisto2D* GetCurrentPIHisto2D();

  void SetText();

  virtual void Show();
  virtual void Process(PIMessage msg,PIMsgHandler* sender,void* data=NULL);

protected:
  static PIBaseWdgGen * mBWdg;
  static PIHisto2D*  mH2DDrw;

  PIOptMenu * mOPop[3];
  PIMenu    * mCasc[3];
  PIButton  * mBut[4];
  PILabel   * mLab[4];
  PIText    * mText[3];
  PIScale   * mPScal;
  PICheckBox* mCkb;

  bool mFgCol; CMapId mCmap; bool mRevCmap;
  unsigned short mTypScal; double mLogScale;
  unsigned short mTypDisp; double mFPoints;
  double mHMin,mHMax;
  double mFracMin,mFracMax;
};

#endif
