// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PINTuple et PINTupleWdg
// Traceur d objet de type NTupleInterface

#ifndef PINTUPLE_H
#define PINTUPLE_H

#include "ntupintf.h"
#include "pidrawer.h"

class PINTuple : public PIDrawer {
public:
                     PINTuple(NTupleInterface* nt, bool ad);
  virtual           ~PINTuple();
  

  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
  virtual void       SelectXY(const char* px, const char* py);
  virtual void       SelectWt(const char* pw=NULL);
  virtual void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL);
  virtual void       SelectLabel(const char* plabel=NULL);

  inline  void       ConnectPoints(bool fg=false) { connectPts = fg; }

  // Gestion de la representation de poids
  inline  void       UseSizeScale(bool fg=true, int nbins=5)
    { mrkSzScale = fg; if (nbins>0) nWbins = nbins; }
  inline  void       UseColorScale(bool fg=true) { colorScale = fg; }

  inline  bool       GetSizeScale(int& nbins) 
    { nbins = nWbins; return mrkSzScale; }
  inline  bool       GetColScale() { return colorScale; }

  inline  void       SetStats(bool fg=true) { stats = fg; }
  inline  void       SetStatPosOffset(double ofx=-0.01, double ofy=-0.01) 
          {spoX=ofx; spoY=ofy; }

  virtual void       AppendTextInfo(string& info, double xmin, double ymin, double xmax, double ymax);

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
//   Texte d'aide des options disponibles
  virtual void       GetOptionsHelpInfo(string& info);

// Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);
       
protected:
  NTupleInterface* mNT;
  bool mAdDO;
  int xK, yK;          // Index du nom de variable en X/Y ds le ntuple
  int xebK, yebK;      // Index du nom de variable en ErrBarX/Y ds le ntuple
  int wK;              // Index du nom de variable poids
  int lK;              // Index du nom de variable label (affiche en texte)
  double wMin, wMax;   // Valeurs de poids min/max
  bool mrkSzScale;     // true -> Taille de markers variable suivant poids
  int nWbins;          // Nombre de bins taille de marker variable
  bool colorScale;     // true -> Couleur de marker variable suivant poids
  bool stats;               // true -> indication du nb de points
  bool connectPts;          // true -> les points sont relies par une ligne
  double spoX, spoY; // Stat pos offset par rapport a position defaut
  long NptDraw; // nombre de points effectivement dessines dans la fenetre
};

#endif




