//#include "manip.h"
#include <stdio.h>
#include "archeops.h"


/**********  coefficients  pour  les  mesures  bolo    ********************************/
/*                         toutes les puissances en pW                                */
/*	-1-	loi de reponse thermique des bolos  avec R en ohms et T en Kelvin     */
/*                                                                                    */
/* 	T =  coef2  *   (   ln (  R / coef1) **  ( -1 / coef0 )                       */
/*                                                                                    */
/*	-2-	fuite thermique du bolo   coef 3,4                                    */
/*                                                                                    */
/*	Ptot =  coef3  *  ( (10*Tb) ** coef4    -    (10*Tcryo)  **  coef4 )          */
/*                                                                                    */
/*	-3-	calcul empirique de Pciel et de  tau	  coef  5,6                   */
/*                                                                                    */
/*	Pciel	=	coef5	- Pelec		coef5= I * Ai (tables xavier) 	      */
/*	tau	=	- ln ( 1 +  Pciel / coef6 )	coef6= I * Bi (tables xavier) */
/*                                                                                    */
/**************************************************************************************/


/**************************************************************************************/
/*                                                                                    */
/*   pour les MLPA      :  gain = 100   diviseur = 101  ou  330                       */
/*   pour les bebodiff  :  gain = diviseur = 100Kohm / R preampli                     */
/*   pour les bebodiff  :  la capa est corrigee d'un facteur 0.868                    */
/*   pour les cartes modifiees : mettre diviseur=0                                    */
/*                         et capa = la resistance de chage en Megohm                 */
/*                                                                                    */
/**************************************************************************************/


/*  nom  ,  on/off  ,  0 = MLPA       , N bolo ,  gain_pa  , capa*1000 , diviseur , coef*10000
/*       ,  0 ou 1  ,  2..8 = BEBO    ,  hard   ,           ,  4700     ,  333     , 
/*                     10 = Bediff    ,         ,           , 

/* pour les bediff (code 10)  le n de bolo est  N de bebo*8  +  numero dans la bebo
/*  soit :  1 2 3 4 5 6  ..  9 10 11 12 13 14 .. 17 18 19 20 21 22 .. etc


/*debut_param*/
/*----------------------------------  fenetre :  -----------------------------------*/

param_bolo  parametr={24,24,36,88,18,

{
{ "v1-bedif1"  , 1,10,1 ,  200, 22000,  200, { 5000   , 123100 , 334200 } },		
{ "v1-bedif2"  , 1,10,2 ,  200, 22000,  200, { 5000    , 12.31 , 33.42 		} },
{ "v1-bedif3"  , 1,10,3 ,  200, 22000,  200, { 5000    , 50.0 , 14.0 		} },
{ "v1-bedif4"  , 1,10,4 ,  200, 22000,  200,  { 5000    , 12.31 , 33.42 	} },
{ "v1-bedif5"  , 1,10,5 , 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 	} },
{ "v1-bedif6"  , 1,10,6 , 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 	} },

{ "v1-bedif7"  , 1,10,9 , 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif8"  , 1,10,10, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif9"  , 1,10,11, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif10" , 1,10,12, 1000, 4700, 1000,  { 5000     , 12.31 , 33.42 		 } },
{ "v1-bedif11" , 1,10,13, 1000, 4700, 1000, { 5000     , 12.31 , 33.42 		 } },
{ "v1-bedif12" , 1,10,14, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },

{ "v1-bedif13" , 1,10,17, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif14" , 1,10,18, 1000, 4700, 1000,  { 5000     , 12.31 , 33.42 		 } },
{ "germanium"  , 3,10,19, 1000, 22000 ,    0,  { 5000      , 12.31 , 33.42 		 } },
{ "therm_4k"   , 3,10,20, 1000, 1000  ,    0,  { 5000      , 12.31 , 33.42 		 } },
{ "therm_1.6k" , 3,10,21, 1000, 1000  ,    0,  { 5000      , 12.31 , 33.42 		 } },
{ "therm_10k"  , 3,10,22, 1000, 1000  ,    0,  { 5000     , 12.31 , 33.42 		 } },

{ "v1-bedif19"  , 2,10,25 , 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif20"  , 2,10,26, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif21"  , 2,10,27, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } },
{ "v1-bedif22"  , 2,10,28, 1000, 4700, 1000,  { 5000     , 12.31 , 33.42 		 } },
{ "v1-bedif23"  , 2,10,29, 1000, 4700, 1000,  { 5000     , 12.31 , 33.42 		 } },
{ "v1-bedif24"  , 2,10,30, 1000, 4700, 1000,  { 5000      , 12.31 , 33.42 		 } }

}
};
/*fin_param*/



/* bolos campagne 1998-1999	*/
/*
reg_NbSi.J, 1, 0, 1, 100, 4.7, 333,	.5			,519.6  , 8.286
v1-231...L, 1, 0, 2, 100, 4.7, 333, .5   , 1.7   , 32.41 , 0.333 , 10  , 20.30  ,  11.41  		
v1-232...N, 1, 0, 3, 100, 4.7, 333,		
v1-237...E, 1, 0, 4, 100, 4.7, 333,

reg_JamieO, 1, 0, 5, 100, 4.7, 101,

V2-NbSi..H, 1, 0, 6, 100, 4.7, 101, .5   ,433.8  , 9.25
V2-230...B, 1, 0, 7, 100, 4.7, 333, .5   , 8.26  , 26.61 , 5.10  ,  7  , 9.354   ,  1.026
V2-205...Q, 1, 0, 8, 100, 4.7, 333,	.518 , 81    , 25.2 
V2-208...P, 1, 0, 9, 100, 4.7, 333, .5   , 12.31 , 33.42 , 0.627 , 6.5 , 8.113   ,  2.958

*/
/*bolos campagne 1997-1998	*/
/*

v1-208...J, 1, 0, 1, 100, 4.7, 333, .5   , 12.31 , 33.42 		
v1-232...L, 1, 0, 2, 100, 4.7, 333,		
v1-205...N, 1, 0, 3, 100, 4.7, 333,	.518 , 81    , 25.2	
v1-NbSi..E, 1, 0, 4, 100, 4.7, 333,	.5			,519.6  , 8.286
Jamie....O, 1, 0, 5, 100, 4.7, 101,
V2-NbSi..H, 1, 0, 6, 100, 4.7, 101, .5   ,433.8  , 9.25
V2-224...B, 1, 0, 7, 100, 4.7, 333, .5   ,3.43   , 26.6
V2-230...Q, 1, 0, 8, 100, 4.7, 333, .5   , 8.26  , 26.61
V2-231...P, 1, 0, 9, 100, 4.7, 333, .5   , 1.7   , 32.41

*/





/*debut_nom_reglage*/
/* 0->aa*/
/* 1->bb*/
/* 2->cc*/
/* 3->reglage 3  */
/* 4->reglage 4  */
/* 5->reglage 5  */
/* 6->reglage 6  */
/* 7->reglage 7  */
/*fin_nom_reglage*/







reglage_bolo  reglage_standard[8]={{


/*debut reglage 0 */
{30,76,9,1},
{0
,10
,1
,3
,10
,2
,0
,0
,1
,0
,0
,0
,0
,0
,0
,0
,0
,0
,0
,0
},{
{22,100663296}
,{-100646890,1}
,{-100646890,1}
,{22,0}
,{-100638698,1}
,{22,253952}
,{-100646890,1}
,{22,0}
,{-100646890,1}
,{-100646890,1}
,{22,0}
,{235388950,221185}
,{20,0}
,{20,0}
,{16406,0}
,{24598,0}
,{22,0}
,{24598,0}
},{
{1,22,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
},{
{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
},{0,0,0,0,0,0,0,0} 
/*fin_reglage*/

},{

/*debut reglage 1 */
{30,76,9,1},
{0
,10
,1
,3
,10
,2
,0
,0
,1
,0
,0
,0
,0
,0
,0
,0
,0
,0
,0
,0
},{
{22,100663296}
,{-100646890,1}
,{-100646890,1}
,{22,0}
,{-100638698,1}
,{22,253952}
,{-100646890,1}
,{22,0}
,{-100646890,1}
,{-100646890,1}
,{22,0}
,{235388950,221185}
,{20,0}
,{20,0}
,{16406,0}
,{24598,0}
,{22,0}
,{24598,0}
},{
{1,22,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
,{0,20,0,1}
},{
{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
,{0,1,9,1,0,0,0}
},{0,0,0,0,0,0,0,0} 
/*fin_reglage*/

},{

/*debut reglage 2 */
{31,76,9,0},
{0
,-14
,-31
,-63
,-83
,-103
,-122
,127
,1
,97
,14
,-32
,-93
,-87
,-72
,-80
,-101
,-112
,-113
,-121
},{
{22,100663296}
,{1040629782,204800}
,{1040834582,221184}
,{22,0}
,{-100450282,2}
,{22,253952}
,{-100458474,2}
,{22,0}
,{-100442090,2}
,{-100253674,253954}
,{22,0}
,{303013910,221184}
,{20,0}
,{20,0}
,{9238,0}
,{24598,301989888}
,{22,0}
,{24598,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{-15,-9,-13,-38}
,{-83,-109,-90,-68}
,{-99,-101,-67,-61}
,{-64,-60,-38,-19}
,{-28,-57,-77,-75}
,{-66,-55,-51,-68}
},{
{31,76,9,0,0,-35,-4643}
,{-55,-77,-69,-55,-44,-43,-12336}
,{-56,-85,-128,99,111,-116,-28030}
,{105,107,101,101,106,111,31615}
},{-102,-88,-94,-113,-126,101,73,70} 
/*fin_reglage*/

},{

/*debut reglage 3 */
{31,76,9,0},
{0
,-14
,-31
,-63
,-83
,-103
,-122
,127
,1
,99
,13
,96
,-93
,-87
,-72
,-80
,-101
,-112
,-113
,-121
},{
{22,100663296}
,{1040629782,204800}
,{1040834582,221184}
,{22,0}
,{-100450282,2}
,{22,253952}
,{-100458474,2}
,{22,0}
,{-100442090,2}
,{-100253674,253954}
,{22,0}
,{303013910,221184}
,{20,0}
,{20,0}
,{9238,0}
,{24598,301989888}
,{22,0}
,{24598,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{-15,-9,-13,-38}
,{-83,-109,-90,-68}
,{-99,-101,-67,-61}
,{-64,-60,-38,-19}
,{-28,-57,-77,-75}
,{-66,-55,-51,-68}
},{
{31,76,9,0,0,-35,-4643}
,{-55,-77,-69,-55,-44,-43,-12336}
,{-56,-85,-128,99,111,-116,-28030}
,{105,107,101,101,106,111,31615}
},{-102,-88,-94,-113,-126,101,73,70} 
/*fin_reglage*/

},{

/*debut reglage 4 */
{31,76,9,0},
{0
,-14
,-31
,-63
,-83
,-103
,-122
,127
,1
,99
,13
,112
,-93
,-87
,-72
,-80
,-101
,-112
,-113
,-121
},{
{22,100663296}
,{1040629782,204800}
,{1040834582,221184}
,{22,0}
,{-100450282,2}
,{22,253952}
,{-100458474,2}
,{22,0}
,{-100442090,2}
,{-100253674,253954}
,{22,0}
,{303013910,221184}
,{20,0}
,{20,0}
,{9238,0}
,{24598,301989888}
,{22,0}
,{24598,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{-15,-9,-13,-38}
,{-83,-109,-90,-68}
,{-99,-101,-67,-61}
,{-64,-60,-38,-19}
,{-28,-57,-77,-75}
,{-66,-55,-51,-68}
},{
{31,76,9,0,0,-35,-4643}
,{-55,-77,-69,-55,-44,-43,-12336}
,{-56,-85,-128,99,111,-116,-28030}
,{105,107,101,101,106,111,31615}
},{-102,-88,-94,-113,-126,101,73,70} 
/*fin_reglage*/

},{

/*debut reglage 5 */
{31,76,9,0},
{0
,-14
,-31
,-63
,-83
,-103
,-122
,127
,1
,97
,14
,-80
,-93
,-87
,-72
,-80
,-101
,-112
,-113
,-121
},{
{22,100663296}
,{1040629782,204800}
,{1040834582,221184}
,{22,0}
,{-100450282,2}
,{22,253952}
,{-100458474,2}
,{22,0}
,{-100442090,2}
,{-100253674,253954}
,{22,0}
,{303013910,221184}
,{20,0}
,{20,0}
,{9238,0}
,{24598,301989888}
,{22,0}
,{24598,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
,{0,0}
},{
{-15,-9,-13,-38}
,{-83,-109,-90,-68}
,{-99,-101,-67,-61}
,{-64,-60,-38,-19}
,{-28,-57,-77,-75}
,{-66,-55,-51,-68}
},{
{31,76,9,0,0,-35,-4643}
,{-55,-77,-69,-55,-44,-43,-12336}
,{-56,-85,-128,99,111,-116,-28030}
,{105,107,101,101,106,111,31615}
},{-102,-88,-94,-113,-126,101,73,70} 
/*fin_reglage*/

},{0

/*debut reglage 6 */
/*fin_reglage*/

},{0

/*debut reglage 7 */
/*fin_reglage*/

} };

/* ------------------------------------   corps  des fonctions	 ------------------------------ */
/* -------------------------------------------------------------------------------------------- */



unsigned long	val_long(char x)
{
unsigned long a,xl;
a=x-2;	if(x<3)  xl=x;	else	xl=((a&1) + 2)<<(a>>1);
return(xl);
}


double	val_double(char x)
{
unsigned long a,xl;
if(x<0) x=-x;	a=x;	if(!a)  xl=0;	else	xl=((a&1) + 2)<<(a>>1);
if(x>0)	return(1e-4*(double)xl);	else	return(-1e-4*(double)xl);
}

int	new_val_dac(int a,char  code)
{
if(code&0x80)	a=(code&0x7f) <<5 ;
else	{
	if(code&0x40)	a+=code&0x3f;	
	else		a-=code&0x3f;	
	}
return(a);
}




int	calcul_somme_block(block_type_modele* blk,int longueur)
{
int i,so=0;;
for(i=0;i<(longueur/4-4);i++)  so^=(int)blk->mot[i];
/* somme sur tous les mots internes	: on exclus le dbut, les codes et la fin	*/
return((so^(so>>16))&0xffff);
}




void  valide_block(block_type_modele* blk,int type,int block_num)
{
int somme,longueur;
def_long_block
longueur=long_block[type];
/*printf("valide block adresse %x  type %d  numblock %d  longueur=%d \n" */
/* 		,(unsigned)blk,type,block_num,longueur);*/
blk->debut		=	debut_block_mesure;
blk->code2		=	(((long)block_num) & 0xffffff ) | ( (((long)type)<<24)&0xff000000 );

blk->mot[longueur/4-4]  =	fin_block_mesure;
somme=calcul_somme_block(blk,longueur);
blk->code1		=	(((long)longueur)<<16)	|	somme;
}


/* Quand on est sur une machine swappee, on ne cherche pas a verifier */
/* le checksum, puisqu'on a modifie les blocs, sans swapper par exemple */
/* les chars des noms de bolometres et des chaines GPS... */
#ifdef __alpha
#define SWAP
#endif
#if defined(Linux)  || defined(linux)
#define SWAP
#endif

int  verifie_block(block_type_modele* blk)
{
int type,lg,som;
def_long_block
if(blk->debut != debut_block_mesure)					return(block_debut_erreur);
type=type_block(blk);		if( (type<0) ||(type>=nb_type_blocks) )	return(block_type_inconnu);	
lg=longueur_block(blk);		if( lg != long_block[type] )		return(block_longueur_erreur);	
if( blk->mot[(lg/4)-4]  !=	fin_block_mesure)			return(block_fin_erreur);	
#ifndef SWAP
som=calcul_somme_block(blk,lg); if( som!= somme_block(blk))		return(block_somme_erreur);
#endif
return(block_correct);
}


int  verifie_block_printf(block_type_modele* blk)
{
int type,lg,som;
def_long_block
def_nom_block
if(blk->debut != debut_block_mesure)
	{
	printf(" erreur dans le code debut de block	 \n");
	return(block_debut_erreur);
	}	

type=type_block(blk);
if( (type<0) || (type>nb_type_blocks) )	
	{
	printf(" block de type %d  inconnu\n",type);
	return(block_type_inconnu);
	}

lg=longueur_block(blk);
if( lg!=long_block[type] )	
	{
	printf(" block type %s  erreur de longueur (nominal=%d , dans le block=%d \n"
			,nom_block[type],long_block[type],lg);
	return(block_longueur_erreur);
	}

som=calcul_somme_block(blk,lg);
if( som!=somme_block(blk) )	
	{
	printf(" block type %s   :  erreur de somme (calculee=%d , dans le block=%d \n"
			,nom_block[type],som,somme_block(blk) );
	return(block_somme_erreur);
	}
	
if(blk->mot[(lg/4)-4]	!= fin_block_mesure)	
	{
	printf(" block type %s  erreur de code fin de block : trouve %x au lieu de %x \n"
			,nom_block[type],(int)blk->mot[(lg/4)-4],fin_block_mesure);
	return(block_fin_erreur);
	}

return(block_correct);
}







