#ifndef TOIINTERPOLATOR_H
#define TOIINTERPOLATOR_H

#include <deque>

class TOIInterpolator {
public:

  void enterValue(double value, long sample);
  bool   needMoreDataFor(long sample);   // need more data ? (for interp)
  bool   canGet(long sample);        // enough info ?
  double getIValue(long sample);     // can forget before sample
  double getEValue(long sample);     // can forget before sample
  long   nextSample(long sampleMin); // the next true sample available

protected:
  struct pair {
    pair(double v, long tt) : val(v), t(tt) {}
    pair() {}
    double val;
    long t;
  };
  
  deque<pair> hist;
};


#endif

