
/************************************************************************/
/*******   							*********/
/*******   	compresseur de donnes ranges en ligne		*********/
/*******  			 				*********/
/************************************************************************/

#ifndef int4
#ifdef __alpha
#define int4 int
#else
#define int4 long
#endif
#endif



/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 22 bit maximum			*/
/*	resultat de la compression cod sur 7 bit + exposant		*/
/*	n doit etre multiple de  4					*/
/*	le fichier resultat a pour longueur   n/4 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	n + 4 octets			*/
/*	pour 	n = 72	  en sortie	19 mots = 76 octets		*/

void compress_7_1(int4* in,int4*out,int n,int pasin);
void decompress_7_1(int4* in,int4*out,int n);


/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 16 bit maximum			*/
/*	resultat de la compression cod sur 4 bit + exposant		*/
/*	n doit etre  ( multiple de  7 )  + 2				*/
/*	le fichier resultat a pour longueur   (n-2)/7 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * (n-2) / 7 + 4  octets	*/
/*	pour 	n = 72	  en sortie	11 mots = 44 octets		*/

void compress_4_1(int4* in,int4*out,int n,int pasin);
void decompress_4_1(int4* in,int4*out,int n);


/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 16 bit maximum			*/
/*	resultat de la compression cod sur 3 bit + exposant		*/
/*	n doit etre  ( multiple de  9 )					*/
/*	le fichier resultat a pour longueur   n/9 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * n / 9 + 4  octets		*/
/*	pour 	n = 72	  en sortie	9 mots = 36 octets		*/


void compress_3_1(int4* in,int4*out,int n,int pasin);
void decompress_3_1(int4* in,int4*out,int n);

/************************************************************************/
/***********   							*********/
/***********   compresseur de donnes ranges par paires	*********/
/***********		(data bolo par exemple)			*********/
/***********   			 				*********/
/************************************************************************/



/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 21 bit maximum			*/
/*	resultat de la compression cod sur 7 bit + exposant		*/
/*	n doit etre multiple de  4					*/
/*	le fichier resultat a pour longueur   n/4 + 1 mot de 32 bit	*/
/*		4 * n  octets   ==>	n + 4 octets			*/
/*	pour 	n = 72	  en sortie	19 mots = 76 octets		*/


void compress_7_2(int4* in,int4*out,int n,int pasin);
void decompress_7_2(int4* in,int4*out,int n);



/*  	comprime une suite de n valeures  (dans des mots de 32 bit)	*/
/*  		valeures  codes sur 32 bit maximum			*/
/*	resultat de la compression cod sur 4 bit + exposant		*/
/*	n doit etre  ( multiple de  7 )  + 2				*/
/*	le fichier resultat a pour longueur   (n-2)/7 + 2 mot de 32 bit	*/
/*		4 * n  octets   ==>	4 * (n-2) / 7 + 8  octets	*/
/*	pour 	n = 72	  en sortie	12 mots = 48 octets		*/



void compress_4_2(int4* in,int4*out,int n,int pasin);
void decompress_4_2(int4* in,int4*out,int n);


																						
/************************************************************************/
/***********   							*********/
/***********   	definitions communes pour les compresseurs	*********/
/***********   			 				*********/
/************************************************************************/

/*Les valeures de la table d'entree sont consideres comme toujopurs positives	*/
/* les ecarts sont calculs signs sur 32 bit avant d'etre tronconns		*/

#define	shif(ec,k,q)	{while(ec>q)if(k<kmax_){k++;q<<=1;}else ec=q;while(ec<-q)if(k<kmax_){k++;q<<=1;}else ec=-q;}
#define	recup(ec,sss,k) {ec=((R>>sss)&emak_);if(ec & sgbi_ ) ec|= sign_ ; ec<<=k;}
#define	arrondi(ec,k)	((ec &  filtre[k]) +( (ec & test[k]) <<1 ) )	

