#ifndef TOIITER_H
#define TOIITER_H


#include <vector>
#include <set>
#include <string>
#include "archeopsfile.h"

enum TOIKind {
  sampleNum,  // Numero d'echantillon (timer interne transputer)
  internalTime, // temps transputer depuis debut manip, en secondes.
  utc,        // UTC (en jours, MJD = JD - 2450000). index=0 : premier bloc GPS. 1: + sioux.
  boloTens,   // tension en microVolts, filtree avec filtre carre indexe par bolometre
  boloRaw,    // tension brute, non filtree indexe par bolometre
  sstSignal,  // signal brut SST, indice = diode
  sstStarZ,   // numero de diode d'une eventuelle etoile,   i=etoile 0..n
  sstStarF,   // flux d'une eventuelle etoile,             -1 si moins de i+1 etoiles
  longitude,  // position ballon
  latitude,   // position ballon
  tsid,       // temps sideral en secondes
  azimut,     // a preciser, reconstruit SST, magneto, autres...
  alphaAxis,  // 
  deltaAxis,  //
  alphaBolo,  // sur le ciel, indexe par bolometre
  deltaBolo   // sur le ciel, indexe par bolometre

};

class TOIInterpolator;

class TOIIter {
public:
   TOIIter(TOIIter const&);   // $CHECK$ prevoir operator = ?
   ~TOIIter();
   bool Next();
   
   bool    canGetValue(int column);  // data is available for that...
   double  getValue(int column);
   bool    newValue(int column);     // a juste change ?
   bool    extendValue(int column);  // une valeur plus ancienne, etendue ?
   bool    interpValue(int column);  // une valeur interpolee avec valeur future ?
   TOIKind getKind(int column);
   int     getIndex(int column);     // si plusieurs, exemple, tension bolo 2
   
   bool    canGetTOI(TOIKind kind, int index=0);
   double  getTOI(TOIKind kind, int index=0);
   
   
   int    getBlockSampleIndex();        // numero d'echantillon dans dernier bloc bolo
   int    getSampleIndex();             // numero d'echantillon 

   block_type_param*         lastParam();  
   block_type_journal*       lastJournal();
   block_type_reglage*       lastReglage();
   block_type_dilution*      lastDilution();
   block_type_gps*           lastGPS();
   block_type_une_periode*   lastUnePeriode();
   block_type_synchro_sol*   lastSynchroSol();
   block_type_pointage_sol*  lastPointageSol();
   block_type_bolo*          lastBolo();   
   block_type_gyro*          lastGyro();
   block_type_sst*           lastSST();
   block_type_bolo_comprime* lastBoloComp();   
   block_type_gyro_comprime* lastGyroComp();
   block_type_sst_comprime*  lastSSTComp();

protected:
   TOIIter();
   void Init(); // After setting the options, opens the first file.
   
   bool NextFile();
   
   ArcheopsFile* file;
   string directory;   // If several files to be read
   string fileName;    // If only one file to be read
   set<string> files;  // list of files in the directory...
   set<string>::iterator curFile;
   
   int imes;
   
   double tStart, tEnd;
   
   double tBlock0;  // MJD du bloc numero zero...
   
   struct info {
     TOIKind kind;
     int index;
     bool triggering;
     bool interpolated;
   };
   
   int getColTOI(TOIKind kind, int index=0);
   
   long trigMask;
   
   vector<info>   infos;
   
   friend class TOISvr;
   
   // Gestion de l'interpolation, par delegation a un autre iterateur
   TOIIter* rawIter; // iterateur sans interpolation, qui avance avec retard
                     // en bufferisant les valeurs. S'il existe, on lui delegue
                     // toutes les operations agissant sur le fichier.
   TOIInterpolator* interp; // interpolateurs pour stocker les valeurs
   long lastSample;  // last interpolated sample
   long maxLookAhead;
   bool fetchAhead(); // avance d'une TOI en nourrissant les interpolateurs
   
   private:
};

#endif
