#include "toiinterpolator.h"

void TOIInterpolator::enterValue(double value, long sample)
{
  // $CHECK$ sample > back.sample
  if (!hist.empty() && sample == hist.back().t) return; // pour eviter /0
  hist.push_back(pair(value, sample));
}

bool TOIInterpolator::needMoreDataFor(long sample)
{
  if (hist.empty()) return true;
  int xx = hist.back().t;
  return (hist.empty() || sample > xx);
}

bool TOIInterpolator::canGet(long sample)
{
  return (!hist.empty() && (sample >= hist.front().t && sample <= hist.back().t));
}

double TOIInterpolator::getEValue(long sample) // can forget before sample
{
  if (!canGet(sample)) return -9.e99;   // user should have checked before
  deque<pair>::iterator i = hist.begin();
  while ((*i).t < sample) i++;
  if ((*i).t > sample) i--;
  double value = (*i).val;
  if (i != hist.begin()) {
    i--;
    hist.erase(hist.begin(), i);
  }
  return value;
}

double TOIInterpolator::getIValue(long sample) // can forget before sample
{
  if (!canGet(sample)) return -9.e99;   // user should have checked before
  
  deque<pair>::iterator i = hist.begin();
  while ((*i).t < sample) i++;
  double value;
  if ((*i).t == sample) {
    value = (*i).val;
  } else {    
    long samp2 = (*i).t;
    double val2 = (*i).val;
    i--;
    long samp1 = (*i).t;
    double val1 = (*i).val;
    value = val1 + (val2-val1)*(sample-samp1)/(samp2-samp1);
  }
  if (i != hist.begin()) {
    i--;
    hist.erase(hist.begin(), i);
  }
  return value;
}

long TOIInterpolator::nextSample(long sampleMin)
{
  for (deque<pair>::iterator i = hist.begin(); i<hist.end(); i++) 
    if ((*i).t >= sampleMin) return (*i).t;
  return -1;
}

