#ifndef SSTHANDLER_H
#define SSTHANDLER_H

#include <vector>

#ifndef nb_max_bolo
#define _archeops		//  Acquisition Archeops (avec transputer) 
#define programme
extern "C" {
#include "archeops.h"
}
#endif


class SSTHandler {
public:
  SSTHandler();
  SSTHandler(SSTHandler const&);
  SSTHandler& operator = (SSTHandler const&);
  virtual ~SSTHandler();
  
  enum process { rmveOffset = 1, 
         findStars  = 2,
         findPeriod = 4,
         findAxis   = 8 };
         
  void NeedProcess(int prcMask);
  void Has2Bars(bool, int elecOffset=0); // elecOffset : which wired together
  void ProcessBlock(block_type_sst*);
  
  int  getRawSignal(int imesure, int idiode); // for last block
  int  getSignal(int imesure, int idiode);    // for last block, imesure<0 -> history
  long getLastBlkNum() {return lastBlkNum;}

protected:
  int   diodeRaw[nb_per_block*2][48];
  int   diodeHistLength;
  int*  diodeT;       //[>nb_per_block*2]*[nb_photo_diodes];
  int   prcTodo;
  int   starHistLength;
  bool  has2bars;
  int   elecOffset;
  long  lastBlkNum;
  
  inline int& diode(int iSamp, int iDiod) {return diodeT[iSamp*nb_photo_diodes+iDiod];}
  
  struct star {
    float z;
    float m;
    double t;
  };

  vector<star>* stars;
  
  
  void DecodeTMBlock(block_type_sst*, int i, int* diodes); // mesure i -> diodes
  void RemoveOffset(); // diodeRaw -> diode, avec decalage, 1 echantillon.
  void FindStars(); // sur les 72 derniers echantillons dans diode.
};

#endif
