#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "nomhistadapter.h"
#include "pihisto.h"
#include "sohiswrap.h"

#include "pihisto2d.h"
#include "pipodrw.h"

#include "servnobjm.h"
#include "strutilxx.h"

#ifndef SANS_EVOLPLANCK
#include "objfitter.h"
// Pour les DataTable ( Depuis Avril 2005 )
#include "datatable.h"
#include "swppfdtable.h"
#endif

//-----------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo / HProf
//-----------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_Histo::NOMAdapter_Histo(Histo* o)
  : NObjMgrAdapter(o)
{
mHis = o;
}

/* --Methode-- */
NOMAdapter_Histo::~NOMAdapter_Histo()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Histo::Clone(AnyDataObj* o)
{
Histo* h = dynamic_cast<Histo *>(o);
if (h) return ( new NOMAdapter_Histo(h) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_Histo::GetDataObjType()
{
HProf * hp = dynamic_cast<HProf *>(mHis);
if(hp) return("HProf ");
else return("Histo ");
}

/* --Methode-- */
string NOMAdapter_Histo::GetInfoString(int lev)
{
  char buff[128];
  string rs;
  if (lev > 2) {
    sprintf(buff, "Histo: NBin=%d XMin=%lg XMax=%lg\n", mHis->NBins(), 
	  mHis->XMin(), mHis->XMax());
    rs += buff;
  }
  sprintf(buff, "Entries= %llu \n",mHis->NEntries());
  rs += buff;
  if (lev > 0) {
    sprintf(buff, "Overflow= %lg \n", mHis->NOver());
    rs += buff;
    sprintf(buff, "Underflow= %lg \n", mHis->NUnder());
    rs += buff;
  } 
  sprintf(buff, "Mean= %lg \n", mHis->Mean());
  rs += buff;
  sprintf(buff, "Sigma= %lg \n", mHis->Sigma());
  rs += buff;
  return rs;
}

/* --Methode-- */
string NOMAdapter_Histo::GetInfoString(vector<string>& opts)
{
  string blabla = "Histo1D: nbin binw mean sigma over under nentries ndata";
         blabla += " xmin xmax vmin vmax imin imax";

  if(opts.size() == 0) return GetInfoString(3);

  char buff[64];
  if(opts[0] == "nbin") {
    sprintf(buff, "%d",mHis->NBins());
  } else if(opts[0] == "binw") {
    sprintf(buff, "%lg",mHis->BinWidth());
  } else if(opts[0] == "mean") {
    sprintf(buff, "%lg",mHis->Mean());
  } else if(opts[0] == "sigma") {
    sprintf(buff, "%lg",mHis->Sigma());
  } else if(opts[0] == "over") {
    sprintf(buff, "%lg",mHis->NOver());
  } else if(opts[0] == "under") {
    sprintf(buff, "%lg",mHis->NUnder());
  } else if(opts[0] == "nentries") {
    sprintf(buff, "%llu",mHis->NEntries());
  } else if(opts[0] == "ndata") {
    sprintf(buff, "%lg",mHis->NData());
  } else if(opts[0] == "xmin") {
    sprintf(buff, "%lg",mHis->XMin());
  } else if(opts[0] == "xmax") {
    sprintf(buff, "%lg",mHis->XMax());
  } else if(opts[0] == "vmin") {
    sprintf(buff, "%lg",mHis->VMin());
  } else if(opts[0] == "vmax") {
    sprintf(buff, "%lg",mHis->VMax());
  } else if(opts[0] == "imin") {
     sprintf(buff, "%d",mHis->IMin());
  } else if(opts[0] == "imax") {
     sprintf(buff, "%d",mHis->IMax());
  } else {
    return blabla;
  }
  return string(buff);
}

/* --Methode-- */
AnyDataObj* NOMAdapter_Histo::CloneDataObj(bool /*share*/)
{
mHis->UpdateHisto();  // pour le cas ou c'est un HProf
HProf * hp = dynamic_cast<HProf *>(mHis);
if(hp) return( new HProf(*hp) );
else return( new Histo(*mHis) );
}

/* --Methode-- */
void NOMAdapter_Histo::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mHis->Write(pos,0,tag);
#else
ObjFileIO<Histo> fio(mHis);
fio.Write(pos, nom);
#endif
}

/* --Methode-- */
void NOMAdapter_Histo::Print(ostream& os, int lev)
{
mHis->Show(os);
if (lev > 0)  mHis->Print(60);
}

/* --Methode-- */
PIDrawer* NOMAdapter_Histo::GetDrawer(string & dopt)
{
if (typeid(*mHis) == typeid(HProf))  dopt = "fcirclemarker5 " + dopt;
else dopt = "thinline " + dopt;
HistoWrapper* hw = new HistoWrapper(mHis, false); // false: le Wrapper ne delete pas l'objet Histo mHis
PIHisto * pih = new PIHisto(hw, true); // true: PIHisto delete l'objet HistoWrapper hw
return( pih );
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Histo::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Histo(mHis) );
}

/* --Methode-- */
GeneralFitData* NOMAdapter_Histo::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
adel = false;
if(!mHis) return(NULL);

int nx = mHis->NBins();
if(nx<=0) return(NULL);

i1 = (i1<0||i1>=nx)? 0: i1;
i2 = (i2<0||i2>=nx||i2<i1)? nx-1: i2;

GeneralFitData* mGData = new GeneralFitData(1,i2-i1+1,0);
adel = true;

for(int i=i1;i<=i2;i++) {
  double x = mHis->BinCenter(i);
  double f = (*mHis)(i);
  double e = (mHis->HasErrors())? mHis->Error(i) : 1.;
  e = GeneralFitData::ComputeError(f,e,errtype,errscale,errmin);
  mGData->AddData1(x,f,e);
}

return mGData;
}

AnyDataObj* NOMAdapter_Histo::FitResidusObj(GeneralFit& mfit)
{
Histo* h = NULL;
#ifdef SANS_EVOLPLANCK
h = mHis->FitResidus(mfit); 
#else
h = new Histo(ObjectFitter::FitResidus(*mHis,mfit));
#endif
return h;
}

AnyDataObj* NOMAdapter_Histo::FitFunctionObj(GeneralFit& mfit)
{
Histo* h = NULL;
#ifdef SANS_EVOLPLANCK
h = mHis->FitFunction(mfit); 
#else
h = new Histo(ObjectFitter::FitFunction(*mHis,mfit));
#endif
return h;
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Histo::NTupInt_Histo(Histo* h)
{
mHis  = h;
mHpr  = dynamic_cast<HProf *>(h);
}

/* --Methode-- */
NTupInt_Histo::~NTupInt_Histo()
{
}

/* --Methode-- */
sa_size_t NTupInt_Histo::NbLines() const 
{
return(mHis->NBins());
}

/* --Methode-- */
sa_size_t NTupInt_Histo::NbColumns() const
{
return(5);
}

/* --Methode-- */
r_8* NTupInt_Histo::GetLineD(sa_size_t k) const
{
int i;
if ((k < 0) || (k >= mHis->NBins())) 
    for(i=0; i<5; i++)  mRet[i] = 0.;
else { 
  mRet[0] = k;  mRet[1] = mHis->BinCenter(k);
  mRet[2] = (*mHis)(k); mRet[3] = mHis->Error(k);
  if(mHpr) mRet[4] = mHpr->SumW(k); else mRet[4] = 0.;
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Histo::VarList_C(const char* nx) const
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,x,val,err,nb; \n";
vardec += "i = " + nomx + "[0];  x = " + nomx + "[1]; \n";
vardec += "val = " + nomx + "[2];  err = " + nomx + "[3]; \n";
vardec += "nb = " + nomx + "[4]; \n";
return(vardec);
}

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Histo2D
//-------------------------------------------------------------------------


/* --Methode-- */
NOMAdapter_Histo2D::NOMAdapter_Histo2D(Histo2D* o)
  : NObjMgrAdapter(o)
{
mHis = o;
}

/* --Methode-- */
NOMAdapter_Histo2D::~NOMAdapter_Histo2D()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_Histo2D::Clone(AnyDataObj* o)
{
Histo2D* h = dynamic_cast<Histo2D *>(o);
if (h) return ( new NOMAdapter_Histo2D(h) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_Histo2D::GetDataObjType()
{
return ("Histo2D ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_Histo2D::CloneDataObj(bool /*share*/)
{
return ( new Histo2D(*mHis) );
}

/* --Methode-- */
void NOMAdapter_Histo2D::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mHis->Write(pos,0,tag);
#else
ObjFileIO<Histo2D> fio(mHis);
fio.Write(pos, nom);
#endif
}

/* --Methode-- */
void NOMAdapter_Histo2D::Print(ostream& os, int lev)
{
mHis->Show(os);
if (lev > 0)  mHis->Print();
}

/* --Methode-- */
PIDrawer* NOMAdapter_Histo2D::GetDrawer(string & dopt)
{
dopt = "thinline " + dopt;
return( new PIHisto2D(new Histo2DWrapper(mHis, false), true) );
}

/* --Methode-- */
P2DArrayAdapter* NOMAdapter_Histo2D::Get2DArray(string & dopt)
{
Histo2DWrapper* hwp = new Histo2DWrapper(mHis, false);
return hwp;
}

/* --Methode-- */
NTupleInterface* NOMAdapter_Histo2D::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Histo2D(mHis) );
}


/* --Methode-- */
GeneralFitData* NOMAdapter_Histo2D::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
adel = false;
if(!mHis) return(NULL);

int nx = mHis->NBinX();
int ny = mHis->NBinY();
if(nx<=0 || ny<=0) return(NULL);

i1 = (i1<0||i1>=nx)? 0: i1;
i2 = (i2<0||i2>=nx||i2<i1)? nx-1: i2;
j1 = (j1<0||j1>=ny)? 0: j1;
j2 = (j2<0||j2>=ny||j2<j1)? ny-1: j2;

GeneralFitData* mGData = new GeneralFitData(2,(i2-i1+1)*(j2-j1+1),0);
adel = true;

for(int i=i1;i<=i2;i++) for(int j=j1;j<=j2;j++) {
  double x,y; mHis->BinCenter(i,j,x,y);
  double f = (*mHis)(i,j);
  double e = (mHis->HasErrors())? mHis->Error(i,j) : 1.;
  e = GeneralFitData::ComputeError(f,e,errtype,errscale,errmin);
  mGData->AddData2(x,y,f,e);
}

return mGData;
}

AnyDataObj* NOMAdapter_Histo2D::FitResidusObj(GeneralFit& mfit)
{
Histo2D* h2 = NULL;
#ifdef SANS_EVOLPLANCK
h2 = mHis->FitFunction(mfit);
#else
h2 = new Histo2D(ObjectFitter::FitResidus(*mHis,mfit));
#endif
return h2;
}

AnyDataObj* NOMAdapter_Histo2D::FitFunctionObj(GeneralFit& mfit)
{
Histo2D* h2 = NULL;
#ifdef SANS_EVOLPLANCK
h2 = mHis->FitFunction(mfit);
#else
h2 = new Histo2D(ObjectFitter::FitFunction(*mHis,mfit));
#endif
return h2;
}


/* --Methode-- */
string NOMAdapter_Histo2D::GetInfoString(vector<string>& opts)
{
  string blabla = "Histo2D: nbin binw nband nslice nentries ndata xmin xmax";
         blabla += " ymin ymax vmin vmax ijmin ijmax";

  if(opts.size() == 0) return blabla;

  char buff[128];
  if(opts[0] == "nbin") {
    sprintf(buff, "%d %d",mHis->NBinX(),mHis->NBinY());
  } else if(opts[0] == "binw") {
    sprintf(buff, "%lg %lg",mHis->WBinX(),mHis->WBinY());
  } else if(opts[0] == "nband") {
    sprintf(buff, "%d %d",mHis->NBandX(),mHis->NBandY());
  } else if(opts[0] == "nslice") {
    sprintf(buff, "%d %d",mHis->NSliX(),mHis->NSliY());
  } else if(opts[0] == "nentries") {
    sprintf(buff, "%d",mHis->NEntries());
  } else if(opts[0] == "ndata") {
    sprintf(buff, "%lg",mHis->NData());
  } else if(opts[0] == "xmin") {
    sprintf(buff, "%lg",mHis->XMin());
  } else if(opts[0] == "xmax") {
    sprintf(buff, "%lg",mHis->XMax());
  } else if(opts[0] == "ymin") {
    sprintf(buff, "%lg",mHis->YMin());
  } else if(opts[0] == "ymax") {
    sprintf(buff, "%lg",mHis->YMax());
  } else if(opts[0] == "vmin") {
    sprintf(buff, "%lg",mHis->VMin());
  } else if(opts[0] == "vmax") {
    sprintf(buff, "%lg",mHis->VMax());
  } else if(opts[0] == "ijmin") {
    int_4 i,j;
     mHis->IJMin(i,j);
     sprintf(buff, "%d %d",i,j);
  } else if(opts[0] == "ijmax") {
    int_4 i,j;
     mHis->IJMax(i,j);
     sprintf(buff, "%d %d",i,j);
  } else {
    return blabla;
  }
  return string(buff);
}

// -------------------------------------------------------------

/* --Methode-- */
NTupInt_Histo2D::NTupInt_Histo2D(Histo2D* h)
{
mHis = h;
}

/* --Methode-- */
NTupInt_Histo2D::~NTupInt_Histo2D()
{
}

/* --Methode-- */
sa_size_t NTupInt_Histo2D::NbLines() const 
{
return(mHis->NBinX()*mHis->NBinY());
}

/* --Methode-- */
sa_size_t NTupInt_Histo2D::NbColumns() const 
{
return(6);
}

/* --Methode-- */
r_8* NTupInt_Histo2D::GetLineD(sa_size_t n) const
{
int i,j;
r_8 f2,f3;
if ((n < 0) || (n >= mHis->NBinX()*mHis->NBinY())) 
    for(i=0; i<6; i++)  mRet[i] = 0.;
else { 
  i = n%mHis->NBinX();  j = n/mHis->NBinX(); 
  mRet[0] = i;  mRet[1] = j;
  mHis->BinCenter(i,j,f2,f3);
  mRet[2] = f2;  mRet[3] = f3;  
  mRet[4] =  (*mHis)(i,j);  mRet[5] = mHis->Error(i, j);
  }
return(mRet);
}

/* --Methode-- */
string NTupInt_Histo2D::VarList_C(const char* nx) const
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double i,j,x,y,val,err; \n";
vardec += "i = " + nomx + "[0];  j = " + nomx + "[1]; \n";
vardec += "x = " + nomx + "[2];  y = " + nomx + "[3]; \n";
vardec += "val = " + nomx + "[4];  err = " + nomx + "[5]; \n";
return(vardec);
}



//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet NTuple
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_NTuple::NOMAdapter_NTuple(NTuple* o)
  : NObjMgrAdapter(o)
{
mNt = o;
}

/* --Methode-- */
NOMAdapter_NTuple::~NOMAdapter_NTuple()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_NTuple::Clone(AnyDataObj* o)
{
NTuple* nt = dynamic_cast<NTuple *>(o);
if (nt) return ( new NOMAdapter_NTuple(nt) );
return ( new NObjMgrAdapter(o) );
}


/* --Methode-- */
string NOMAdapter_NTuple::GetDataObjType()
{
return ("NTuple ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_NTuple::CloneDataObj(bool /*share*/)
{
return ( new NTuple(*mNt) );
}



/* --Methode-- */
void NOMAdapter_NTuple::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mNt->Write(pos,0,tag);
#else
ObjFileIO<NTuple> fio(mNt);
fio.Write(pos, nom);
#endif
}

/* --Methode-- */
string NOMAdapter_NTuple::GetInfoString(vector<string>& opts)
{
if (opts.size() == 0) return NObjMgrAdapter::GetInfoString(opts); 
char buff[128];
if (opts[0] == "sizes") {
  sprintf(buff, "%ld %ld", mNt->NEntry(), mNt->NVar());
  return string(buff);   
}
else if ((opts[0] == "nlines") || (opts[0] == "nentry") || (opts[0] == "nrows")) {
  sprintf(buff, "%ld", mNt->NEntry());
  return string(buff);   
}
else if ((opts[0] == "nvar") || (opts[0] == "ncols")) {
  sprintf(buff, "%ld", mNt->NVar());
  return string(buff);   
}
else return "NTuple.Att: nlines/nentry/nrows nvar/ncols";
}

/* --Methode-- */
void NOMAdapter_NTuple::Print(ostream& os, int lev)
{
mNt->Show(os);
if (lev > 2) os << mNt->Info();
if (lev > 0) mNt->Print(0, 10*lev);
}


/* --Methode-- */
NTupleInterface* NOMAdapter_NTuple::GetNTupleInterface(bool& adel)
{
adel = false;
return(mNt);
// return( new NTupInt_NTuple(mNt) );
}

//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet XNTuple
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_XNTuple::NOMAdapter_XNTuple(XNTuple* o)
  : NObjMgrAdapter(o)
{
mNt = o;
}

/* --Methode-- */
NOMAdapter_XNTuple::~NOMAdapter_XNTuple()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_XNTuple::Clone(AnyDataObj* o)
{
XNTuple* nt = dynamic_cast<XNTuple *>(o);
if (nt) return ( new NOMAdapter_XNTuple(nt) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_XNTuple::GetDataObjType()
{
return ("XNTuple ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_XNTuple::CloneDataObj(bool /*share*/)
{
return ( new XNTuple(*mNt) );
}

/* --Methode-- */
void NOMAdapter_XNTuple::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mNt->Write(pos,0,tag);
#else
ObjFileIO<XNTuple> fio(mNt);
fio.Write(pos, nom);
#endif
}

/* --Methode-- */
void NOMAdapter_XNTuple::Print(ostream& os, int lev)
{
// os << mNt->Info();
mNt->Show(os);
}


/* --Methode-- */
NTupleInterface* NOMAdapter_XNTuple::GetNTupleInterface(bool& adel)
{
adel = false;
return(mNt);
}


//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet BaseDataTable
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_DataTable::NOMAdapter_DataTable(BaseDataTable* o)
  : NObjMgrAdapter(o)
{
mDT = o;
}

/* --Methode-- */
NOMAdapter_DataTable::~NOMAdapter_DataTable()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_DataTable::Clone(AnyDataObj* o)
{
  BaseDataTable* dt = dynamic_cast<BaseDataTable *>(o);
  if (dt) return ( new NOMAdapter_DataTable(dt) );
  else return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_DataTable::GetDataObjType()
{
  DataTable* dt = dynamic_cast<DataTable *>(mDT);
  if (dt) return ("DataTable ");
  else { 
    SwPPFDataTable* swdt = dynamic_cast<SwPPFDataTable *>(mDT);
    if (swdt) return ("SwPPFDataTable ");
    return  ("BaseDataTable ");
  }
}

/* --Methode-- */
AnyDataObj* NOMAdapter_DataTable::CloneDataObj(bool share)
{
  DataTable* dt = dynamic_cast<DataTable *>(mDT);
  if (dt) return new DataTable(*dt, share);
  else {
    SwPPFDataTable* swdt = dynamic_cast<SwPPFDataTable *>(mDT);
    if (swdt) cout << "NOMAdapter_DataTable::CloneDataObj() Object type SwPPFDataTable can not be cloned !" << endl;
    return NULL;
  }
}


/* --Methode-- */
void NOMAdapter_DataTable::SavePPF(POutPersist& pos, string const & nom)
{
  DataTable* dt = dynamic_cast<DataTable *>(mDT);
  SwPPFDataTable* swdt = dynamic_cast<SwPPFDataTable *>(mDT);
  if (dt) { 	
    ObjFileIO<BaseDataTable> fio(dt);
    fio.Write(pos, nom);
  }
  else if (swdt) {
    ObjFileIO<BaseDataTable> fio(swdt);
    fio.Write(pos, nom);
  }		
  else {
    cerr << " NOMAdapter_DataTable::SavePPF() Objet pas de type DataTable/SwPPFDataTable (nom="
	 << nom << ")" << endl;
  }
}

/* --Methode-- */
string NOMAdapter_DataTable::GetInfoString(vector<string>& opts)
{
if (opts.size() == 0) return NObjMgrAdapter::GetInfoString(opts); 
char buff[128];
if (opts[0] == "sizes") {
  sprintf(buff, "%ld %ld", mDT->NEntry(), mDT->NVar());
  return string(buff);   
}
else if ((opts[0] == "nlines") || (opts[0] == "nentry") || (opts[0] == "nrows")) {
  sprintf(buff, "%ld", mDT->NEntry());
  return string(buff);   
}
else if ((opts[0] == "nvar") || (opts[0] == "ncols")) {
  sprintf(buff, "%ld", mDT->NVar());
  return string(buff);   
}
else return "BaseDataTable.Att: nlines/nentry/nrows nvar/ncols";
}

/* --Methode-- */
void NOMAdapter_DataTable::Print(ostream& os, int lev)
{
mDT->Show(os);
if (lev < 1) return;
if (lev < 5)  mDT->Print(os, 0, lev*10);
else mDT->Print(os);
}


/* --Methode-- */
NTupleInterface* NOMAdapter_DataTable::GetNTupleInterface(bool& adel)
{
adel = false;
return(mDT);
}
