#ifndef MULTICYL_H
#define MULTICYL_H

#include "machdefs.h"
#include "sopnamsp.h"
#include "mbeamcyl.h"

/* 
   Projet BAORadio / HSHS
   Programme de simulation pour reconstruction de lobe radio.
   Reconstruction de lobe a partir de plusieurs cylindres

   R. Ansari - LAL      Jan 2007

   Note : On travaille ds un systeme sans dimension
   unite de temps = 1 = temps d'echantillonnage (f_echant = 1)
   vitesse de propagation (c) = 1
*/


//-----------------------------------------------------------------------
//--- Classe de reconstruction de plan source correspondant a un cylindre
class MultiCylinders {
public :
  // nr = nb de recepteurs
  // ns = nb d'echantillons en temps de chaque paquet
 MultiCylinders(int nr=256, int ns=1024);
 ~MultiCylinders();

 // Niveau de print de debug
 inline void SetPrintLevel(int prl=0) { PrtLev=prl; }

 // Ajout d'un cylindre, en position posY
 inline int AddCylinder(double posy)
   {  mCyl.push_back( new MultiBeamCyl(NR, NS, posy) ); return mCyl.size(); }

 MultiBeamCyl & GetCylinder(int i);

 // Specification de la frequence de base f0 et espacement des recepteurs
 inline void SetBaseFreqDa(double f0=2., double a=0.25) 
   {  freq0 = f0;   Da = a;  }

 // frequences reduites (entre 0 ... 0.5) , angle en radian, amp ~ 1
 void SetSources(BRSourceGen* brs, bool ad=true);
 inline void SetSources(BRSourceGen& brs)
   { SetSources(&brs, false); }

 // Definition du sigma du bruit gaussien sur les echantillons
 inline void SetNoiseSigma(double sig=0.) {  signoise = sig; }
 // Definition du sigma du jitter d'horloge (typ 0.01)
 inline void SetTimeJitter(double tjit=0.) { timejitter = tjit; } 
 // Definition du sigma des offsets d'horloge entre recepteurs (typ 0.02)
 inline void SetTimeOffsetSigma(double tsig=0.) { toffsig = tsig; }

 // Definition du gain et sigma de fluctuations de gain 
 // nzerogain: nb de recepteurs (choisis au hasard) avec gain mis a zero
 inline void SetGains(double g=1., double sigg=0., int nzerogain=0)
   {  gain=g;  siggain=sigg;  ngainzero = nzerogain; }


 // Fait la configuration des cylindres, et reconstruit le plan source
 // pour chaque cylindre
 void ReconstructCylinderPlaneS(bool fgzerocentre=true);

 // Reconstruction de la boite 3D des sources 
 // - halfny : nb de bin en angY = 2*halfny+1 
 // - stepangy : pas en angle Y (radian) 1 arcmin= 0.00029 rad (~Pi/11000)
 // Cette methode appelle ReconstructCylinderPlaneS(true);
 void ReconstructSourceBox(int halfny=15, double stepangy=M_PI/10000);


 // Pour recuperer une tranche reconstruite angX, angY 
 // avec la moyenne des modules entre kfmin <= k (selon z) <= kfmax 
 TMatrix< r_4 > getRecXYSlice(int kfmin, int kfmax);

 // Acces a la boite 3D de sources reconstruite
 inline TArray< complex<r_4> > & getRecSrcBox() { return cmplx_srcbox; }

 // Configure chaque cylindre a partir des parametres de la classe 
 // est appele automatiquement par ReconstructCylinderPlaneS
 void ConfigureCylinders();

 //-------------- Variables membres ------------ 
 int NR, NS;  // nb recepteurs, nb d'echantillons ds chaque paquet

 int PrtLev;   // Niveau de print de debug

 double Da; // distance entre recepteurs
 double freq0;  // frequence de base (freqvrai=f+freq0)
 
 double timejitter; // le sigma du jitter en temps des coups d'horloge
 double toffsig;    // sigma des offsets en temps
 
 BRSourceGen* src;  // Les sources
 bool adfg; // if true, delete src 

 double signoise; // sigma du bruit additif (bruit ampli ... )
 double gain, siggain;
 int ngainzero;

 vector<MultiBeamCyl *> mCyl;  // Les differents cylindres 

 TArray< complex<r_4> > cmplx_srcbox; // boite3D des sources (angX,Y,freq) reconstruit
 };


#endif
