#ifndef MBEAMCYL_H
#define MBEAMCYL_H

#include "machdefs.h"
#include "sopnamsp.h"
#include "tvector.h"
#include "brsrc.h"

/* 
   Classe de simulation simple pour estimer les effets de bruit 
   (ampli, ...) et decalages, bruit de phase d'horloge pour la 
   reconstruction de la position des sources (manip BAO-radio)
   R. Ansari - LAL      Sept 2006

   Note : On travaille ds un systeme sans dimension
   unite de temps = 1 = temps d'echantillonnage (f_echant = 1)
   vitesse de propagation (c) = 1
   Donc, lambda=1  pour f = 1

   On specifie les frequences des sources (BRSourceGen) en frequence reduite
   dans la premiere zone de Nyquist (f = 0 ... 0.5) 
   Neanmoins, on a besoin de la frequence vrai des sources --> methode SetBaseFreqDa
*/


//-----------------------------------------------------------------------
//--- Classe de reconstruction de plan source correspondant a un cylindre
class MultiBeamCyl {
public :
  // nr = nb de recepteurs (antennes) le long du cylindre
  // ns = nb d'echantillons en temps de chaque paquet
  // posy = position spatiale en Y pour chaque cylindre (unite ou lambda=1 pour f=1)
 MultiBeamCyl(int nr=1024, int ns=4096, double posy=0.);
 ~MultiBeamCyl();

 // Niveau de print de debug
 inline void SetPrintLevel(int prl=0) { PrtLev=prl; }

 // Reponse angulaire pour un recepteur (cylindre+antenne)
 // Modifier cette fonction pour tenir compte de la response angulaire
 inline double AngResponse(double angx, double angy) { return 1.; }

 inline double getCylinderYPos() { return posY; }
 // Specification de la frequence de base f0 et espacement des recepteurs
 // freq_vrai = freq_BRSourceGen + f0
 // pour f_vrai = 2, lambda = 0.5 et lambda/2 = 0.25
 inline void SetBaseFreqDa(double f0=2., double a=0.25) 
   {  freq0 = f0;   Da = a; }

 // frequences reduites (entre 0 ... 0.5) , angle en radian, amp ~ 1
 void SetSources(BRSourceGen* brs, bool ad=true);
 inline void SetSources(BRSourceGen& brs)
   { SetSources(&brs, false); }

 // Definition du sigma du bruit gaussien sur les echantillons
 inline void SetNoiseSigma(double sig=0.) {  signoise = sig; }
 // Definition du sigma du jitter d'horloge (typ 0.01)
 inline void SetTimeJitter(double tjit=0.) { timejitter = tjit; } 
 // Definition du sigma des offsets d'horloge entre recepteurs (typ 0.02)
 inline void SetTimeOffsetSigma(double tsig=0.) { toffsig = tsig; }

 // Definition du gain et sigma de fluctuations de gain 
 // nzerogain: nb de recepteurs (choisis au hasard) avec gain mis a zero
 void SetGains(double g=1., double sigg=0., int nzerogain=0);

 // Calcule les vecteurs de temps (0 1 2 ...ns-1)
 void ComputeTimeVectors();
 // Recalcule un nouveau vecteur temps - avec jitter
 void NewTJitVector(int num=-1);

 // Calcul du vecteur signal (s(t)) -  et les vecteurs TF 
 // pour le recepteur numero numdet
 // si fgsignojit==true, on calcule aussi pour Temps_Sans_Jitter
 int ComputeSignalVector(int numdet=0, bool fgsignojit=true);

 // Calcul de la matrice reconstruction du plan source (freq vs angle)
 // fgzerocentre -> angle zero au mileiu de la matrice
 void ReconstructSourcePlane(bool fgzerocentre=true);

 inline  TMatrix< complex<r_4> > & getRecSrcPlane() { return cmplx_srcplane; }

 //-------------- Variables membres ------------ 
 int NR, NS;  // nb recepteurs, nb d'echantillons ds chaque paquet
 double posY;    // Position selon Y (E-O) de la ligne de recepteurs

 int PrtLev;   // Niveau de print de debug

 double Da; // distance entre recepteurs
 double freq0;  // frequence de base (freqvrai=f+freq0)
 
 Vector texact;  // les temps exact
 Vector tjitt;   // temps avec jitter
 Vector toffset;  // Offset en temps entre recepteurs 
 double timejitter; // le sigma du jitter en temps des coups d'horloge
 double toffsig;    // sigma des offsets en temps
 
 BRSourceGen* src;  // Les sources
 bool adfg; // if true, delete src 

 double signoise; // sigma du bruit additif (bruit ampli ... )
 
 TVector<r_4> gain;  // Gain de chaque recepteur 

 TVector<r_4> signal; // signal sans jitter en temps 
 TVector<r_4> sigjitt; // signal avec jitter en temps

 TVector< complex<r_4> > f_sig, f_sigjit;  // TF des vecteurs signal , sigjitt

 TMatrix< complex<r_4> > cmplx_srcplane; // composantes complexe du plan-source reconstruit
 // TMatrix<r_4> rec_srcplane;  // Matrice plan source colonnes->angX, lignes->freq 
 };


#endif
