// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIFont 
// LAL (Orsay) / IN2P3-CNRS              R. Ansari  99

#ifndef PIFONTGEN_H_SEEN
#define PIFONTGEN_H_SEEN

#include "pisysdep.h"

enum PIFontName { PI_DefaultFont = 0, PI_CourierFont = 1, PI_SymbolFont = 2};

enum PIFontSize { PI_NotDefFontSize = -1, 
                  PI_SmallSizeFont = 1, PI_NormalSizeFont = 2, 
                  PI_BigSizeFont = 3, PI_HugeSizeFont = 4 };

enum PIFontAtt { PI_NotDefFontAtt = -1,
                 PI_RomanFont = 1, PI_BoldFont = 2, PI_ItalicFont = 4 };

class PIFontGen
{
public:
		PIFontGen(PIFontName fn = PI_DefaultFont);
		PIFontGen(int npt, PIFontName fn = PI_DefaultFont, 
                          PIFontAtt fa = PI_RomanFont);
// PIFont doit avoir un constructeur de copie, et l'operateur egal de defini
// ainsi que l'operateur test d'egalite
  virtual	~PIFontGen();

  virtual void		SetFont(PIFontName fn)		= 0;
  virtual void		SetFontAtt(PIFontAtt fa)	= 0;
  virtual void		SetFontSz(PIFontSize fs)	= 0;
  virtual void		SetFontSzPt(int npt)		= 0;

  virtual PIFontName    GetFontName()			= 0;
  virtual PIFontAtt     GetFontAtt()			= 0;
  virtual int		GetFontSize()			= 0;

  virtual int		GetFontHeight(int& asc, int& desc)	= 0;
  virtual int		GetStringWidth(char const* s)		= 0;
};

#endif      // PIFONTGEN_H_SEEN
