#ifndef BRSOURCE_H
#define BRSOURCE_H

#include "machdefs.h"
#include "sopnamsp.h"
#include "tvector.h"
#include "ntuple.h"

/* 
   Projet BAORadio / HSHS
   Programme de simulation pour reconstruction de lobe radio.
   Reconstruction de lobe a partir de plusieurs cylindres

   R. Ansari - LAL      Sep 2006

*/

//--------------------------------
// Classe auxiliaire pour generer une liste de sources
class BRSourceGen {
public:
  // Pour fabriquer une liste de ns=3*9*5=135 sources, repartis en 3 frequences (0.1,0.25,0.4)
  // regulierement repartis en angle X : 9 angX en +/- pas de Pi/12
  //                           angle Y : 5 angY en +/- pas de Pi/3000
  BRSourceGen(); // fabrique un pattern fixe de 20 sources

  // Generation d'une liste de source aleatoirement reparties en freq,angX,angY
  // @ lambda ~ 0.5 m et D = 50 m , limite de diffraction ~ pi/300
  BRSourceGen(int ns, double maxangXrad=M_PI/3., double maxangYrad=M_PI/60.,
	      double minfreq=0.05, double minamp=0.3, double maxamp=1.5);

  // Generation de nsf sources pour chaque frequence f[k], reparties aleatoirement en angX,Y
  BRSourceGen(vector<double> f, int nsf, 
	      double maxangXrad=M_PI/3., double maxangYrad=M_PI/500.,
	      double minfreq=0.05, double minamp=0.3, double maxamp=1.5);

  // Pour relire les sources depuis un fichier
  BRSourceGen(string ppfname);

  inline int NbSources() { return freq.Size(); }

  void WritePPF(string ppfname);
  void ReadPPF(string ppfname);

  void Print(ostream& os);

  // Retourne la liste des sources sous forme de NTuple
  // freq0= frequence de base qui s'ajoute aux freq[k]
  NTuple Convert2Table(double freq0=0.);   

//private:
  //-------- Variables / objets membres 
 Vector freq; // frequence des sources
 Vector amp;  // amplitude des sources
 Vector angX;  // direction des sources en radian, selon l'axe X=N-S : kx=sin(ang)
 Vector angY; // direction des sources selon Y=E-O : ky=sin(angY)

 Vector phase;  // Phase des sources (choisi aleatoirement pour le moment) 
};



#endif
