#ifndef CONSTCOSMO_SEEN
#define CONSTCOSMO_SEEN

static const double SpeedOfLight_Cst = 299792.458; // speed of light "km/sec"
static const double G_Newton_Cst = 6.6742e-11; // G_N in SI units "m^3 / kg /s^2"
static const double h_Planck_Cst = 6.6260693e-34;   // Planck constant SI units "J s"
static const double k_Boltzman_Cst = 1.3806503e-23;  // Boltzman constant SI "J / K"
//            Sigma = 2*PI^5*K^4/(15.*C^2*H^3) = PI^2*K^4/(60.*Hbar^3*C2)
static const double StefBoltz_Cst = 5.670400e-8; // constante de Stefan-Boltzman in "W/m^2/K^4"
static const double Zeta_3_Cst = 1.2020569031595942854; // Zeta(3)

static const double YeartoSec_Cst = 31556925.2; // 1 year into seconds
static const double MpctoMeters_Cst = 3.0856e+22; // 1 Mpc into meters
static const double LightYear_Cst = 9.46073042e+15; // 1 Light-Year into "m"
static const double Jansky2Watt_cst = 1.e-26;  // 1 Jansky into "Watt/m^2/Hz == J/m^2"
static const double SolarMass_Cst = 1.98844e+33; // 1 Solar mass into "g"
//                  GCm3toMsolMpc3_Cst = (MpctoMeters_Cst*100)^3 / SolarMass_Cst
static const double GCm3toMsolMpc3_Cst = 1.477428208143872e+40; // 1 g/cm^3 into 1 Msol/Mpc^3
static const double ProtonMass_Cst = 1.67262171e-24; // 1 "proton mass" in "g"
static const double Deg2Rad_Cst = (M_PI/180.); // 1 deg into rad

static const double T_CMB_Par = 2.725;  // temperature du CMB en "K"
static const double T_NU_Par = 1.9;  // temperature des neutrinos en "K"
static const double Fr_HyperFin_Par = 1.420405751786;  // frequence de la raie hyperfine HI en "GHz"

#endif
