#include "sopnamsp.h"
#include "machdefs.h"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "timing.h"
#include "ntuple.h"

#include "geneutils.h"

// cmvtintfun [n] [xmin,xmax,npt]

class MyFunc : public GenericFunc {
public:
  MyFunc(double n) {n_=n;}
  virtual ~MyFunc(void) {};
  virtual double operator() (double x)
          {return (n_>=0.) ? pow(x,n_) : exp(n_*x);}
  double integ(double xmin,double xmax) {
    return (n_>=0.) ? (pow(xmax,n_+1.)-pow(xmin,n_+1.))/(n_+1.)
                    : (exp(n_*xmax)-exp(n_*xmin))/n_;
  }
protected:
  double n_;
};


int main(int narg,char *arg[])
{

  double n=3.;
  if(narg>1) sscanf(arg[1],"%lf",&n);
  double xmin=1., xmax=10.;
  int npt = 100;
  if(narg>2) sscanf(arg[2],"%lf,%lf,%d",&xmin,&xmax,&npt);

  double lxmin=log10(xmin), lxmax=log10(xmax);
  double perc=0.01;
  double dxinc=(xmax-xmin)/npt, dxmax=-1.;
  double dlxinc=(lxmax-lxmin)/npt, dlxmax=-1.;
  unsigned short glorder=4;

  if(narg>1) sscanf(arg[1],"%lf",&n);
  if(narg>2) sscanf(arg[2],"%lf,%lf,%d",&xmin,&xmax,&npt);
  cout<<"n="<<n<<" xmin="<<xmin<<" xmax="<<xmax<<" npt="<<npt<<endl;

  MyFunc myfunc(n);

  double integ = IntegrateFunc(myfunc,xmin,xmax,perc,dxinc,dxmax,glorder);
  cout<<"IntegrateFunc() = "<<integ<<endl;

  double integlog = IntegrateFuncLog(myfunc,lxmin,lxmax,perc,dlxinc,dlxmax,glorder);
  cout<<"IntegrateFuncLog() = "<<integlog<<endl;

  cout<<"Integrate() = "<<myfunc.integ(xmin,xmax)<<endl;

 return 0;
}
