#ifndef AGNJACKSON_SEEN
#define AGNJACKSON_SEEN

#include "machdefs.h"
#include <math.h>
#include "genericfunc.h"
#include "histos.h"
#include "perandom.h"

namespace SOPHYA {

//----------------------------------------------------
// C.A.Jackson (New Astronomy Review 40 (2004) 1187-1193)
class AGNJackson {
public:
  AGNJackson(void);
  virtual ~AGNJackson(void);

  Histo& dNdlS(void) {return *dndls_;}
  FunRan& TirL10S(void) {return *tirls_;}
  double NObjAng(void) {return nobjang_;}
  double FluxAng(void) {return fluxang_;}
  double L10FluxJY(void) {return tirls_->Random();}
  double FluxJY(void) {return pow(10.,L10FluxJY());}
  void Print(void);

  void OrigJack(vector<double>& xjack,vector<double>& yjack);

protected:
  vector<double> xjack_,yjack_;
  double nobjang_,fluxang_;
  Histo *dndls_;
  FunRan *tirls_;

};

}

#endif
