#ifndef SCHECHTER_SEEN
#define SCHECHTER_SEEN

#include "machdefs.h"
#include "genericfunc.h"


namespace SOPHYA {

//-----------------------------------------------------------------------------------
class Schechter : public GenericFunc {
public:
  Schechter(double nstar,double mstar,double alpha);
  Schechter(Schechter& f);
  virtual ~Schechter(void);
  void SetOutValue(unsigned short outvalue=0);
  virtual double operator() (double m);
  virtual void Print(void);
protected:
  double nstar_,mstar_,alpha_;
  unsigned short outvalue_;
};

} // Fin du namespace

//-----------------------------------------------------------------------------------
double Msol2FluxHI(double m,double d);
double FluxHI2Msol(double f,double d);

#endif
