/*
 *   PSFile.cc
 *   
 *   19/06/96
 *
 *
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>

#include "psfile.h"





extern float cm2pt(float x);


/*
 *   Premier constructeur :
 *     Creation d'un fichier .ps ou .eps
 *
 */
PSFile::PSFile (char *FileName = NULL, float Tx = 0, float Ty = 0,
		float Dx = 0, float Dy = 0) {

  //    extern int FileEmpty;
  //    extern int BlocActive;
  //    extern int PageActive;

    /* Si une bounding box est precisee, on produit du .eps */
    if ( (Tx != 0) && (Ty != 0) )  isEPS = 1;
    else   isEPS = 0;


    /* Nom du fichier */
    if ( FileName != NULL ) {
	mPSFileName = new ( char[strlen(FileName)+1] );
	strcpy(mPSFileName, FileName);
    }
    else {
	mPSFileName = new ( char[11] );
	strncpy(mPSFileName, "unnamed.ps", 11);
    }

    /* Ouverture du fichier, en mode w+ (tout est ecrase) */
    if ( (mPSFile = fopen(FileName, "w+")) == NULL){
	  perror (FileName);
	  return;
    }

    /* Initialisations... */
    mFormat.X0 = 0;  /* Pr le moment ... */
    mFormat.Y0 = 0;
    mFormat.orientation = LANDSCAPE;
    if ( (Tx == 0) || (Ty == 0) ) {
	mFormat.Tx = PAGE_WIDTH;
	mFormat.Ty = PAGE_HEIGHT;
    }
    else {
      mFormat.Tx = Tx;
      mFormat.Ty = Ty;
    }
    if ( (Dx == 0) || (Dy == 0) ) {
	mFormat.Dx = mFormat.Tx;
	mFormat.Dy = mFormat.Ty;
    }
    else {
      mFormat.Dx = Dx;
      mFormat.Dy = Dy;
    }
    PageCounter  = 0;
    mDrawColor = PI_Black;
    mFillColor = PI_Black;
    mFontAtt   = PI_RomanFont;
    mFontSize  = PI_NormalSizeFont;
    mLineAtt   = PI_NormalLine;
    mMarker    = PI_DotMarker;

    /* Ecriture de l'en tete */
    WriteHeader();
}

/*
 * Second constructeur 
 *
 * Extraction d'un bloc ou d'une page
 * d'un fichier deja existant
 *
 */
//PSFile::PSFile(char * FileName, PSFile *File = NULL , int PageNum = 0, 
//	       int BlocNum = 0) {
//
//    PageList::iterator PIt;
//    char *buffer;
//
//    if ( (File == NULL) || (PageNum == 0) ) {
//	fprintf(stderr, "PSFile::PSFile : args incorrects\n");
//	return;
//    }
//
// 
//    if ( FileName != NULL ) {
//	mPSFileName = new ( char[strlen(FileName)+1] );
//	strcpy(mPSFileName, FileName);
//    }
//    else {
//	mPSFileName = new ( char[11] );
//	strncpy(mPSFileName, "unnamed.ps", 11);
//    }
//
//
//    if ( PageCounter >= PageNum  ) {
//	for(PIt = (File)->mPageList.begin(); PIt < (File)->mPageList.end(); 
//	    PIt++);
//	PIt--;
//    }
//    else {
//	fprintf(stderr, "Page %d inexistante\n", PageNum);
//	return;
//    }
//
//    if (BlocNum != 0) {
//	if ( (*PIt).BlocCounter >= BlocNum ) {
//	    for(BIt=(*PIt).mBlocList.begin();PIt<(*PIt).mBlocList.end();BIt++);
//	    BIt--;
//	}
//	else {
//	    fprintf(stderr,"Bloc %d, (Page %d) inexistant\n",BlocNum,PageNum);
//	    return;
//	}
//    }
//
//    if ( (mPSFile = fopen(FileName, "w+")) == NULL){
//	  perror (FileName);
//	  return;
//    }
//
//   mFormat.X0 = 0;
//    mFormat.Y0 = 0;
//   mFormat.orientation = PORTRAIT;
//    if ( (Tx == 0) || (Ty == 0) ) {
//	mFormat.Tx = PAGE_WIDTH;
//	mFormat.Ty = PAGE_HEIGHT;
//    }
//    if ( (Dx == 0) || (Dy == 0) ) {
//	mFormat.Dx = mFormat.Tx;
//	mFormat.Dy = mFormat.Ty;
//    }
//    PageCounter  = 0;
//    mDrawColor = PI_Black;
//    mFillColor = PI_Black;
//    mFontAtt   = PI_RomanFont;
//    mFontSize  = PI_NormalSizeFont;
//    mLineAtt   = PI_NormalLine;
//    mMarker    = PI_DotMarker;
//
//    WriteHeader();
//    WriteNewPage(&(*PIt));
//    if(BlocNum != 0)
//	WriteNewBloc(&(*BIt));
//
//    PSScan(PageNum, BlocNum, off_t limites[2]);
//    
//
//    
//    buffer = (char*)malloc(BUFSZ*sizeof(char));
//    
//    return;
//}




/* 
 * Destructeur
 *
 */
PSFile::~PSFile () {
    extern int FileEmpty;
    extern int BlocActive;
    extern int PageActive;

    /* On ferme tout ce qui ne l'est pas */
    if (BlocActive) PSFile::EndBloc();
    if (PageActive) PSFile::EndPage();

    /* Si le fichier est vide, on le detruit */
    if (FileEmpty) remove(mPSFileName);

    /* Sinon, on ecrit le "Trailer" et on ferme */
    else {
	WriteTrailer();
	fclose (mPSFile);
    }
}


int   PSFile::IsEPS(){

    return(isEPS);
}

Format *PSFile::GetFormat() {

    Format *form = (Format*)malloc(sizeof(Format));

    form->X0 = mFormat.X0;
    form->Y0 = mFormat.Y0;
    form->Tx = mFormat.Tx;
    form->Ty = mFormat.Ty;
    form->Dx = mFormat.Dx;
    form->Dy = mFormat.Dy;
    form->orientation = mFormat.orientation;
    return(form);
}

char* PSFile::GetFileName() {

    return(mPSFileName);
}

PIColors PSFile::GetDrawColor() {

    return(mDrawColor);
}

PIColors PSFile::GetFillColor() {

    return(mFillColor);
}

PIFontAtt PSFile::GetFontAtt() {

    return(mFontAtt);
}

PIFontSize PSFile::GetFontSize() {

    return(mFontSize);
}

PILineAtt PSFile::GetLineAtt() {

    return(mLineAtt);
}

PIMarker PSFile::GetMarker() {

    return(mMarker);
}

void  PSFile::NewPage(float Dx, float Dy, int orient) {

    extern int PageActive;
    extern int PageEmpty;
    Page   mNewPage;

    /* On ferme ce qui doit l'etre ... */
    if (PageActive) PSFile::EndPage();

    mNewPage.num = ++PageCounter;
    mNewPage.BlocCounter = 0;
    mNewPage.format.X0 = 0;
    mNewPage.format.Y0 = 0;
    mNewPage.format.Tx = mFormat.Tx;
    mNewPage.format.Ty = mFormat.Ty;
    mNewPage.format.Dx = Dx;
    mNewPage.format.Dy = Dy;
    mNewPage.format.orientation = orient;

    /* On enregistre la position du debut --> AVANT D'ECRIRE */
    mNewPage.offset.begin  = ftell(mPSFile);

    /* On met a jour le fichier */
    WriteNewPage(&mNewPage);

    /* On ajoute cette nouvelle page a la liste des pages du fichier */
    mPageList.push_back(mNewPage);

    PageActive = 1;
    PageEmpty  = 1;
}



void  PSFile::EndPage() {

    extern int PageActive;
    extern int BlocActive;
    extern int PageEmpty;
    extern int FileEmpty;
    PageList::iterator it;

    /* Si rien a fermer, on s'en va */
    if ( ! PageActive ) return;

    /* Si un bloc non ferme, on appelle EndBloc */
    if (BlocActive) PSFile::EndBloc();
    
    /* Si la page est vide, on la detruit */
    if (PageEmpty) {
	it = mPageList.end(); it--;
	/* Si 1 seule page ds fichier, retour au debut */
	if ( it == mPageList.begin() )
	    fseek(mPSFile, (*it).offset.begin, SEEK_SET);
	/* Sinon, on retourne a la fin de la page precedente */
	else {
	    it--;
	    fseek(mPSFile, (*it).offset.end, SEEK_SET);
	    it++;
	}
	mPageList.erase(it);
	PageCounter--;
    }
    /* Sinon, Ok, on met a jour le fichier  */
    else {
	it = mPageList.end(); it--;
	(*it).offset.end = ftell(mPSFile);
	WriteEndPage(&(*it));
	FileEmpty = 0;
    }
    PageActive = 0;
}


void  PSFile::NewBloc(float x0, float y0, float Tx, float Ty,
			      float Dx, float Dy){
    extern int BlocActive;
    extern int PageActive;
    extern int BlocEmpty;
    Bloc   mNewBloc;
    PageList::iterator it;

    /* Si pas de page, on s'en va */
    if (!PageActive) return;

    /* On ferme le bloc precedent (Pas de Bloc-gigognes ! ) */
    if (BlocActive) PSFile::EndBloc();

    it = mPageList.end(); it --;
    /* On remplit mNewBloc */
    mNewBloc.num = ++(*it).BlocCounter;
    mNewBloc.format.X0 = x0;
    mNewBloc.format.Y0 = y0;
    mNewBloc.format.Tx = Tx;
    mNewBloc.format.Ty = Ty;
    mNewBloc.format.Dx = Dx;
    mNewBloc.format.Dy = Dy;
    mNewBloc.format.orientation = 0;    /* Pr l'inst, blk non orient */
    mNewBloc.offset.begin = ftell(mPSFile);

    /* On met a jour le fichier */
    WriteNewBloc(&mNewBloc);

    /* On met a jour la liste des blocs */
    (*it).mBlocList.push_back(mNewBloc);

    BlocActive = 1;
    BlocEmpty  = 1;
}


void  PSFile::EndBloc() {
    extern int BlocActive;
    extern int BlocEmpty;
    extern int PageEmpty;
    PageList::iterator  PIt;
    BlocList::iterator  BIt;

    /* On verifie qu'un bloc ouvert existe bien */
    if ( ! BlocActive ) return;

    /* Si le bloc est vide, on le detruit */
    if (BlocEmpty) {
	PIt = mPageList.end(); PIt--;
	BIt = (*PIt).mBlocList.end(); BIt--;
	/* Si 1 seul bloc --> debut */
	if ( BIt == (*PIt).mBlocList.begin()) {
	    fseek(mPSFile,(*BIt).offset.begin, SEEK_SET);
	}
	/* Sinon, --> fin du bloc precedent */
	else {
	    BIt--;
	    fseek(mPSFile, (*BIt).offset.end, SEEK_SET);
	    BIt++;
	}   
	(*PIt).mBlocList.erase(BIt);
	(*PIt).BlocCounter--;
    }
    /* Sinon, Ok met a jour le fichier */
    else {
	PIt = mPageList.end(); PIt--;
	BIt = (*PIt).mBlocList.end(); BIt--;
	(*BIt).offset.end = ftell(mPSFile);
	WriteEndBloc(&(*BIt));
	PageEmpty = 0;
    }
    
    BlocActive = 0;
}


void  PSFile::DrawString  (float x,  float y, char *s, 
		   PIColors DrawColor  = PI_NotDefColor, 
		   PIFontAtt FontAtt   = PI_NotDefFontAtt, 
		   int FontSize        = 8) {
    extern int BlocEmpty;
    extern int PageEmpty;
    int change = 0;

    /* Couleurs */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
        WriteSetColor(mDrawColor);
    }

    /* Choix des fontes */
    if ( (FontAtt != PI_NotDefFontAtt) || (FontAtt != mFontAtt) ) {
	mFontAtt = FontAtt;
	change = 1;}
    if ( (FontSize != PI_NotDefFontSize) || (FontSize != mFontSize) ) {
	mFontSize = FontSize;
	change = 1;}
    if (change)
	WriteSetFont(mFontAtt, mFontSize);

    WriteDrawString(x, y, s);

    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawLine    (float x1, float y1, float x2, float y2, 
		   PIColors DrawColor  = PI_NotDefColor,
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Couleurs */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(mDrawColor);
    }

    /* Dessin */
    WriteDrawLine(x1, y1, x2, y2);

    BlocEmpty = 0;
    PageEmpty = 0;
}



void  PSFile::DrawBox     (float x0, float y0, float Tx, float Ty, 
		   PIColors  DrawColor = PI_NotDefColor,
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;

    /* Changement couleurs ? */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(mDrawColor);
    }

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* On dessine */
    WriteDrawBox(x0, y0, Tx, Ty);
    
    /* Le fichier n'est plus vide */
    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawFBox    (float x0, float y0, float Tx, float Ty, 
		   PIColors DrawColor  = PI_NotDefColor,
		   PIColors FillColor  = PI_NotDefColor, 
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;


    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Dessin du fond */
    if ( (FillColor != PI_NotDefColor) || (FillColor != mFillColor) )
	mFillColor = FillColor;
    WriteSetColor(mFillColor);
    WriteDrawFBox(x0, y0, Tx, Ty);
    WriteSetColor(mDrawColor);

    /* Dessin du contour (s'il y a lieu) */
    if ( (DrawColor != PI_NotDefColor) && (FillColor != DrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(DrawColor);
	WriteDrawBox(x0, y0, Tx, Ty);
    }
    /* Le fichier n'est plus vide */
    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawCircle  (float x0, float y0, float r, 
		   PIColors DrawColor  = PI_NotDefColor,
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;

    /* Couleurs */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(DrawColor);
    }

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Dessin */
    WriteDrawCircle(x0, y0, r);

    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawFCircle (float x0, float y0, float r,
		   PIColors DrawColor  = PI_NotDefColor,
		   PIColors FillColor  = PI_NotDefColor, 
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Dessin du fond */
    if ( (FillColor != PI_NotDefColor) || (FillColor != mFillColor) ){
	mFillColor = FillColor;
	WriteSetColor(FillColor);
    }
    WriteDrawFCircle(x0, y0, r);

    /* Dessin du contour (s'il y a lieu) */
    if ( (DrawColor != PI_NotDefColor) && (FillColor != DrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(DrawColor);
	WriteDrawCircle(x0, y0, r);
    }    
    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawPolygon (float *x, float *y, int n,
		   PIColors DrawColor  = PI_NotDefColor, 
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {
    extern int BlocEmpty;
    extern int PageEmpty;
    //    int change = 0;

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Couleur */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(DrawColor);
    }
    
    /* On dessine ; ici*/
    WriteDrawPolygon (x, y, n);
    
    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawFPolygon(float *x, float *y, int n,
		   PIColors DrawColor  = PI_NotDefColor,
		   PIColors FillColor  = PI_NotDefColor,
		   PILineAtt LineAtt   = PI_NotDefLineAtt) {

    extern int BlocEmpty;
    extern int PageEmpty;

    /* Line Att */
    if ( (LineAtt != PI_NotDefLineAtt) || (LineAtt != mLineAtt) ) {
        mLineAtt = LineAtt;
	WriteSetLineWidth(mLineAtt);
    }

    /* Dessin du fond... */
    if ( (FillColor != PI_NotDefColor) || (FillColor != mFillColor) ) {
	mFillColor = FillColor;
	WriteSetColor(FillColor);
    }
    WriteDrawFPolygon(x, y, n);

    /* ...puis du contour (s'il y a lieu) */
    if ( (DrawColor != PI_NotDefColor) && (DrawColor != FillColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(DrawColor);
	WriteDrawPolygon(x, y, n);
    }

    BlocEmpty = 0;
    PageEmpty = 0;
}



void  PSFile::DrawMarker  (float x0, float y0,
		   PIMarker MrkType    = PI_NotDefMarker,   
		   PIColors DrawColor  = PI_NotDefColor) {
    extern int BlocEmpty;
    extern int PageEmpty;


    /* Couleurs */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(mDrawColor);
    }

    /* Marker */
    if (MrkType != PI_NotDefMarker)
	mMarker = MrkType;

    /* Dessin */
    WriteDrawMarker(x0, y0);

    BlocEmpty = 0;
    PageEmpty = 0;
}


void  PSFile::DrawMarkers (float *x0, float *y0, int n,
		   PIMarker MrkType    = PI_NotDefMarker,
		   PIColors DrawColor  = PI_NotDefColor) {
    extern int BlocEmpty;
    extern int PageEmpty;

    /* Couleurs */
    if ( (DrawColor != PI_NotDefColor) || (DrawColor != mDrawColor) ) {
	mDrawColor = DrawColor;
	WriteSetColor(mDrawColor);
    }    

    /* Marker */
    if (MrkType != PI_NotDefMarker)
	mMarker = MrkType;

    /* Dessin */
    WriteDrawMarkers(x0, y0, n);

    BlocEmpty = 0;
    PageEmpty = 0;
}

void PSFile::Image(float x0, float y0, float Tx, float Ty,
		   int Nx, int Ny,
		   unsigned char *Pict, 
		   PIColorMap *mMap) {

    extern int BlocEmpty;
    extern int PageEmpty;

    WriteImage(x0, y0, Tx, Ty, Nx, Ny, Pict,mMap);

    BlocEmpty = 0;
    PageEmpty = 0;
}

/* 
 *  Une fonction de conversion qui sert une fois
 *
 */

float cm2pt(float x) {
    return (x*28.35);
}


    /* Logique de controle */
    static int FileEmpty = 1;
    static int PageEmpty;
    static int BlocEmpty;
    static int BlocActive;
    static int PageActive;
