#include "picontainergen.h"


#define NCHALGRP 4

/* --Methode-- */
PIContainerGen::PIContainerGen(PIContainerGen *par, char *nom, 
                               int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py) , stvis(0) 
{
mNCh = 0;
mACSup = mPaSup = false;
mChilds = new (PIWdgGen * [NCHALGRP]);
mMxCh = NCHALGRP;
}


/* --Methode-- */
PIContainerGen::~PIContainerGen()
{
mPaSup = true;   // Pour prevenir ChildDel()
if (mACSup)
  for(int i=0; i<mNCh; i++)  delete mChilds[i];
delete[] mChilds;
}

/* --Methode-- */
void PIContainerGen::PSPrint(PSFile *psf, int ofx, int ofy)
{
int i;
if (!psf)  return;
if (!Visible())  return;
for(i=0; i<mNCh; i++)  mChilds[i]->PSPrint(psf, ofx+XPos(), ofy+YPos()); 
return;
}

/* --Methode-- */
void PIContainerGen::Show()
{
stvis = 1;
return;
}

/* --Methode-- */
void PIContainerGen::Hide()
{
stvis = 0;
return;
}

/* --Methode-- */
int PIContainerGen::Visible()
{
return(stvis);
}

/* --Methode-- */
void PIContainerGen::ChildAdd(PIWdgGen* child)
{
if (child == NULL)  return;
if (mNCh == mMxCh)
  {
  PIWdgGen ** och = mChilds;
  mChilds = new (PIWdgGen * [mMxCh+NCHALGRP]);
  for(int i=0; i<mNCh; i++)  mChilds[i] = och[i];
  delete[] och;
  mMxCh += NCHALGRP;
  }  
mChilds[mNCh] = child;   mNCh++; 
return;
}

/* --Methode-- */
void PIContainerGen::ChildDel(PIWdgGen* child)
{
if (mPaSup) return;  // Ne rien faire si delete initie par Container-parent
if ((child == NULL) || (mNCh < 1))  return;
for(int i=0; i<mNCh; i++)  
  if (mChilds[i] == child)
    {
    mNCh--;
    mChilds[i] = mChilds[mNCh];
    break;
    }
return;
}


/* --Methode-- */
void PIContainerGen::SetAutoDelChilds(bool ad)
{
mACSup = ad;
return;
}
