#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "nomdvladapter.h"



//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) DVList 
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_DVList::NOMAdapter_DVList(DVList* o)
  : NObjMgrAdapter(o)
{
mDvl = o;
}

/* --Methode-- */
NOMAdapter_DVList::~NOMAdapter_DVList()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_DVList::Clone(AnyDataObj* o)
{
DVList* dvl = dynamic_cast<DVList *>(o);
if (dvl) return ( new NOMAdapter_DVList(dvl) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
string NOMAdapter_DVList::GetDataObjType()
{
  return ("DVList ");
}

/* --Methode-- */
AnyDataObj* NOMAdapter_DVList::CloneDataObj(bool)
{
  return new DVList(*mDvl);
}

/* --Methode-- */
void NOMAdapter_DVList::SavePPF(POutPersist& pos, string const & nom)
{
  ObjFileIO<DVList> fio(mDvl);
  fio.Write(pos, nom);
  return;
}

/* --Methode-- */
void NOMAdapter_DVList::Print(ostream& os, int lev)
{
  mDvl->Show(os);
  if (lev > 1) mDvl->Print(os);
}


/* --Methode-- */
string NOMAdapter_DVList::GetInfoString(vector<string>& opts)
{
if (opts.size() == 0) return NObjMgrAdapter::GetInfoString(opts); 
char buff[128];
if ((opts[0] == "nvar") || (opts[0] == "size")) {
  sprintf(buff, "%d", mDvl->Size());
  return string(buff);   
}
 else if (mDvl->HasKey(opts[0])) {
   return mDvl->GetS(opts[0]);
 }
 else if (opts[0] == "?") 
   return string("BaseDataTable.Att: nvar/size/VarName");
 else {
   cerr << "NOMAdapter_DVList::GetInfoString() - No such key=" << opts[0] 
	<< " in DVList " << endl;
   return string("");
 }
}

