#include "sopnamsp.h"
#include "machdefs.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <complex>

#include "sophyainit.h"

#include "pexceptions.h"

#include "ppersist.h"
#include "fiondblock.h"
#include "dvlist.h"

#include "fiosegdb.h" 
#include "ppfwrapstlv.h" 

#include "sversion.h"

#include <iostream>
#include <map> 

// ---  Classe d'initialisation de SOPHYA, (PPersistMgr en particulier)
int SophyaInitiator::FgInit = 0;
// Module version number - 2.0 , Jul 2006
// Module version number - 2.02 , Fev07 Ajout NDataBlock::RenewObjId()
// Module version number - 2.1 ,  Avr07 
//  - Nettoyage machdefs_mkmf.h 
//  - Ajout classe ThSafeOp ---> NDataBlock<T> Sw/SegDataBlock<T> ThreadSafe
//     
#define MOD_VERS   2.1

// Pour garder la liste des modules et leurs numeros de version
map<string, double>* ModListP = NULL;

/*!
   \namespace SOPHYA
   \brief This is the namespace for the whole Sophya package
*/

/*!
  \class SOPHYA::SophyaInitiator
  \ingroup BaseTools
  Each Sophya module may contain an initialiser class which should
  be a sub-class of SophyaInitiator.  
*/


SophyaInitiator::SophyaInitiator()
{
#if defined(Darwin)
  // Il semble y avoir un probleme sous MacOSX ...
  if (FgInit == 0) 
    cout << " SophyaInitiator::SophyaInitiator() BaseTools Init" << endl;
#endif
  FgInit++;
  if (FgInit > 1)  return;

  InitFailNewHandler();
  ModListP = new map<string, double>;
  

  // Initialisation des mecanismes PPF I/O 
  PIOPersist::Initialize();
  // Enregistrement des handlers PPF pour les NDataBlock<T> 
  PPRegister(FIO_NDataBlock<uint_1>);
  DObjRegister(FIO_NDataBlock<uint_1>, NDataBlock<uint_1>);
  PPRegister(FIO_NDataBlock<uint_2>);
  DObjRegister(FIO_NDataBlock<uint_2>, NDataBlock<uint_2>);
  PPRegister(FIO_NDataBlock<int_2>);
  DObjRegister(FIO_NDataBlock<int_2>, NDataBlock<int_2>);
  PPRegister(FIO_NDataBlock<int_4>);
  DObjRegister(FIO_NDataBlock<int_4>, NDataBlock<int_4>);
  PPRegister(FIO_NDataBlock<int_8>);
  DObjRegister(FIO_NDataBlock<int_8>, NDataBlock<int_8>);
  PPRegister(FIO_NDataBlock<uint_4>);
  DObjRegister(FIO_NDataBlock<uint_4>, NDataBlock<uint_4>);
  PPRegister(FIO_NDataBlock<uint_8>);
  DObjRegister(FIO_NDataBlock<uint_8>, NDataBlock<uint_8>);
  PPRegister(FIO_NDataBlock<r_4>);
  DObjRegister(FIO_NDataBlock<r_4>, NDataBlock<r_4>);
  PPRegister(FIO_NDataBlock<r_8>);
  DObjRegister(FIO_NDataBlock<r_8>, NDataBlock<r_8>);
  PPRegister(FIO_NDataBlock< complex<r_4> >);
  DObjRegister(FIO_NDataBlock< complex<r_4> >, NDataBlock< complex<r_4> >);
  PPRegister(FIO_NDataBlock< complex<r_8> >);
  DObjRegister(FIO_NDataBlock< complex<r_8> >, NDataBlock< complex<r_8> >);

  // Enregistrement des handlers PPF pour les TimeStamp
  PPRegister(ObjFileIO<TimeStamp>);
  DObjRegister(ObjFileIO<TimeStamp>, TimeStamp);

  // Enregistrement des handlers PPF pour les DVList
  PPRegister(ObjFileIO<DVList>);
  DObjRegister(ObjFileIO<DVList>, DVList);

  // Enregistrement des handlers PPF pour les SegDataBlock<T> 
  PPRegister(FIO_SegDataBlock<uint_2>);
  DObjRegister(FIO_SegDataBlock<uint_2>, SegDataBlock<uint_2>);
  PPRegister(FIO_SegDataBlock<int_2>);
  DObjRegister(FIO_SegDataBlock<int_2>, SegDataBlock<int_2>);
  PPRegister(FIO_SegDataBlock<int_4>);
  DObjRegister(FIO_SegDataBlock<int_4>, SegDataBlock<int_4>);
  PPRegister(FIO_SegDataBlock<int_8>);
  DObjRegister(FIO_SegDataBlock<int_8>, SegDataBlock<int_8>);
  PPRegister(FIO_SegDataBlock<uint_4>);
  DObjRegister(FIO_SegDataBlock<uint_4>, SegDataBlock<uint_4>);
  PPRegister(FIO_SegDataBlock<uint_8>);
  DObjRegister(FIO_SegDataBlock<uint_8>, SegDataBlock<uint_8>);
  PPRegister(FIO_SegDataBlock<r_4>);
  DObjRegister(FIO_SegDataBlock<r_4>, SegDataBlock<r_4>);
  PPRegister(FIO_SegDataBlock<r_8>);
  DObjRegister(FIO_SegDataBlock<r_8>, SegDataBlock<r_8>);
  PPRegister(FIO_SegDataBlock< complex<r_4> >);
  DObjRegister(FIO_SegDataBlock< complex<r_4> >, SegDataBlock< complex<r_4> >);
  PPRegister(FIO_SegDataBlock< complex<r_8> >);
  DObjRegister(FIO_SegDataBlock< complex<r_8> >, SegDataBlock< complex<r_8> >);
  PPRegister(FIO_SegDataBlock<string>);
  DObjRegister(FIO_SegDataBlock<string>, SegDataBlock<string>);

  // Enregistrement des handlers PPF pour les vecteurs de la STL
  PPRegister(PPFWrapperSTLVector<uint_2>);
  DObjRegister(PPFWrapperSTLVector<uint_2>, std::vector<uint_2>);
  PPRegister(PPFWrapperSTLVector<int_2>);
  DObjRegister(PPFWrapperSTLVector<int_2>, std::vector<int_2>);
  PPRegister(PPFWrapperSTLVector<int_4>);
  DObjRegister(PPFWrapperSTLVector<int_4>, std::vector<int_4>);
  PPRegister(PPFWrapperSTLVector<int_8>);
  DObjRegister(PPFWrapperSTLVector<int_8>, std::vector<int_8>);
  PPRegister(PPFWrapperSTLVector<uint_4>);
  DObjRegister(PPFWrapperSTLVector<uint_4>, std::vector<uint_4>);
  PPRegister(PPFWrapperSTLVector<uint_8>);
  DObjRegister(PPFWrapperSTLVector<uint_8>, std::vector<uint_8>);
  PPRegister(PPFWrapperSTLVector<r_4>);
  DObjRegister(PPFWrapperSTLVector<r_4>, std::vector<r_4>);
  PPRegister(PPFWrapperSTLVector<r_8>);
  DObjRegister(PPFWrapperSTLVector<r_8>, std::vector<r_8>);
  PPRegister(PPFWrapperSTLVector< complex<r_4> >);
  DObjRegister(PPFWrapperSTLVector< complex<r_4> >, std::vector< complex<r_4> >);
  PPRegister(PPFWrapperSTLVector< complex<r_8> >);
  DObjRegister(PPFWrapperSTLVector< complex<r_8> >, std::vector< complex<r_8> >);
  PPRegister(PPFWrapperSTLVector< string >);
  DObjRegister(PPFWrapperSTLVector< string >, std::vector<string>);

  PPRegister(PPFWrapperSTLVector< TimeStamp >);
  DObjRegister(PPFWrapperSTLVector< TimeStamp >, std::vector<TimeStamp>);


#if (!defined(__GNUG__) && !defined(HPUX))
  // pas de bufferisation pour printf   cmv 18/3/97 selon E.A.
  // setvbuf(stdout,NULL,_IOLBF,0); setvbuf(stderr,NULL,_IOLBF,0);
  setlinebuf(stdout);
  setlinebuf(stderr);
#endif

  // si var env SOPHYA_NOPRTVER definie pas de print
  if(!getenv("SOPHYA_NOPRTVER")) PrintVersion(false);

  int pnice;
  char* snice = getenv("SOPHYA_NICE");
  if (!snice) pnice=8;
  else pnice = atoi(snice);
  nice(pnice);

  SophyaInitiator::RegisterModule("BaseTools", MOD_VERS);  // Module name and version number registration  
}

SophyaInitiator::~SophyaInitiator()
{
  FgInit--;
/*
  if (FgInit == 0)
    {
    delete PPersistMgr::classList; PPersistMgr::classList = NULL;
    delete PShPersist::objList;    PShPersist::objList = NULL;
    }
    */
}

/*! 
  \brief Return the SOPHYA version number. 
  \param svers contain the complete in addition the SOPHYA tag, the compiler name 
  and the compilation date
*/
double SophyaInitiator::GetVersion(string& svers)
{
  char* compiler = 0;
  #ifdef __GNUG__
  compiler = "gcc " __VERSION__;
  #endif
  #ifdef __DECCXX
  compiler = "cxx " ;
  #endif
  #ifdef __aCC__
  compiler = const_cast<char *>("HP-aCC ") ;
  #endif
  #ifdef __KCC__
  compiler = const_cast<char *>("KCC ") ;
  #endif
  #ifdef __IBMCPP__
  #ifdef SO_ARCH64
  compiler = const_cast<char *>("IBM-xlC (-q64)") ;
  #else
  compiler = const_cast<char *>("IBM-xlC") ;
  #endif
  #endif
  #ifdef __INTEL_COMPILER
  compiler = const_cast<char *>("Intel-icc ") ;
  #endif
  #ifdef __SGICC__
  #ifdef SO_ARCH64
  compiler = const_cast<char *>("SGI-CC (-64) ") ;
  #else
  compiler = const_cast<char *>("SGI-CC ") ;
  #endif
  #endif

  char buff[512];
  sprintf(buff,"SOPHYA Version %4.1f Revision %d (%s) -- %s %s %s",
          SOPHYA_VERSION, SOPHYA_REVISION, SOPHYA_TAG,
          __DATE__, __TIME__, compiler);
  svers = buff;
  
  return(SOPHYA_VERSION + (SOPHYA_REVISION/1000.));
}

//! Print the SOPHYA version string and optionaly the list of registered modules
void SophyaInitiator::PrintVersion(bool fglist)
{
  string svers;
  GetVersion(svers);
  cout << svers << endl;
  if (fglist) ListModules(cout);   
}

//! Should be called by sub-classes to register module name and version 
int SophyaInitiator::RegisterModule(const char * name, double version)
{
  if (ModListP == NULL) 
    throw NullPtrError("SophyaInitiator::RegisterModule() ModListP= NULL !");
  map<string, double>& modlist = *ModListP;
  modlist[string(name)] = version;
  return modlist.size();
}

//! List of registered module names and version number
int SophyaInitiator::ListModules(ostream& os)
{
  if (ModListP == NULL) 
    throw NullPtrError("SophyaInitiator::ListModules() ModListP= NULL !");
  os << "--- SophyaInitiator::ListModules() Name / VersionNumber --- " << endl;
  map<string, double>& modlist = *ModListP;
  int k = 1;
  for(map<string, double>::iterator it = modlist.begin(); it != modlist.end(); it++, k++) 
    os << k << " : " << (*it).first << " V= " << (*it).second << endl; 
  os << " ----------------------------------------------------------- " << endl;
  return modlist.size();
}

//! Return the SOPHYA version number: VERS + REV/1000
double SOPHYA::SophyaVersion()
{
return(SOPHYA_VERSION + (SOPHYA_REVISION/1000.));
}
 
// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
// La presence de l'objet statique psophyainit semble poserun probleme 
// sur MacOSX 10.2 qui se plante a l'initialisation avec les shared-libs
// Suppression de #if !defined(Darwin) en Juil 2006
static SophyaInitiator psophyainit;

