#ifndef PISTDWDGGEN_H_SEEN
#define PISTDWDGGEN_H_SEEN


#include "pisysdep.h"
#include PIWDG_H

class PILabelGen : public PIWdg {
public:
  enum {ClassId = 1001};

                     PILabelGen(PIContainerGen* par, char* nom,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PILabelGen();

  virtual long       kind() {return ClassId; }
};

//  Les differents types de boutons avec un signe dessus ... 
// enum PIBtnSign {  PIBtn_Label=0, PIBtn_ArrowUp=1, PIBtn_ArrowDown=2,  
//                                 PIBtn_ArrowLeft=3, PIBtn_ArrowRight=4 };

class PIButtonGen : public PIWdg
{
public:
  enum {ClassId = 1010};

                     PIButtonGen(PIContainerGen* par, char* nom, 
                                 PIMessage msg = PIMsg_Click,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIButtonGen();

  virtual long       kind() {return ClassId; }
  virtual void       ActivatePress(bool acp=false)=0;

};


class PITextGen : public PIWdg
{
public:

  enum {ClassId = 1020};

  		     PITextGen(PIContainerGen* par, char* nom,
         		       int sx=10, int sy=10, int px=0, int py=0);
  		     PITextGen(PIContainerGen* par, char* nom, bool vsb, bool hsb,
         		       int sx=100, int sy=100, int px=0, int py=0);
  virtual	     ~PITextGen();
  virtual void       SetText(string const&) = 0;
  virtual string     GetText() const = 0;

  virtual void       SetMutiLineMode(bool mlm=false) = 0;
  virtual void       SetTextEditable(bool te=true) = 0;

  virtual long       kind() {return ClassId; }
};



class PICheckBoxGen : public PIWdg
{
public:

  enum {ClassId = 1030};

                     PICheckBoxGen(PIContainerGen* par, char* nom, 
                                  PIMessage msg = PIMsg_Click,
                                  int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PICheckBoxGen()=0;
  virtual void       SetState(bool st=false)=0;
  virtual bool       GetState()=0;
  
  virtual long       kind() {return ClassId; }

protected:

};

// Definition choix de la direction et sens pour Scale et Scroll-bar
enum {
  kSDirLtoR     = 1,
  kSDirRtoL     = 2,
  kSDirDownUp   = 4,
  kSDirUpDown   = 8
};

class PIScaleGen : public PIWdg
{
public:
  enum {ClassId = 1040};

                     PIScaleGen(PIContainerGen* par, char* nom, 
                                PIMessage msg = PIMsg_DataChanged, int dir=kSDirLtoR, 
                                int sx=100, int sy=10, int px=0, int py=0);
  virtual            ~PIScaleGen();

  virtual void       SetMinMax(int min, int max) = 0;
  virtual void       GetMinMax(int& min, int& max) = 0;
  virtual void       SetValue(int val) = 0;
  virtual int        GetValue() = 0; 

  virtual long       kind() {return ClassId; }

protected:

};

class PIScrollBarGen : public PIWdg
{
public:
  enum {ClassId = 1050};

                     PIScrollBarGen(PIContainerGen* par, char* nom, 
                                    PIMessage msg=PIMsg_DataChanged, int dir=kSDirUpDown,
                                    int sx=10, int sy=100, int px=0, int py=0);
  virtual            ~PIScrollBarGen();

  virtual void       ActivateDrag(bool acd=false) = 0;
  virtual void       SetMinMax(int min, int max) = 0;
  virtual void       GetMinMax(int& min, int& max) = 0;
  virtual void       SetValue(int val) = 0;
  virtual int        GetValue() = 0; 
  virtual void       SetSlSize(int sz) = 0;
  virtual int        GetSlSize() = 0;

  virtual long       kind() {return ClassId; }

protected:

};

#endif
