#ifndef PISTDWDGX_H_SEEN
#define PISTDWDGX_H_SEEN

#include "pistdwdggen.h"


class PILabelX : public PILabelGen
{
public:
                     PILabelX(PIContainerGen *par, char *nom,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PILabelX();
  
};

class PIButtonX : public PIButtonGen
{
public:
                     PIButtonX(PIContainerGen *par, char *nom, 
                               PIMessage msg = PIMsg_Click,
                               int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PIButtonX();

  virtual void       ActivatePress(bool acp=false);

  void               ReleaseButton();   // Fonction a utiliser avec attention

  XEvent myevt;   // Attention - Pour usage interne 

protected :
  bool mAcP;
};


class PITextX : public PITextGen
{
public:
                     PITextX(PIContainerGen *par, char *nom, 
                                  int sx=10, int sy=10, int px=0, int py=0);
  		     PITextX(PIContainerGen* par, char* nom, bool vsb, bool hsb,
         		     int sx=100, int sy=100, int px=0, int py=0);
  virtual            ~PITextX();
  virtual void       SetText(string const&);
  virtual string     GetText() const;

  virtual void       SetMutiLineMode(bool mlm=false);
  virtual void       SetTextEditable(bool te=true);

  virtual void       SetMsg(PIMessage msg=0);

protected:

SysDWdg mtext;  
};


class PICheckBoxX : public PICheckBoxGen
{
public:
                     PICheckBoxX(PIContainerGen *par, char *nom, 
                                 PIMessage msg=PIMsg_Click,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual            ~PICheckBoxX();

  virtual void       SetState(bool st=false);
  virtual bool       GetState();

  bool mSt;          // Etat du bouton, en public a cause du Callback
};



class PIScaleX : public PIScaleGen
{
public:
                     PIScaleX(PIContainerGen* par, char* nom, 
                              PIMessage msg=PIMsg_DataChanged, int dir=kSDirLtoR, 
                              int sx=100, int sy=10, int px=0, int py=0);
  virtual            ~PIScaleX();

  virtual void       SetMinMax(int min, int max);
  virtual void       GetMinMax(int& min, int& max);
  virtual void       SetValue(int val);
  virtual int        GetValue(); 

  virtual void       CBSetVal(int val);   // A ne pas utiliser (pour Callback Xt)
protected: 
  int mVal, mMin, mMax;
};



class PIScrollBarX : public PIScrollBarGen
{
public:
                     PIScrollBarX(PIContainerGen* par, char* nom, 
                                  PIMessage msg = PIMsg_DataChanged, int dir=kSDirUpDown,
                                  int sx=10, int sy=100, int px=0, int py=0);
                     ~PIScrollBarX();

  virtual void       ActivateDrag(bool acd=false);
  virtual void       SetMinMax(int min, int max);
  virtual void       GetMinMax(int& min, int& max);
  virtual void       SetValue(int val);
  virtual int        GetValue(); 
  virtual void       SetSlSize(int sz);
  virtual int        GetSlSize();

  virtual void       CBSetVal(int val);   // A ne pas utiliser (pour Callback Xt)

protected: 
  int mVal, mMin, mMax, mSz, mDir;
  bool mAcD;
};


typedef PILabelX       PILabel;
typedef PIButtonX      PIButton;
typedef PITextX        PIText;
typedef PICheckBoxX    PICheckBox;
typedef PIScaleX       PIScale;
typedef PIScrollBarX   PIScrollBar;


#endif
