#include "machdefs.h"
#include "pexceptions.h"

#include <math.h>

#include "smtx.h"

//--------------------------------------------------------
//   Test d'expression template sur tableaux 
//       Reza - Avril 2003
//--------------------------------------------------------

// ---------------------------------------------------
// ------------- Classe de matrice -------------------
// ---------------------------------------------------

template <class T>
SimpleMatrix<T>::SimpleMatrix()
  : MtxSize(), JETExpression<T, JETExpMtx<T> >(), dbv_(&data_, this) 
{
  this->Expression().JETExpMtxSet(&data_, this);
}

template <class T>
SimpleMatrix<T>::SimpleMatrix(sa_size_t nr, sa_size_t nc)
  : MtxSize(nr, nc), JETExpression<T, JETExpMtx<T> >(), data_(nr*nc), dbv_(&data_, this)
{
  this->Expression().JETExpMtxSet(&data_, this);
}

template <class T>
SimpleMatrix<T>::SimpleMatrix(const SimpleMatrix & m)
  : MtxSize(m), JETExpression<T, JETExpMtx<T> >(), data_(m.data_), dbv_(&data_, this)
{
  this->Expression().JETExpMtxSet(&data_, this);
}

template <class T>
SimpleMatrix<T>::SimpleMatrix(const SimpleMatrix & m, bool share)
  : MtxSize(m), JETExpression<T, JETExpMtx<T> >(dbv_), data_(m.data_, share), dbv_(&data_, this)
{
}

template <class T>
SimpleMatrix<T>::~SimpleMatrix()
{
}


template <class T>
void SimpleMatrix<T>::ReSize(const MtxSize & a)
{
  if (CompareSize(a)) return;
  if (this == &a) return;
  MtxSize::ReSize(a);
  data_.Realloc(nrow_*ncol_);
  return;
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::Set(const SimpleMatrix & b)
{
  if (this == &b) return(*this);
  if ((b.nrow_ == 0) || (b.ncol_ == 0) )
    throw RangeCheckError("SimpleMatrix::Set() Size(b) = 0");
  if (nrow_ == 0) {
    nrow_ = b.nrow_; ncol_ = b.ncol_; 
  }
  else if ((nrow_ > 0) && ((nrow_ != b.nrow_) || (ncol_ != b.ncol_)) )
    throw(SzMismatchError("SimpleMatrix::Set() Size(a) != Size(b)"));
  data_ = b.data_;
  return(*this);
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::Init(T c)
{
  if ((nrow_ == 0) || (ncol_ == 0))
    throw RangeCheckError("SimpleMatrix<T>::Init(T c) Size=0");
  data_ = c;
  return(*this);
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::Init(T c, T step)
{
  if ((nrow_ == 0) || (ncol_ == 0))
    throw RangeCheckError("SimpleMatrix<T>::Init(T c. T s) Size=0");
  for(sa_size_t k=0; k<nrow_*ncol_; k++) {
    data_(k) = c; c += step;
  }
  return(*this);
}

template <class T>
void SimpleMatrix<T>::Print(ostream& os) const
{
  os << " SimpleMatrix<T>(nr=" << nrow_ << ",nc=" << ncol_ << ")" << endl;
  for(sa_size_t r=0; r<nrow_; r++) {
    for(sa_size_t c=0; c<ncol_; c++) 
      os << (*this)(r,c) << " , " ;
    os << endl;
  } 
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::AddCst(T c)
{
  if ((nrow_ == 0) || (ncol_ == 0))
    throw RangeCheckError("SimpleMatrix<T>::AddCst() Size=0");
  data_ += c;
  return(*this);
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::MulCst(T c)
{
  if ((nrow_ == 0) || (ncol_ == 0))
    throw RangeCheckError("SimpleMatrix<T>::MulCst() Size=0");
  data_ *= c;
  return(*this);
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::AddElt(const SimpleMatrix & b)
{
  if (! CompareSize(b) ) 
    throw(SzMismatchError("SimpleMatrix::AddElt() Size(a) != Size(b)"));
  data_ += b.data_;
  return(*this);
}

template <class T>
SimpleMatrix<T>& SimpleMatrix<T>::MulElt(const SimpleMatrix & b)
{
  if (! CompareSize(b) ) 
    throw(SzMismatchError("SimpleMatrix::MulElt() Size(a) != Size(b)"));
  data_ *= b.data_;
  return(*this);
}

  
