// This may look like C code, but it is really -*- C++ -*-
// Classe de gestion d objets nommes pour piapp
// Reza      Aout 97 , Juillet,Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef NOBJMGR_H_SEEN
#define NOBJMGR_H_SEEN

#include "machdefs.h"

#include <fstream>
#include <string>
#include <vector>

#include "anydataobj.h"
#include "ppersist.h"
#include "dvlist.h"
#include "dlftypes.h"


class NObjMgrAdapter;
class PIStdImgApp;
class Services2NObjMgr;

class NamedObjMgr {
public:
// Constructeur et destructeur
			NamedObjMgr(bool fgimgapp=false);
  virtual		~NamedObjMgr();

  virtual void 		SetImgApp(PIStdImgApp* app);
  virtual void 		SetVerbose(bool fg=false);

// Gestion des variables globales (dans un DVList) 
  virtual bool          SetVar(string const & key, string const & val);
  virtual bool          HasVar(string const & key);
  virtual bool          DeleteVar(string const & key);
  virtual string        GetVar(string const & key);
  virtual DVList&       GetVarList();

// Gestion des repertoires (Repertoire d'objets en memoire)
  virtual bool		CreateDir(string & dirname);
  virtual bool		DeleteDir(string & dirname);
  virtual void		LockDir(string & dirname); 
  virtual void		UnlockDir(string & dirname);
  virtual void		SetKeepOldDirAtt(string & dirname, bool keepold=false); 
  virtual bool		SetCurrentDir(string & dirname);
  virtual void		GetCurrentDir(string & dirname);
  virtual void		ListDirs(string & patt);
  virtual void		GetDirList(string & patt, vector<string>& );
  virtual void		CleanDir(string & dirname);

//  Pour ajouter, supprimer et acceder aux objets 
  virtual bool		AddObj(AnyDataObj* obj, string & nom, bool crd=false);
  virtual bool		AddObj(AnyDataObj& obj, string & nom, bool crd=false);
  virtual bool		RenameObj(string & nom, string& nomnew);
  virtual bool          DelObj(string & nom, bool fgd=true);
  virtual void		DelObjects(string & patt, bool fgd=true); 
  virtual bool          DelObj_Id(int oid);
  virtual AnyDataObj*	GetObj(string & nom);
// Acces a l'adaptateur
  virtual NObjMgrAdapter*	GetObjAdapter(string & nom);
// Liste des objets
  virtual void          ListObjs(string & patt);  		
  virtual void          GetObjList(string & patt, vector<string>& );  		
// Methode CopyObj() a virer probablement (Reza 30/8/200 obsolete ?) 
  virtual bool          CopyObj(string & nom, string& nomcp);

//  Lecture et sauvegarde des objets sur fichier
  virtual void		ReadObj(PInPersist& s, int num=-1);
  virtual void		ReadObj(string const & nomppf, string & nobj);
  virtual void          ReadObj(vector<string> & flnm_objname);
  virtual void		ReadAll(string const & nomppf);
  virtual void          SaveObj(string & nom, POutPersist& s, bool keeppath=false);
  virtual void          SaveObjects(string & patt, string const& nomppf);
  virtual void          SaveListObjects(vector<string> &liste);
  virtual void          SaveAll(string const& nomppf);

// Info sur les objets 
  virtual void          PrintObj(string & nom, int lev=0);

//  Affichage des objets 
  virtual void          DisplayObj(string & nom, string dopt="");
  virtual void          DisplayImage(string & nom, string dopt="", bool fgimagnav=false);
  virtual void          DisplaySurf3D(string & nom, string dopt="");
  virtual void          DisplayNT(string & nom, string& nmx, string& nmy, string& nmz,  
                                  string& erx, string& ery, string& erz, string& wt,
                                  string& label, string& colornm, bool coloridx=false, 
				  string dopt="", bool fg3d=false);
  virtual void          DisplayGFD(string & nom, string& numvarx, string& numvary, 
                                   string& err, string dopt="");

  virtual void          DisplayVector(string & nomvx, string& nomvy, string dopt="");


// Acces au PIApplication et a la classe de service 
  virtual PIStdImgApp*		GetImgApp();
  virtual Services2NObjMgr* 	GetServiceObj();
  virtual string const&         GetTmpDir();
  virtual void                  SetTmpDir(string const& tmpdir);

// Ajoute un identificateur d'objet widget/drawer/fenetre pour l'objet nom
// Ces identificateurs servent lors de la destruction de l'objet nom
  virtual void		AddWRsId(string & nom, int wrsid);
// Pour utilisation par ObjMgrWind
  virtual void		UpdateObjMgrWindow(int did);

// Pour completer le nom de l'objet avec le nom du repertoire
  static void RemoveSpacesFromName(string & nom);
  static bool CheckDirName(string & nom);
  static int  ParseObjectName(string & nom, string & nomrep, string & nomobj);
// return true if name is valid
  static bool CheckName(string const & nom);

protected:
  // Les methodes _P sont celles SANS ZSync() - pour un usage interne par NamedObjMgr
  virtual bool		CreateDir_P(string & dirname);
  virtual void		CleanDir_P(string & dirname);
  virtual bool		AddObj_P(AnyDataObj* obj, string & nom, bool crd);
  virtual bool		RenameObj_P(string & nom, string& nomnew);
  virtual bool          DelObj_P(string & nom, bool fgd=true);
  virtual AnyDataObj*	GetObj_P(string & nom);
  virtual NObjMgrAdapter*	GetObjAdapter_P(string & nom);
  virtual void		ReadObj_P(PInPersist& s, int num=-1);
  virtual void          SaveObj_P(string & nom, POutPersist& s, bool keeppath=false);

  virtual void		AddWRsId_P(string & nom, int wrsid);
  virtual void		UpdateObjMgrWindow_P(int did);

  bool _fgimgapp;  // true -> cree par PIStdImgApp / pour gestion de thread
};


#endif
