// This may look like C code, but it is really -*- C++ -*-
// Classe de services destinee a NamedObjMgr pour piapp
// Reza                             Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef SERVNOBJM_H_SEEN
#define SERVNOBJM_H_SEEN

#include "machdefs.h"
#include <string>
#include <list>
#include <map>
#if defined(__KCC__)
using std::string ;
#include <list.h>
#include <map.h>
#endif

#include "pdlmgr.h"
#include "dlftypes.h"
#include "nomgadapter.h"

class NTuple;
class Histo;
class Histo2D;
class HProf;
class PIStdImgApp;

class Services2NObjMgr {
public:
         	Services2NObjMgr(PIStdImgApp* app, string& tmpdir);
  virtual	~Services2NObjMgr();

// Pour enregistrer les objets de donnees et leurs adaptateurs
  void			RegisterClass(AnyDataObj* o, NObjMgrAdapter* oa);
// Pour recuperer l'adaptateur pour un objet o 
  NObjMgrAdapter*	GetAdapter(AnyDataObj* o);

  inline void   SetImgApp(PIStdImgApp* app) {mImgapp = app; }

  void 		Nobj_ComputeExpressions(NObjMgrAdapter* obja, string& expx, string& expy, string& expz, 
                                        string& expwt, string& expcut,
                                        NTuple* nt=NULL, Histo* h1=NULL,
                                        Histo2D* h2=NULL, HProf* hp=NULL);
  PlotExprFunc  LinkExprFunc(string& vardec, string& expx, string& expy, string& expz, 
                             string& wt, string& cut);
  DlFunction    LinkFunctionFromFile(string const & fname, string const & funcname);
  void 		CloseDLL();  

// Trace de fonctions 1-D , 2-D
  virtual void  PlotFunc(string const & expfunc, float xmin, float xmax, int np=100, string dopt="");
  virtual void  PlotFunc2D(string const & expfunc, float xmin, float xmax, float ymin, float ymax, 
                           int npx=50, int npy=50, string dopt="");
  virtual void  PlotFuncFrCFile(string const & fname, string const & func, float xmin, float xmax, 
                                int np=100, string dopt="");
  virtual void  PlotFunc2DFrCFile(string const & fname, string const & func, float xmin, float xmax, 
                                  float ymin, float ymax, int npx=50, int npy=50, string dopt="");
  virtual void  PlotFunc(DlFunctionOfX f, float xmin, float xmax, int np=100, string dopt="");
  virtual void  PlotFunc2D(DlFunctionOfXY f, float xmin, float xmax, float ymin, float ymax, 
                           int npx=50, int npy=50, string dopt="");

// Utilitaires divers 
  string 	FileName2Name(string const & fn);
  int 		DecodeDispOption(string& dopt, bool& fgsrgr);

protected:
  void 		InitGrAttNames();

// Pour enregister les objets et leurs adaptateurs pour NamedObjMgr
  struct dataobj_adapter {
    AnyDataObj* obj;  NObjMgrAdapter* obja;
  };
  typedef list<dataobj_adapter> ObjAdaptList;
  ObjAdaptList objadaplist;

//   Variables membre , en public pour le moment
  struct gratt_item {
    int a1, a2;
  };
  typedef map<string, gratt_item, less<string> > GrAttNames;
  
//  Pour les changements d'attributs graphiques / de visualisation
  GrAttNames GrAcolors;
  GrAttNames GrAlines;
  GrAttNames GrAmarkers;
  GrAttNames GrAfonts;
  GrAttNames GrAcmap;  
  GrAttNames GrAzoom;  
  GrAttNames GrAaxes;  

  PDynLinkMgr * dynlink;  // shared-lib lib.so
  string TmpDir;          // Pour fichiers temporaires

  PIStdImgApp* mImgapp;
  
};


#endif
