//
// $Id: ctimer.cc,v 1.7 2007-07-06 12:54:12 ansari Exp $
//

#include "sopnamsp.h"
#include "machdefs.h"
#include "ctimer.h"

//++
// Class	Timer
// Lib  	SysTools
// include	ctimer.h
//
//	Chronomtrage de programmes. Le constructeur mmorise l'heure et
//      le temps CPU, ainsi qu'un message ventuel.
//
//	Split affiche le temps partiel.
//
//	Le destructeur affiche le temps total (CPU, et coul).
//    
//      Des macros permettent une utilisation simplifie :
//      * TIMEF   cre un objet de type Timer, avec le nom de la function 
//	courante comme message. Le temps coul sera affich  la sortie 
//	de la function.
//--



/*!
  \class SOPHYA::Timer
  \ingroup SysTools
  \brief Simple chronometer for CPU and elapsed time measurements.
  This class implements a simple chronometer which can be used for
  measuring the CPU and elapsed time in functions. The constructor
  keeps the start time (and CPU time) and an optional message. 
  The \b Split updates partial times and optionaly displays partial and 
  total CPU and elapsed time. 
  The destructor calls Split() if the object has been created with prfg=true.
  displays the total CPU and elapsed time since timer creation.
  The macro \b  TIMEF create a timer object with the function name.
  The elapsed and CPU time are displayed at the end of the bloc or function.
*/

/*! 
  \brief Constructor with the specification of a optional name or message 
  and default print flag.
  if \b prfg==true , a call to Split() causes the display of partial and 
  total CPU and elapsed time.
*/
Timer::Timer(const char* name, bool prfg)
  : timerName(name) , defprtflg(prfg)
{
  cpu0 = cpuSplit = clock();
  elapse0 = elapseSplit = time(0);
  cpuSecT = cpuSecP = 0.;
  elapSecT = elapSecP = 0;
}

//! The destructor call Split() if the object has been created with prtflag=true.
Timer::~Timer()
{
  if (defprtflg) Split();
}


/*! This method updates the CPU and elapsed time. 
    If the prfg==true or the constructor prfg==true, it also displays (prints) 
    the partial CPU and elapsed time
    An optional message can be passed to be used instead of the
    timer name
*/
void Timer::Split(const char* comm, bool prfg)
{
  time_t elapse = time(0);
  clock_t cpu   = clock();

  cpuSecT = ((float)cpu - (float)cpu0) / (float)(CLOCKS_PER_SEC);
  cpuSecP = ((float)cpu - (float)cpuSplit) / (float)(CLOCKS_PER_SEC);
  
  elapSecP  = elapse - elapseSplit;
  elapSecT = elapse - elapse0;


  //  cumlcpu += (double)cpuSecP;
  //  cumulelapse += (int_8)etm;

  elapseSplit = elapse;
  cpuSplit    = cpu;

  if ( !defprtflg && !prfg )  return;

  cout << "***Timing " << (comm ? comm : timerName.c_str()) << endl;

// Pour des formats comme ca, la syntaxe printf est plus agreable.
// Pour ne pas melanger stdio/iostream (pb de desynchronisation sur
// autres C++ que GNU), on fait un cout << chaine.

  int etm  = elapSecP;
  int etmt = elapSecT; 
  char out[200];
  sprintf(out,"CPU     Time: Total= %g (Partial= %g) Sec.",
	  cpuSecT, cpuSecP);
  cout << out << endl;

  sprintf(out,"Elapsed Time: Total= %02d:%02d:%02d (Partial=%02d:%02d:%02d)",
	  etmt/3600, (etmt%3600)/60, etmt%60, 
	  etm/3600,  (etm%3600)/60,  etm%60);

  cout << out << endl;
}

