// This may look like C code, but it is really -*- C++ -*-
// Classe de services destinee a NamedObjMgr pour piapp
// Reza                             Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef SERVNOBJM_H_SEEN
#define SERVNOBJM_H_SEEN

#include "machdefs.h"
#include <string>
#include <list>
#include <map>
#include <functional>

#include "nobjmgr.h"
#include "pdlmgr.h"
#include "dlftypes.h"
#include "anydataobj.h"

#include "zthread.h"

#ifdef SANS_EVOLPLANCK
class NTuple;
class Histo;
class Histo2D;
class HProf;
#else
namespace SOPHYA { 
class NTuple;
class Histo;
class Histo2D;
class HProf;
}
#endif

class PIStdImgApp;
class NObjMgrAdapter;

class Services2NObjMgr {
public:
         	Services2NObjMgr(string& tmpdir);
  virtual	~Services2NObjMgr();

// Pour enregistrer les objets de donnees et leurs adaptateurs
  void			RegisterClass(AnyDataObj* o, NObjMgrAdapter* oa);
// Pour recuperer l'adaptateur pour un objet o 
  NObjMgrAdapter*	GetAdapter(AnyDataObj* o);

  inline void   SetImgApp(PIStdImgApp* app) {mImgapp = app; }
  void          SetTmpDir(string const & tmpdir);
  inline NamedObjMgr*   MyObjMgr() 
  { 
    if (mOmg == NULL) mOmg = new NamedObjMgr; 
    return mOmg; 
  }
// Trace de fonctions 1-D , 2-D
  virtual void  PlotFunc(string const & expfunc, string & nom, double xmin, double xmax, 
                         int np=100, string dopt="");
  virtual void  PlotFunc2D(string const & expfunc, string & nom, double xmin, double xmax, 
                           double ymin, double ymax, int npx=50, int npy=50, string dopt="");
  virtual void  PlotFuncFrCFile(string const & fname, string const & func, string & nom, 
                                double xmin, double xmax, int np=100, string dopt="");
  virtual void  PlotFunc2DFrCFile(string const & fname, string const & func, string & nom, 
                                  double xmin, double xmax, double ymin, double ymax, 
                                  int npx=50, int npy=50, string dopt="");
  virtual void  PlotFunc(DlFunctionOfX f, string & nom, double xmin, double xmax, 
                         int np=100, string dopt="");
  virtual void  PlotFunc2D(DlFunctionOfXY f, string & nom, double xmin, double xmax, 
                           double ymin, double ymax, int npx=50, int npy=50, string dopt="");

// Calcul d'expression arithmetique
  virtual void ExpVal(string expval,string resultvarname="");

//  Trace d'expression de NTuple, et d'autres objets
  virtual void          DisplayPoints2D(string & nom, string& expx, string& expy,
                                        string& experrx, string& experry, 
                                        string& expcut, string dopt="", string loop="");
  virtual void          DisplayPoints3D(string & nom, string& expx, string& expy, string& expz, 
                                        string& expcut, string dopt="", string loop="");
  virtual void          DisplayPoints2DW(string & nom, string& expx, string& expy, 
                                         string& expwt, string& expcut, 
					 bool fgcolidx=false, string dopt="", string loop="");
  virtual void          DisplayPoints3DW(string & nom, string& expx, string& expy, string& expz, 
					 string& expwt, string& expcut, string dopt="", string loop="");

//  Projection d'expressions dans histogramme, vecteur/matrices (et trace) 
  virtual void          ProjectH1(string & nom, string& expx, string& expwt, string& expcut, 
                                  string& nomh1, string dopt="", string loop="");
  virtual void          ProjectH2(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomh2, string dopt="", string loop="");
  virtual void          ProjectHProf(string & nom, string& expx, string& expy, string& expwt, 
                                  string& expcut, string& nomprof, string dopt="", string loop="");

//  Remplissage de vecteurs, ntuples, GFD 
  virtual void          FillVect(string & nom, string& expx, string& expv, string& expcut, 
                                  string& nomvec, string dopt="", string loop="");
  virtual void          FillMatx(string & nom, string& expx, string& expy, string& expv, 
                                  string& expcut, string& nommtx, string dopt="", string loop="");

  virtual void          ExpressionToVector(string & nom, string& expx, string& expcut, 
                                           string& nomvec, string dopt="", string loop="");
  virtual void          NtFromASCIIFile(string& nom,string& filename,double def_val=0.);
  virtual void          FillNT(string & nom, string& expx, string& expy, string& expz,
                               string& expt, string& expcut, string& nomnt, string loop=""); 
  virtual void          FillGFD(string & nom, string& expx, string& expy, string& expz,
                               string& experr, string& expcut, string& nomgfd, string loop="");
  virtual void          FillGFDfrVec(string nomgfd,string namx,string namy,string namz,string name);
  virtual void          FillNTFrCFile(string & nom, string const & fname, 
                                      string const & funcname, string & nomnt, string loop="");
  virtual void		PrepareNTExpressionCFile(string & nomobj, string const & fname, 
                                                 string const & funcname);

// Calcul d'expressions d'interface NTuple pour les objets
  void 		ComputeExpressions(NObjMgrAdapter* obja, string& expx, string& expy, 
                                   string& expz, string& expt, string& expcut, string& loop,
                                   NTuple* nt=NULL, Histo* h1=NULL,
                                   Histo2D* h2=NULL, HProf* hp=NULL);
  PlotExprFunc  LinkExprFunc(string& vardec, string& expx, string& expy, 
                             string& expz, string& expt, string& cut);
  DlFunction    LinkFunctionFromFile(string const & fname, string const & funcname);
  void 		CloseDLL();  

// Execution de chaine de commande par l'interpreteur
  int	        ExecuteCommand(string line);

// Utilitaires divers 
  static void   DecodeLoopParameters(string& loop, int_8& i1, int_8& i2, int_8& di);
  string 	FileName2Name(string const & fn);
  char* 	PClassIdToClassName(int cid);

protected:

// Pour enregister les objets et leurs adaptateurs pour NamedObjMgr
  struct dataobj_adapter {
    AnyDataObj* obj;  NObjMgrAdapter* obja;
  };
  typedef list<dataobj_adapter> ObjAdaptList;
  ObjAdaptList objadaplist;


  PDynLinkMgr * dynlink;  // shared-lib lib.so
  string TmpDir;          // Pour fichiers temporaires
  // Mutex de controle de thread pour dynamic-link 
  ZMutex mutx_dynlink;

  PIStdImgApp* mImgapp;
  NamedObjMgr* mOmg;

  
};


#endif
