#ifndef PIOPTMENGEN_H_SEEN
#define PIOPTMENGEN_H_SEEN

#include "pisysdep.h"
#include PIMENU_H

class PIOptMenuGen : public PIWdg {
public:
  enum {ClassId = 1100};

	             PIOptMenuGen(PIContainerGen* par, const char* nom, int sx=50, int sy=15, int px=0, int py=0);
	             ~PIOptMenuGen();
				   
  virtual long       kind() {return ClassId; }

  inline  PIMenu*    Menu() {return mMen; }     // Renvoie un pointeur sur le menu associe 
  inline  void       AppendItem(const char* nom, PIMessage msg) 
                                   { mMen->AppendItem(nom, msg); }

  virtual string     GetValueStr() = 0;         // Option choisie
  virtual PIMessage  GetValue() = 0;            // Message correspondant a l option choisie
  virtual void       SetValueStr(string & s) = 0;
  virtual void       SetValue(PIMessage msg) = 0;

protected:
  PIMenu* mMen;

};

#endif
