// Module PI : Peida Interactive     PIPixmap
// Classe de base pour affichage de pixmap  Reza 96
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdlib.h>
#include <stdio.h>

#include "pipixmapgen.h"

// --------- Methodes de la classe PIPixMap  ----------
//++
// Class	PIPixmap
// Lib		PI
// include	pipixmapgen.h
//
//   	Classe pour la gestion optimise des pixmap.
//	Un pixmap est un tableau d'index dans une table de couleurs.
//	Cette classe gre actuellement des pixmaps avec des index
//	cods sur 8 bits (256 couleurs).
//	Pour des raisons d'optimisation, cette classe a une 
//	implmentation spcifique pour chaque plateforme.
//	La classe "PIPixmapGen" dfinit l'interface, et ne doit pas 
//	tre instancie directement.  Les objets instancis sont de la 
//	classes "PIPixmap" et le fichier entte correspondant est "PIPIXMAP_H"
//	dfini dans "pisysdep.h".
//--
//++
// Links	Parents
// PIBaseWdg
//--
//++
// Links	Voir aussi
// PIColorMap
//--

//++
// Titre	Constructeur, Pixmap
//--
//++
// PIPixmapGen(PIContainerGen *par, const char *nom, int sx=10, int sy=10, int px=0, int py=0)
//	Constructeur - Cration d'un "PIPIxmap".
// long  kind() 
//	Retourne le type ("=PIPixmap::ClassId")
// void  SetPixmap(unsigned char *pix, int sx, int sy, bool refr=true, int ox=0, int oy=0)
//	Associe un tableau d'index "pix" de taille "sx * sy".
//	(ox,oy)" dfinissent  l'offset d'affichage.
//	Si "refr=true", la mthode "Refresh()" est appele.
//--
//++
// Titre	Gestion de la table de couleur
//--
//++
// void  SetColMap(PIColorMap* cmp, bool refr=true)
//	Change la table de couleur associe.
//	Si "refr=true", la mthode "Refresh()" est appele.
// void  SetColMapId(CMapId cmapid, bool refr=true)
//	Change la table de couleur associe,  l'aide d'un identificateur
//	de table de couleur standard. ("CMapId cmapid").
//	Si "refr=true", la mthode "Refresh()" est appele.
// PIColorMap* GetColMap()
//	Retourne la table de couleur associe.
// CMapId GetColMapId() 
//	Retourne l'identificateur de la table de couleur associe.
// int NbCol()
//	Retourne le nombre de couleurs de la table de couleur associe.
//--

//++
// Titre	Actions
//--
//++
// void  But1Press(int x, int y)
//	L'action sur le bouton 1 dclenche l'envoi d'un message
//	avec le modifier PIMsg_Click. La position du bouton-press
//	est stock. (- Offset affichage)
// int  XPPos() 
//	Position X du click - Offset Affichage pixmap
// int  YPPos() 
//	Position Y du click - Offset Affichage pixmap
//--

/* --Methode-- */
PIPixmapGen::PIPixmapGen(PIContainerGen  *par, const char *nom,
                     int sx, int sy, int px, int py) :
PIBaseWdg(par, nom, sx, sy, px, py)
{
pixmap = NULL;
nx = ny = 0;
ofx = ofy = 0;
mPpos[0] = mPpos[0] = 0;
cmap = new PIColorMap(CMAP_GREY32);
ActivateButton(1);
}


/* --Methode-- */
PIPixmapGen::~PIPixmapGen()
{
delete cmap;
}

/* --Methode-- */
void PIPixmapGen::SetPixmap(unsigned char *pix, int sx, int sy, bool refr, int ox, int oy)
{
pixmap = pix; 
if (pixmap)
  {
  if (sx < 0)  sx = 0;
  if (sy < 0)  sy = 0;
  if (ox < 0)  ox = 0;
  if (oy < 0)  oy = 0;
  nx = sx; ny = sy;
  ofx = ox;  ofy = oy;
  }
else { ofx = ofy = nx = ny = 0; }
if (refr) Refresh();   
}

/* --Methode-- */
void PIPixmapGen::SetColMap(PIColorMap* cmp, bool refr)
{
if (!cmp)  return;
if ( (cmp->Type() == cmap->Type()) && (cmp->Type() != CMAP_OTHER) ) return;
if (cmap) delete cmap;
cmap = new PIColorMap(*cmp);
if (refr)  Refresh();  
}

/* --Methode-- */
void PIPixmapGen::SetColMapId(CMapId cmapid, bool refr)
{
if (!cmap || (cmap->Type() != cmapid) || (cmapid == CMAP_OTHER) ) {  
  if (cmap) delete cmap;
  cmap = new PIColorMap(cmapid);
  }
if (refr)  Refresh();  
}


/* --Methode-- */
void  PIPixmapGen::But1Press(int x, int y)
{
mPpos[0] = x-ofx;  mPpos[1] = y-ofy;  
if (Msg())  Send(Msg(), PIMsg_Click, mPpos);
return;
}



// Fin des methodes de la classe 


