// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive    PIContainerGen
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PICONTAINERBASE_SEEN
#define PICONTAINERBASE_SEEN

#include "pisysdep.h"

#include PIWDG_H

class PIContainerGen;
//  Classe gestionnaire du positionnement/tailles des PIWdg d'un PIContainer
class PILayoutMgr {
public:
  			PILayoutMgr();
  virtual 		~PILayoutMgr();

  inline  void		SetContainer(PIContainerGen* pic) { mCont = pic; }

  virtual void		ChildAdd(PIWdg* child);
  virtual void		ChildDel(PIWdg* child);

  inline  int		NbChilds() { return(mNCh); }
  inline  PIWdg*	GetChild(int n) 
                        { if ( (n < 0) || (n >= mNCh))  return(NULL);
                        else return (mChilds[n]); }
  inline  void		SetAutoDelChilds(bool ad = true) { mACSup = ad; } 

protected:
  PIWdg                ** mChilds;
  int                  mNCh, mMxCh;
  bool                 mPaSup, mACSup;
  PIContainerGen*      mCont;   // Le PIContainer auquel on est attache
};

// Classe conteneur pour le regroupement hierarchique (Fenetre/MsgHandler) des PIWdg
class PIContainerGen : public PIWdg 
{
public:
  enum {ClassId = 1500};

               PIContainerGen(PIContainerGen *par, const char *nom, 
                              int sx=10, int sy=10, int px=0, int py=0);
  virtual      ~PIContainerGen();

  virtual long         kind() {return ClassId; }

  virtual void	       SetLayoutMgr(PILayoutMgr* nlay);
  inline  PILayoutMgr* GetLayoutMgr() { return(layout); }

  virtual void         PSPrint(PSFile *psf, int ofx=0, int ofy=0);

  virtual void         Show();
  virtual void         Hide();
  virtual bool         Visible();

  virtual void         ChildAdd(PIWdg* child);
  virtual void         ChildDel(PIWdg* child);
  virtual int          NbChilds();
  virtual PIWdg*       GetChild(int n);
          void         SetAutoDelChilds(bool ad = true);

  virtual void	       FinishCreate(); // appelle FinishCreate() pour les descendants 

protected:
  bool                 stvis, stfcr;  // Statut visible ou pas, FinishCreate appele ou pas
  PILayoutMgr*         layout;        // Gestionnaire de positionnement (/tailles) des PIWdg fils
};

#endif
